/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/checkin/CodeAnalysisCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "codeSmells", "", "Lcom/intellij/codeInsight/CodeSmellInfo;", "(Ljava/util/List;)V", "getCodeSmells", "()Ljava/util/List;", "text", "", "getText", "()Ljava/lang/String;", "intellij.platform.vcs.impl"})
public final class CodeAnalysisCommitProblem
implements CommitProblem {
    @NotNull
    private final List<CodeSmellInfo> codeSmells;

    @NotNull
    public String getText() {
        int n;
        Iterable $this$count$iv = this.codeSmells;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CodeSmellInfo it = (CodeSmellInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSeverity(), (Object)HighlightSeverity.ERROR)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int errors = n;
        int warnings = this.codeSmells.size() - errors;
        String errorsText = errors > 0 ? HighlightSeverity.ERROR.getCountMessage(errors) : null;
        String warningsText = warnings > 0 ? HighlightSeverity.WARNING.getCountMessage(warnings) : null;
        String string = NlsMessages.formatAndList((Collection)CollectionsKt.listOfNotNull((Object[])new String[]{errorsText, warningsText}));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatAndList(listOfNotN\u2026rrorsText, warningsText))");
        return string;
    }

    @NotNull
    public final List<CodeSmellInfo> getCodeSmells() {
        return this.codeSmells;
    }

    public CodeAnalysisCommitProblem(@NotNull List<CodeSmellInfo> codeSmells2) {
        Intrinsics.checkNotNullParameter(codeSmells2, (String)"codeSmells");
        this.codeSmells = codeSmells2;
    }
}

