/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CodeAnalysisBeforeCheckinHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0003\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0003\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "askReviewCommitCancel", "", "project", "Lcom/intellij/openapi/project/Project;", "codeSmells", "", "Lcom/intellij/codeInsight/CodeSmellInfo;", "commitActionText", "", "confirmCommitInDumbMode", "", "confirmCommitWithCodeAnalysisFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getDescription", "intellij.platform.vcs.impl"})
public final class CodeAnalysisBeforeCheckinHandlerKt {
    private static final Logger LOG;

    private static final boolean confirmCommitInDumbMode(Project project) {
        String string = VcsBundle.message((String)"code.smells.error.indexing", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"code.smells.error.indexing\")");
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        objectArray[0] = applicationNamesInfo.getProductName();
        String string2 = VcsBundle.message((String)"code.smells.error.indexing.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"code.smells.err\u2026etInstance().productName)");
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(null);
        String string3 = VcsBundle.message((String)"checkin.wait", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"checkin.wait\")");
        MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
        String string4 = VcsBundle.message((String)"checkin.commit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"checkin.commit\")");
        return !((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).ask(project);
    }

    private static final boolean confirmCommitWithCodeAnalysisFailure(Project project, Exception e) {
        String string = VcsBundle.message((String)"checkin.code.analysis.failed", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"checkin.code.analysis.failed\")");
        String string2 = VcsBundle.message((String)"checkin.code.analysis.failed.with.exception.name.message", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"checkin.code.an\u2026avaClass.name, e.message)");
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(null);
        String string3 = VcsBundle.message((String)"checkin.commit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"checkin.commit\")");
        MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
        String string4 = VcsBundle.message((String)"checkin.cancel", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"checkin.cancel\")");
        return ((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).ask(project);
    }

    @Messages.YesNoCancelResult
    private static final int askReviewCommitCancel(Project project, List<CodeSmellInfo> codeSmells2, @NlsContexts.Button String commitActionText) {
        String string = VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"code.smells.error.messages.tab.name\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel = (MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.Companion.yesNoCancel(string, CodeAnalysisBeforeCheckinHandlerKt.getDescription(codeSmells2)).icon(UIUtil.getWarningIcon());
        String string2 = VcsBundle.message((String)"code.smells.review.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"code.smells.review.button\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string2)).noText(commitActionText);
        String string3 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButtonText()");
        return yesNoCancel2.cancelText(string3).show(project);
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.DialogMessage
    private static final String getDescription(List<CodeSmellInfo> codeSmells2) {
        void destination$iv;
        void $this$mapTo$iv;
        int n;
        Iterable $this$count$iv = codeSmells2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CodeSmellInfo it = (CodeSmellInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSeverity(), (Object)HighlightSeverity.ERROR)) continue;
                int n2 = ++count$iv;
                bl = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int errorCount = n;
        int warningCount = codeSmells2.size() - errorCount;
        Iterable count$iv = codeSmells2;
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CodeSmellInfo codeSmellInfo = (CodeSmellInfo)item$iv;
            void var11_20 = destination$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(it.getDocument());
            var11_20.add(virtualFile);
        }
        Set virtualFiles = (Set)destination$iv;
        if (virtualFiles.size() == 1) {
            Object object = CollectionsKt.first((Iterable)virtualFiles);
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"virtualFiles.first()!!");
            String string = FileUtil.toSystemDependentName((String)FileUtil.getLocationRelativeToUserHome((String)((VirtualFile)object).getPath()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(ge\u2026ualFiles.first()!!.path))");
            String path2 = string;
            String string2 = VcsBundle.message((String)"before.commit.file.contains.code.smells.edit.them.confirm.text", (Object[])new Object[]{path2, errorCount, warningCount});
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"before.commit.f\u2026errorCount, warningCount)");
            return string2;
        }
        String string = VcsBundle.message((String)"before.commit.files.contain.code.smells.edit.them.confirm.text", (Object[])new Object[]{virtualFiles.size(), errorCount, warningCount});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"before.commit.f\u2026errorCount, warningCount)");
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeAnalysisBeforeCheckinHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$confirmCommitInDumbMode(Project project) {
        return CodeAnalysisBeforeCheckinHandlerKt.confirmCommitInDumbMode(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$confirmCommitWithCodeAnalysisFailure(Project project, Exception e) {
        return CodeAnalysisBeforeCheckinHandlerKt.confirmCommitWithCodeAnalysisFailure(project, e);
    }

    public static final /* synthetic */ int access$askReviewCommitCancel(Project project, List codeSmells2, String commitActionText) {
        return CodeAnalysisBeforeCheckinHandlerKt.askReviewCommitCancel(project, codeSmells2, commitActionText);
    }
}

