/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.changes.ui.browser.BulkMovesOnlyChangesFilter;
import com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer;
import com.intellij.ui.GuiUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 /2\u00020\u0001:\b/0123456B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0016JH\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0 H\u0002J\b\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020\u001aH\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J\b\u0010+\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007J\u0012\u0010-\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010.\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "listener", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;)V", "LOCK", "", "activeFilter", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "filteredOutChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getListener", "()Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;", "pendingChanges", "processedChanges", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rawChanges", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "clearFilter", "", "dispose", "filterChanges", "changes", "filter", "pending", "", "processed", "filteredOut", "getFilteredChanges", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState;", "getProgress", "", "hasActiveFilter", "", "queueUpdatePresentation", "resetFilter", "restartLoading", "setChanges", "setFilter", "updatePresentation", "Companion", "Filter", "FilterGroup", "FilteredState", "Listener", "MovesOnlyFilter", "NonImportantFilter", "ToggleFilterAction", "intellij.platform.vcs.impl"})
public final class ChangesFilterer
implements Disposable {
    private final Object LOCK;
    private final MergingUpdateQueue updateQueue;
    private ProgressIndicator progressIndicator;
    private List<? extends Change> rawChanges;
    private Filter activeFilter;
    private List<? extends Change> processedChanges;
    private List<? extends Change> pendingChanges;
    private List<? extends Change> filteredOutChanges;
    @Nullable
    private final Project project;
    @NotNull
    private final Listener listener;
    @JvmField
    @NotNull
    public static final DataKey<ChangesFilterer> DATA_KEY;
    @NotNull
    public static final Companion Companion;

    public void dispose() {
        this.resetFilter();
    }

    @RequiresEdt
    public final void setChanges(@Nullable List<? extends Change> changes) {
        List<? extends Change> oldChanges = this.rawChanges;
        if (oldChanges == null && changes == null) {
            return;
        }
        if (oldChanges != null && changes != null && ContainerUtil.equalsIdentity(oldChanges, changes)) {
            return;
        }
        List<? extends Change> list = changes;
        this.rawChanges = list != null ? CollectionsKt.toList((Iterable)list) : null;
        this.restartLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    @NotNull
    public final FilteredState getFilteredChanges() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            FilteredState filteredState;
            boolean bl3 = false;
            List<? extends Change> processed = this.processedChanges;
            List<? extends Change> pending2 = this.pendingChanges;
            List<? extends Change> filteredOut = this.filteredOutChanges;
            if (processed != null && pending2 != null && filteredOut != null) {
                filteredState = FilteredState.Companion.create(processed, pending2, filteredOut);
            } else {
                List list = this.rawChanges;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                filteredState = FilteredState.Companion.create(list);
            }
            FilteredState filteredState2 = filteredState;
            return filteredState2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final float getProgress() {
        Integer totalCount;
        Integer n;
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            List<? extends Change> list = this.pendingChanges;
            n = list != null ? Integer.valueOf(list.size()) : null;
        }
        Integer pendingCount = n;
        List<? extends Change> list = this.rawChanges;
        Integer n2 = totalCount = list != null ? Integer.valueOf(list.size()) : null;
        if (pendingCount == null || totalCount == null || totalCount == 0) {
            return 1.0f;
        }
        return RangesKt.coerceAtLeast((float)(1.0f - (float)pendingCount.intValue() / (float)totalCount.intValue()), (float)0.0f);
    }

    @NotNull
    public final boolean hasActiveFilter() {
        return this.activeFilter != null;
    }

    public final void clearFilter() {
        this.setFilter(null);
    }

    private final void setFilter(Filter filter) {
        this.activeFilter = filter;
        this.restartLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restartLoading() {
        ProgressIndicator indicator = this.resetFilter();
        Filter filter = this.activeFilter;
        List<? extends Change> changesToFilter = this.rawChanges;
        if (filter == null || changesToFilter == null) {
            this.updatePresentation();
            return;
        }
        Iterable iterable = changesToFilter;
        Comparator<Change> comparator = ChangesComparator.getInstance(false);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"ChangesComparator.getInstance(false)");
        List changes = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        List pending2 = CollectionsKt.asReversedMutable((List)SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed((List)changes)), (Function1)restartLoading.pending.1.INSTANCE)));
        boolean bl = false;
        List processed = new ArrayList();
        boolean bl2 = false;
        List filteredOut = new ArrayList();
        Object object = this.LOCK;
        boolean bl3 = false;
        boolean bl4 = false;
        synchronized (object) {
            boolean bl5 = false;
            this.processedChanges = processed;
            this.pendingChanges = pending2;
            this.filteredOutChanges = filteredOut;
            Unit unit = Unit.INSTANCE;
        }
        this.updatePresentation();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, changes, filter, pending2, processed, filteredOut, indicator){
            final /* synthetic */ ChangesFilterer this$0;
            final /* synthetic */ List $changes;
            final /* synthetic */ Filter $filter;
            final /* synthetic */ List $pending;
            final /* synthetic */ List $processed;
            final /* synthetic */ List $filteredOut;
            final /* synthetic */ ProgressIndicator $indicator;

            public final void run() {
                ProgressManager.getInstance().runProcess(new Runnable(this){
                    final /* synthetic */ restartLoading.2 this$0;

                    public final void run() {
                        ChangesFilterer.access$filterChanges(this.this$0.this$0, this.this$0.$changes, this.this$0.$filter, this.this$0.$pending, this.this$0.$processed, this.this$0.$filteredOut);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, this.$indicator);
            }
            {
                this.this$0 = changesFilterer;
                this.$changes = list;
                this.$filter = filter;
                this.$pending = list2;
                this.$processed = list3;
                this.$filteredOut = list4;
                this.$indicator = progressIndicator;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void filterChanges(List<? extends Change> changes, Filter filter, List<Change> pending2, List<Change> processed, List<Change> filteredOut) {
        this.queueUpdatePresentation();
        Collection<Change> filteredChanges = filter.acceptBulk(this, changes);
        if (filteredChanges != null) {
            Object object = this.LOCK;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                ProgressManager.checkCanceled();
                pending2.clear();
                processed.addAll(filteredChanges);
                Set filteredOutSet = CollectionsKt.toMutableSet((Iterable)changes);
                filteredOutSet.removeAll(filteredChanges);
                bl2 = filteredOut.addAll(filteredOutSet);
            }
            this.updatePresentation();
            return;
        }
        for (Change change : changes) {
            ProgressManager.checkCanceled();
            boolean accept2 = filter.accept(this, change);
            Object object = this.LOCK;
            boolean bl = false;
            boolean bl4 = false;
            synchronized (object) {
                boolean bl5 = false;
                ProgressManager.checkCanceled();
                pending2.remove(0);
                bl4 = accept2 ? processed.add(change) : filteredOut.add(change);
            }
            this.queueUpdatePresentation();
        }
        this.updatePresentation();
    }

    private final void queueUpdatePresentation() {
        this.updateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)((Disposable)this.updateQueue), (Object)"update", (Runnable)new Runnable(this){
            final /* synthetic */ ChangesFilterer this$0;

            public final void run() {
                ChangesFilterer.access$updatePresentation(this.this$0);
            }
            {
                this.this$0 = changesFilterer;
            }
        }));
    }

    private final void updatePresentation() {
        GuiUtils.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ ChangesFilterer this$0;

            public final void run() {
                ChangesFilterer.access$getUpdateQueue$p(this.this$0).cancelAllUpdates();
                this.this$0.getListener().updateChanges();
            }
            {
                this.this$0 = changesFilterer;
            }
        }, (ModalityState)ModalityState.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProgressIndicator resetFilter() {
        Object object = this.LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.processedChanges = null;
            this.pendingChanges = null;
            this.filteredOutChanges = null;
            this.progressIndicator.cancel();
            ProgressIndicator progressIndicator = this.progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            return progressIndicator;
        }
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Listener getListener() {
        return this.listener;
    }

    public ChangesFilterer(@Nullable Project project, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.project = project;
        this.listener = listener2;
        this.LOCK = new Object();
        this.updateQueue = new MergingUpdateQueue("ChangesFilterer", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
        this.progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
    }

    static {
        Companion = new Companion(null);
        DataKey dataKey = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DataKey.create(\"com.inte\u2026browser.ChangesFilterer\")");
        DATA_KEY = dataKey;
    }

    public static final /* synthetic */ void access$setRawChanges$p(ChangesFilterer $this, List list) {
        $this.rawChanges = list;
    }

    public static final /* synthetic */ void access$setActiveFilter$p(ChangesFilterer $this, Filter filter) {
        $this.activeFilter = filter;
    }

    public static final /* synthetic */ void access$filterChanges(ChangesFilterer $this, List changes, Filter filter, List pending2, List processed, List filteredOut) {
        $this.filterChanges(changes, filter, pending2, processed, filteredOut);
    }

    public static final /* synthetic */ void access$updatePresentation(ChangesFilterer $this) {
        $this.updatePresentation();
    }

    public static final /* synthetic */ MergingUpdateQueue access$getUpdateQueue$p(ChangesFilterer $this) {
        return $this.updateQueue;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J&\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0017J\b\u0010\u000e\u001a\u00020\rH'J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "", "accept", "", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "acceptBulk", "", "changes", "", "getDescription", "", "getText", "isAvailable", "intellij.platform.vcs.impl"})
    private static interface Filter {
        public boolean isAvailable(@NotNull ChangesFilterer var1);

        public boolean accept(@NotNull ChangesFilterer var1, @NotNull Change var2);

        @Nullable
        public Collection<Change> acceptBulk(@NotNull ChangesFilterer var1, @NotNull List<? extends Change> var2);

        @Nls
        @NotNull
        public String getText();

        @Nls
        @Nullable
        public String getDescription();

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static boolean isAvailable(@NotNull Filter $this, @NotNull ChangesFilterer filterer) {
                Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
                return true;
            }

            @Nullable
            public static Collection<Change> acceptBulk(@NotNull Filter $this, @NotNull ChangesFilterer filterer, @NotNull List<? extends Change> changes) {
                Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                return null;
            }

            @Nls
            @Nullable
            public static String getDescription(@NotNull Filter $this) {
                return null;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$MovesOnlyFilter;", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "()V", "accept", "", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "acceptBulk", "", "changes", "", "getText", "", "intellij.platform.vcs.impl"})
    private static final class MovesOnlyFilter
    implements Filter {
        @NotNull
        public static final MovesOnlyFilter INSTANCE;

        @Override
        @NotNull
        public String getText() {
            String string = VcsBundle.message((String)"action.filter.moved.files.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"actio\u2026filter.moved.files.text\")");
            return string;
        }

        @Override
        @Nullable
        public Collection<Change> acceptBulk(@NotNull ChangesFilterer filterer, @NotNull List<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            ExtensionPointName<BulkMovesOnlyChangesFilter> extensionPointName = BulkMovesOnlyChangesFilter.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"BulkMovesOnlyChangesFilter.EP_NAME");
            for (BulkMovesOnlyChangesFilter epFilter : extensionPointName.getExtensionList()) {
                Collection<Change> filteredChanges = epFilter.filter(filterer.getProject(), changes);
                if (filteredChanges == null) continue;
                return filteredChanges;
            }
            return null;
        }

        @Override
        public boolean accept(@NotNull ChangesFilterer filterer, @NotNull Change change) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            ContentRevision contentRevision = change.getBeforeRevision();
            if (contentRevision == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)contentRevision, (String)"change.beforeRevision ?: return true");
            ContentRevision bRev = contentRevision;
            ContentRevision contentRevision2 = change.getAfterRevision();
            if (contentRevision2 == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)contentRevision2, (String)"change.afterRevision ?: return true");
            ContentRevision aRev = contentRevision2;
            if (Intrinsics.areEqual((Object)bRev.getFile(), (Object)aRev.getFile())) {
                return true;
            }
            if (bRev instanceof ByteBackedContentRevision && aRev instanceof ByteBackedContentRevision) {
                byte[] byArray = ((ByteBackedContentRevision)bRev).getContentAsBytes();
                if (byArray == null) {
                    return true;
                }
                byte[] bytes1 = byArray;
                byte[] byArray2 = ((ByteBackedContentRevision)aRev).getContentAsBytes();
                if (byArray2 == null) {
                    return true;
                }
                byte[] bytes2 = byArray2;
                byte[] byArray3 = bytes1;
                boolean bl = false;
                return !Arrays.equals(byArray3, bytes2);
            }
            String string = bRev.getContent();
            if (string == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bRev.content ?: return true");
            String content1 = string;
            String string2 = aRev.getContent();
            if (string2 == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"aRev.content ?: return true");
            String content2 = string2;
            return Intrinsics.areEqual((Object)content1, (Object)content2) ^ true;
        }

        private MovesOnlyFilter() {
        }

        static {
            MovesOnlyFilter movesOnlyFilter;
            INSTANCE = movesOnlyFilter = new MovesOnlyFilter();
        }

        @Override
        public boolean isAvailable(@NotNull ChangesFilterer filterer) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            return Filter.DefaultImpls.isAvailable(this, filterer);
        }

        @Override
        @Nls
        @Nullable
        public String getDescription() {
            return Filter.DefaultImpls.getDescription(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$NonImportantFilter;", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "()V", "accept", "", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getText", "", "isAvailable", "intellij.platform.vcs.impl"})
    private static final class NonImportantFilter
    implements Filter {
        @NotNull
        public static final NonImportantFilter INSTANCE;

        @Override
        @NotNull
        public String getText() {
            String string = VcsBundle.message((String)"action.filter.non.important.files.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"actio\u2026on.important.files.text\")");
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull ChangesFilterer filterer) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            return filterer.getProject() != null;
        }

        @Override
        public boolean accept(@NotNull ChangesFilterer filterer, @NotNull Change change) {
            Object object;
            DocumentContent diffContent2;
            DocumentContent diffContent1;
            String content2;
            String content1;
            Project project;
            block6: {
                Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                project = filterer.getProject();
                ContentRevision contentRevision = change.getBeforeRevision();
                if (contentRevision == null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)contentRevision, (String)"change.beforeRevision ?: return true");
                ContentRevision bRev = contentRevision;
                ContentRevision contentRevision2 = change.getAfterRevision();
                if (contentRevision2 == null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)contentRevision2, (String)"change.afterRevision ?: return true");
                ContentRevision aRev = contentRevision2;
                String string = bRev.getContent();
                if (string == null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bRev.content ?: return true");
                content1 = string;
                String string2 = aRev.getContent();
                if (string2 == null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"aRev.content ?: return true");
                content2 = string2;
                DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
                FilePath filePath = bRev.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"bRev.file");
                DocumentContent documentContent = diffContentFactory.create(project, content1, filePath.getFileType());
                Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"DiffContentFactory.getIn\u2026ent1, bRev.file.fileType)");
                diffContent1 = documentContent;
                DiffContentFactory diffContentFactory2 = DiffContentFactory.getInstance();
                FilePath filePath2 = aRev.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"aRev.file");
                DocumentContent documentContent2 = diffContentFactory2.create(project, content2, filePath2.getFileType());
                Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"DiffContentFactory.getIn\u2026ent2, aRev.file.fileType)");
                diffContent2 = documentContent2;
                ExtensionPointName extensionPointName = DiffIgnoredRangeProvider.EP_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"DiffIgnoredRangeProvider.EP_NAME");
                Object[] objectArray = extensionPointName.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"DiffIgnoredRangeProvider.EP_NAME.extensions");
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                Object[] objectArray3 = objectArray2;
                boolean bl2 = false;
                for (Object object2 : objectArray3) {
                    DiffIgnoredRangeProvider it = (DiffIgnoredRangeProvider)object2;
                    boolean bl3 = false;
                    if (!(it.accepts(project, (DiffContent)diffContent1) && it.accepts(project, (DiffContent)diffContent2))) continue;
                    object = object2;
                    break block6;
                }
                object = null;
            }
            DiffIgnoredRangeProvider provider = (DiffIgnoredRangeProvider)object;
            if (provider == null) {
                return Intrinsics.areEqual((Object)content1, (Object)content2) ^ true;
            }
            List list = provider.getIgnoredRanges(project, (CharSequence)content1, (DiffContent)diffContent1);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"provider.getIgnoredRange\u2026, content1, diffContent1)");
            List ignoredRanges1 = list;
            List list2 = provider.getIgnoredRanges(project, (CharSequence)content2, (DiffContent)diffContent2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"provider.getIgnoredRange\u2026, content2, diffContent2)");
            List ignoredRanges2 = list2;
            BitSet bitSet = ComparisonManagerImpl.collectIgnoredRanges((List)ignoredRanges1);
            Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"ComparisonManagerImpl.co\u2026redRanges(ignoredRanges1)");
            BitSet ignored1 = bitSet;
            BitSet bitSet2 = ComparisonManagerImpl.collectIgnoredRanges((List)ignoredRanges2);
            Intrinsics.checkNotNullExpressionValue((Object)bitSet2, (String)"ComparisonManagerImpl.co\u2026redRanges(ignoredRanges2)");
            BitSet ignored2 = bitSet2;
            Range range = TrimUtil.trimExpandText((CharSequence)content1, (CharSequence)content2, (int)0, (int)0, (int)content1.length(), (int)content2.length(), (BitSet)ignored1, (BitSet)ignored2);
            return !range.isEmpty();
        }

        private NonImportantFilter() {
        }

        static {
            NonImportantFilter nonImportantFilter;
            INSTANCE = nonImportantFilter = new NonImportantFilter();
        }

        @Override
        @Nullable
        public Collection<Change> acceptBulk(@NotNull ChangesFilterer filterer, @NotNull List<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return Filter.DefaultImpls.acceptBulk(this, filterer, changes);
        }

        @Override
        @Nls
        @Nullable
        public String getDescription() {
            return Filter.DefaultImpls.getDescription(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;", "", "updateChanges", "", "intellij.platform.vcs.impl"})
    public static interface Listener {
        public void updateChanges();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \f2\u00020\u0001:\u0001\fB1\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState;", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "pending", "filteredOut", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "getFilteredOut", "getPending", "Companion", "intellij.platform.vcs.impl"})
    public static final class FilteredState {
        @NotNull
        private final List<Change> changes;
        @NotNull
        private final List<Change> pending;
        @NotNull
        private final List<Change> filteredOut;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final List<Change> getChanges() {
            return this.changes;
        }

        @NotNull
        public final List<Change> getPending() {
            return this.pending;
        }

        @NotNull
        public final List<Change> getFilteredOut() {
            return this.filteredOut;
        }

        private FilteredState(List<? extends Change> changes, List<? extends Change> pending2, List<? extends Change> filteredOut) {
            this.changes = changes;
            this.pending = pending2;
            this.filteredOut = filteredOut;
        }

        public /* synthetic */ FilteredState(List changes, List pending2, List filteredOut, DefaultConstructorMarker $constructor_marker) {
            this(changes, pending2, filteredOut);
        }

        @JvmStatic
        @NotNull
        public static final FilteredState create(@NotNull List<? extends Change> changes) {
            return Companion.create(changes);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J0\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState$Companion;", "", "()V", "create", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "pending", "filteredOut", "intellij.platform.vcs.impl"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final FilteredState create(@NotNull List<? extends Change> changes) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                return this.create(changes, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }

            @NotNull
            public final FilteredState create(@NotNull List<? extends Change> changes, @NotNull List<? extends Change> pending2, @NotNull List<? extends Change> filteredOut) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Intrinsics.checkNotNullParameter(pending2, (String)"pending");
                Intrinsics.checkNotNullParameter(filteredOut, (String)"filteredOut");
                return new FilteredState(CollectionsKt.toList((Iterable)changes), CollectionsKt.toList((Iterable)pending2), CollectionsKt.toList((Iterable)filteredOut), null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilterGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "disableIfNoVisibleChildren", "", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "", "intellij.platform.vcs.impl"})
    public static final class FilterGroup
    extends DefaultActionGroup
    implements Toggleable,
    DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChangesFilterer filterer = (ChangesFilterer)e.getData(DATA_KEY);
            if (filterer == null) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabledAndVisible(false);
                return;
            }
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setVisible(true);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(filterer.rawChanges != null);
            Toggleable.setSelected((Presentation)e.getPresentation(), (filterer.activeFilter != null ? 1 : 0) != 0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            void $this$mapTo$iv$iv;
            Filter it;
            Iterable $this$filterTo$iv$iv;
            Object object = e;
            if (object == null || (object = (ChangesFilterer)object.getData(DATA_KEY)) == null) {
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
                return AnAction.EMPTY_ARRAY;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e?.getData(DATA_KEY) ?: \u2026turn AnAction.EMPTY_ARRAY");
            Object filterer = object;
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])new Filter[]{MovesOnlyFilter.INSTANCE, NonImportantFilter.INSTANCE});
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Filter)element$iv$iv;
                boolean bl = false;
                if (!it.isAvailable((ChangesFilterer)filterer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Filter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ToggleFilterAction toggleFilterAction = new ToggleFilterAction((ChangesFilterer)filterer, it);
                collection.add(toggleFilterAction);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }

        public boolean disableIfNoVisibleChildren() {
            return false;
        }

        public FilterGroup() {
            this.setPopup(true);
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
            presentation.setText(VcsBundle.message((String)"action.filter.filter.by.text", (Object[])new Object[0]));
            Presentation presentation2 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
            presentation2.setIcon(AllIcons.General.Filter);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$ToggleFilterAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "filter", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "(Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;)V", "getFilter", "()Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "getFilterer", "()Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.platform.vcs.impl"})
    private static final class ToggleFilterAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ChangesFilterer filterer;
        @NotNull
        private final Filter filter;

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return Intrinsics.areEqual((Object)this.filterer.activeFilter, (Object)this.filter);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.filterer.setFilter(state ? this.filter : null);
        }

        @NotNull
        public final ChangesFilterer getFilterer() {
            return this.filterer;
        }

        @NotNull
        public final Filter getFilter() {
            return this.filter;
        }

        public ToggleFilterAction(@NotNull ChangesFilterer filterer, @NotNull Filter filter) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            super(filter.getText(), filter.getDescription(), null);
            this.filterer = filterer;
            this.filter = filter;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Companion;", "", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

