/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ActionToolbarGotItTooltip;
import com.intellij.openapi.vcs.changes.ui.ActionToolbarGotItTooltipKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SwitchToCommitDialogHint;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManagerListener;", "toolWindow", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "(Lcom/intellij/openapi/wm/ex/ToolWindowEx;Lcom/intellij/openapi/actionSystem/ActionToolbar;)V", "actionToolbarTooltip", "Lcom/intellij/openapi/vcs/changes/ui/ActionToolbarGotItTooltip;", "toolWindowMappingChanged", "", "Companion", "intellij.platform.vcs.impl"})
public final class SwitchToCommitDialogHint
implements ChangesViewContentManagerListener {
    private final ActionToolbarGotItTooltip actionToolbarTooltip;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void toolWindowMappingChanged() {
        this.actionToolbarTooltip.hideHint(true);
    }

    public SwitchToCommitDialogHint(@NotNull ToolWindowEx toolWindow, @NotNull ActionToolbar toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        String string = VcsBundle.message((String)"switch.to.commit.dialog.hint.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"switch.to.commit.dialog.hint.text\")");
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"toolWindow.disposable");
        this.actionToolbarTooltip = new ActionToolbarGotItTooltip("changes.view.toolwindow", string, disposable, toolbar, ActionToolbarGotItTooltipKt.getGearButtonOrToolbar());
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"toolWindow.project");
        project.getMessageBus().connect(this.actionToolbarTooltip.getTooltipDisposable()).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SwitchToCommitDialogHint$Companion;", "", "()V", "install", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        public final void install(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Commit");
            if (!(toolWindow instanceof ToolWindowEx)) {
                toolWindow = null;
            }
            ToolWindowEx toolWindowEx = (ToolWindowEx)toolWindow;
            if (toolWindowEx == null) {
                return;
            }
            ToolWindowEx toolWindow2 = toolWindowEx;
            InternalDecorator internalDecorator = toolWindow2.getDecorator();
            Intrinsics.checkNotNullExpressionValue((Object)internalDecorator, (String)"toolWindow.decorator");
            ActionToolbar actionToolbar = internalDecorator.getHeaderToolbar();
            if (actionToolbar == null) {
                return;
            }
            ActionToolbar toolbar = actionToolbar;
            new SwitchToCommitDialogHint(toolWindow2, toolbar);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

