/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilesDialog
extends AbstractSelectFilesDialog {
    @NotNull
    private final VirtualFileList myFileList;
    private final boolean myDeletableFiles;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected SelectFilesDialog(Project project, @NotNull List<? extends VirtualFile> files, @Nullable @NlsContexts.Label String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        if (files == null) {
            SelectFilesDialog.$$$reportNull$$$0(0);
        }
        this(project, files, prompt, (VcsShowConfirmationOption)(showDoNotAskOption ? confirmationOption : null), selectableFiles, deletableFiles);
    }

    protected SelectFilesDialog(Project project, @NotNull List<? extends VirtualFile> files, @Nullable @NlsContexts.Label String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles) {
        if (files == null) {
            SelectFilesDialog.$$$reportNull$$$0(1);
        }
        super(project, false, confirmationOption, prompt);
        this.myDeletableFiles = deletableFiles;
        this.myFileList = new VirtualFileList(project, selectableFiles, deletableFiles, files);
    }

    @Deprecated
    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @Nullable @NlsContexts.Label String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        if (originalFiles == null) {
            SelectFilesDialog.$$$reportNull$$$0(2);
        }
        return SelectFilesDialog.init(project, originalFiles, prompt, (VcsShowConfirmationOption)(showDoNotAskOption ? confirmationOption : null), selectableFiles, deletableFiles);
    }

    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @Nullable @NlsContexts.Label String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles) {
        if (originalFiles == null) {
            SelectFilesDialog.$$$reportNull$$$0(3);
        }
        SelectFilesDialog dialog = new SelectFilesDialog(project, originalFiles, prompt, confirmationOption, selectableFiles, deletableFiles);
        dialog.init();
        SelectFilesDialog selectFilesDialog = dialog;
        if (selectFilesDialog == null) {
            SelectFilesDialog.$$$reportNull$$$0(4);
        }
        return selectFilesDialog;
    }

    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @Nullable @NlsContexts.Label String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles, @NotNull @NlsContexts.Button String okActionName, @NotNull @NlsContexts.Button String cancelActionName) {
        if (originalFiles == null) {
            SelectFilesDialog.$$$reportNull$$$0(5);
        }
        if (okActionName == null) {
            SelectFilesDialog.$$$reportNull$$$0(6);
        }
        if (cancelActionName == null) {
            SelectFilesDialog.$$$reportNull$$$0(7);
        }
        SelectFilesDialog dlg = SelectFilesDialog.init(project, originalFiles, prompt, confirmationOption, selectableFiles, deletableFiles);
        dlg.setOKButtonText(okActionName);
        dlg.setCancelButtonText(cancelActionName);
        SelectFilesDialog selectFilesDialog = dlg;
        if (selectFilesDialog == null) {
            SelectFilesDialog.$$$reportNull$$$0(8);
        }
        return selectFilesDialog;
    }

    public Collection<VirtualFile> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }

    public void setSelectedFiles(@NotNull Collection<VirtualFile> selected) {
        if (selected == null) {
            SelectFilesDialog.$$$reportNull$$$0(9);
        }
        this.myFileList.setIncludedChanges(selected);
        this.myFileList.rebuildTree();
    }

    @Override
    @NotNull
    protected ChangesTree getFileList() {
        VirtualFileList virtualFileList = this.myFileList;
        if (virtualFileList == null) {
            SelectFilesDialog.$$$reportNull$$$0(10);
        }
        return virtualFileList;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        DefaultActionGroup defaultGroup = super.createToolbarActions();
        if (this.myDeletableFiles) {
            DeleteAction deleteAction = new DeleteAction(null, null, IconUtil.getRemoveIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.actionPerformed(e);
                    SelectFilesDialog.this.myFileList.refresh();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog$1", "actionPerformed"));
                }
            };
            EmptyAction.setupAction((AnAction)deleteAction, (String)"$Delete", (JComponent)((Object)this.getFileList()));
            defaultGroup.add((AnAction)deleteAction);
        }
        DefaultActionGroup defaultActionGroup = defaultGroup;
        if (defaultActionGroup == null) {
            SelectFilesDialog.$$$reportNull$$$0(11);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okActionName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelActionName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VirtualFileList
    extends ChangesTreeImpl.VirtualFiles {
        @Nullable
        private final DeleteProvider myDeleteProvider;

        public VirtualFileList(Project project, boolean selectableFiles, boolean deletableFiles, @NotNull List<? extends VirtualFile> files) {
            if (files == null) {
                VirtualFileList.$$$reportNull$$$0(0);
            }
            super(project, selectableFiles, true, files);
            this.myDeleteProvider = deletableFiles ? new VirtualFileDeleteProvider() : null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                VirtualFileList.$$$reportNull$$$0(1);
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && this.myDeleteProvider != null) {
                return this.myDeleteProvider;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return this.getSelectedChanges().toArray(VirtualFile.EMPTY_ARRAY);
            }
            return super.getData(dataId);
        }

        public void refresh() {
            this.setChangesToDisplay(ContainerUtil.filter(this.getChanges(), VirtualFile::isValid));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog$VirtualFileList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

