/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\u0016\u0010\u0015\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "inclusionHashingStrategy", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "", "(Lit/unimi/dsi/fastutil/Hash$Strategy;)V", "inclusion", "", "addInclusion", "", "items", "", "clearInclusion", "getInclusion", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "removeInclusion", "retainInclusion", "setInclusion", "intellij.platform.vcs.impl"})
public final class DefaultInclusionModel
extends BaseInclusionModel {
    private final Set<Object> inclusion;
    private final Hash.Strategy<Object> inclusionHashingStrategy;

    @NotNull
    public Set<Object> getInclusion() {
        Set<Object> set = Collections.unmodifiableSet(this.inclusionHashingStrategy == null ? (Set)new HashSet(this.inclusion) : (Set)new ObjectOpenCustomHashSet((Collection)this.inclusion, this.inclusionHashingStrategy));
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiable\u2026clusionHashingStrategy)))");
        return set;
    }

    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.inclusion.contains(item) ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
    }

    public boolean isInclusionEmpty() {
        return this.inclusion.isEmpty();
    }

    public void addInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.inclusion.addAll(items)) {
            this.fireInclusionChanged();
        }
    }

    public void removeInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (VcsUtil.removeAllFromSet(this.inclusion, items)) {
            this.fireInclusionChanged();
        }
    }

    public void setInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Set<Object> oldInclusion = this.getInclusion();
        this.inclusion.clear();
        this.inclusion.addAll(items);
        if (Intrinsics.areEqual(oldInclusion, this.inclusion) ^ true) {
            this.fireInclusionChanged();
        }
    }

    public void retainInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.inclusion.retainAll(items)) {
            this.fireInclusionChanged();
        }
    }

    public void clearInclusion() {
        Collection collection = this.inclusion;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.inclusion.clear();
            this.fireInclusionChanged();
        }
    }

    public DefaultInclusionModel(@Nullable Hash.Strategy<Object> inclusionHashingStrategy) {
        this.inclusionHashingStrategy = inclusionHashingStrategy;
        this.inclusion = this.inclusionHashingStrategy == null ? (Set)new HashSet() : (Set)new ObjectOpenCustomHashSet(this.inclusionHashingStrategy);
    }

    public /* synthetic */ DefaultInclusionModel(Hash.Strategy strategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            strategy = null;
        }
        this((Hash.Strategy<Object>)strategy);
    }

    public DefaultInclusionModel() {
        this(null, 1, null);
    }
}

