/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchStateProvider;
import com.intellij.vcs.branch.LinkedBranchData;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u00182\u0006\u0010(\u001a\u00020\u0002J\b\u0010)\u001a\u00020&H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\bH\u0003J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0016\u0010/\u001a\u00020+2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b00H\u0003J\u0018\u00101\u001a\u0004\u0018\u00010+2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b00H\u0003J\b\u00102\u001a\u00020&H\u0002R7\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017RC\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u000f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent;", "Lcom/intellij/ui/components/JBLabel;", "Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "<set-?>", "", "Lcom/intellij/vcs/branch/BranchData;", "branches", "getBranches", "()Ljava/util/Set;", "setBranches", "(Ljava/util/Set;)V", "branches$delegate", "Lkotlin/properties/ReadWriteProperty;", "changeEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Ljavax/swing/event/ChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isGroupedByRepository", "", "()Z", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/vcs/FilePath;", "pathsProvider", "getPathsProvider", "()Lkotlin/jvm/functions/Function0;", "setPathsProvider", "(Lkotlin/jvm/functions/Function0;)V", "pathsProvider$delegate", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addChangeListener", "", "block", "parent", "dispose", "getMultiTooltip", "", "branch", "getPreferredSize", "Ljava/awt/Dimension;", "getText", "", "getTooltip", "refresh", "Companion", "intellij.platform.vcs.impl"})
public final class CurrentBranchComponent
extends JBLabel
implements Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final EventDispatcher<ChangeListener> changeEventDispatcher;
    private final ReadWriteProperty branches$delegate;
    @NotNull
    private final ReadWriteProperty pathsProvider$delegate;
    private final ChangesTree tree;
    private static final JBColor BACKGROUND_BASE_COLOR;
    @JvmField
    @NotNull
    public static final JBColor TEXT_COLOR;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(CurrentBranchComponent.class, "branches", "getBranches()Ljava/util/Set;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(CurrentBranchComponent.class, "pathsProvider", "getPathsProvider()Lkotlin/jvm/functions/Function0;", 0))};
        Companion = new Companion(null);
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.RefLabel.backgroundBase", (Color)((Color)new JBColor(Color.BLACK, Color.WHITE)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"VersionContr\u2026olor.BLACK, Color.WHITE))");
        BACKGROUND_BASE_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"VersionControl.RefLabel.foreground", (Color)((Color)new JBColor(new Color(0x7A7A7A), new Color(0x909090))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(\"VersionContr\u2026a7a7a), Color(0x909090)))");
        TEXT_COLOR = jBColor2;
    }

    private final Set<BranchData> getBranches() {
        return (Set)this.branches$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setBranches(Set<? extends BranchData> set) {
        this.branches$delegate.setValue((Object)this, $$delegatedProperties[0], set);
    }

    private final boolean isGroupedByRepository() {
        ChangesGroupingSupport changesGroupingSupport = this.tree.getGroupingSupport();
        Intrinsics.checkNotNullExpressionValue((Object)changesGroupingSupport, (String)"tree.groupingSupport");
        ChangesGroupingSupport groupingSupport = changesGroupingSupport;
        return groupingSupport.isAvailable("repository") && groupingSupport.get("repository");
    }

    @NotNull
    public final Project getProject() {
        Project project = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tree.project");
        return project;
    }

    @NotNull
    public final Function0<Iterable<FilePath>> getPathsProvider() {
        return (Function0)this.pathsProvider$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setPathsProvider(@NotNull Function0<? extends Iterable<? extends FilePath>> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.pathsProvider$delegate.setValue((Object)this, $$delegatedProperties[1], function0);
    }

    public final void addChangeListener(@NotNull Function0<Unit> block, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.changeEventDispatcher.addListener((EventListener)new ChangeListener(block){
            final /* synthetic */ Function0 $block;

            public final void stateChanged(ChangeEvent it) {
                this.$block.invoke();
            }
            {
                this.$block = function0;
            }
        }, parent);
    }

    @Nullable
    public Dimension getPreferredSize() {
        return this.isVisible() ? super.getPreferredSize() : (Dimension)JBUI.emptySize();
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final void refresh() {
        Set set;
        boolean needShowBranch = !this.isGroupedByRepository();
        CurrentBranchComponent currentBranchComponent = this;
        if (needShowBranch) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = (Iterable)this.getPathsProvider().invoke();
            CurrentBranchComponent currentBranchComponent2 = currentBranchComponent;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BranchData branchData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                FilePath it = (FilePath)element$iv$iv;
                boolean bl2 = false;
                if (Companion.getCurrentBranch(this.getProject(), it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                BranchData it$iv$iv = branchData;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            currentBranchComponent = currentBranchComponent2;
            set = CollectionsKt.toSet((Iterable)list);
        } else {
            set = SetsKt.emptySet();
        }
        currentBranchComponent.setBranches(set);
    }

    @Nls
    private final String getText(Collection<? extends BranchData> branches) {
        String string;
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String key$iv = it.getBranchName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        switch (distinct.size()) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = Companion.getPresentableText((BranchData)CollectionsKt.first((List)distinct));
                break;
            }
            default: {
                string = Companion.getPresentableText((BranchData)CollectionsKt.first((List)distinct)) + ",...";
            }
        }
        return string;
    }

    @Nls
    private final String getTooltip(Collection<? extends BranchData> branches) {
        String string;
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String string2 = it.getBranchName();
            BranchData branchData = it;
            if (!(branchData instanceof LinkedBranchData)) {
                branchData = null;
            }
            LinkedBranchData linkedBranchData = (LinkedBranchData)branchData;
            Pair key$iv = TuplesKt.to((Object)string2, (Object)(linkedBranchData != null ? linkedBranchData.getLinkedBranchName() : null));
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        switch (distinct.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = Companion.getSingleTooltip((BranchData)CollectionsKt.first((List)distinct));
                break;
            }
            default: {
                string = CollectionsKt.joinToString$default((Iterable)branches, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<BranchData, CharSequence>(this){
                    final /* synthetic */ CurrentBranchComponent this$0;

                    @NotNull
                    public final CharSequence invoke(@NotNull BranchData it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CurrentBranchComponent.access$getMultiTooltip(this.this$0, it);
                    }
                    {
                        this.this$0 = currentBranchComponent;
                        super(1);
                    }
                }), (int)30, null);
            }
        }
        return string;
    }

    @Nls
    private final String getMultiTooltip(BranchData branch) {
        String string;
        block4: {
            block2: {
                block3: {
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    string = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (string == null) break block3;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    string = ' ' + UIUtil.rightArrow() + ' ' + it;
                    if (string != null) break block4;
                }
                String string3 = VcsBundle.message((String)"changes.no.tracking.branch.suffix", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VcsBundle.message(\"chang\u2026.tracking.branch.suffix\")");
                break block4;
            }
            string = "";
        }
        String linkedBranchPart = string;
        return "<tr><td>" + branch.getPresentableRootName() + ":</td><td>" + Companion.getPresentableText(branch) + linkedBranchPart + "</td></tr>";
    }

    public CurrentBranchComponent(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.tree = tree;
        EventDispatcher eventDispatcher = EventDispatcher.create(ChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(ChangeListener::class.java)");
        this.changeEventDispatcher = eventDispatcher;
        Delegates delegates = Delegates.INSTANCE;
        boolean bl = false;
        Object initialValue$iv = SetsKt.emptySet();
        boolean $i$f$observable = false;
        this.branches$delegate = (ReadWriteProperty)new ObservableProperty<Set<? extends BranchData>>(initialValue$iv, initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ CurrentBranchComponent this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = currentBranchComponent;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Set set = (Set)newValue;
                Set set2 = (Set)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldValue2, (Object)newValue2)) {
                    this.this$0.setText(CurrentBranchComponent.access$getText(this.this$0, (Collection)newValue2));
                    this.this$0.setToolTipText(CurrentBranchComponent.access$getTooltip(this.this$0, (Collection)newValue2));
                    Collection collection = (Collection)newValue2;
                    boolean bl2 = false;
                    this.this$0.setVisible(!collection.isEmpty());
                    ((ChangeListener)CurrentBranchComponent.access$getChangeEventDispatcher$p(this.this$0).getMulticaster()).stateChanged(new ChangeEvent((Object)((Object)this.this$0)));
                }
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = pathsProvider.2.INSTANCE;
        $i$f$observable = false;
        this.pathsProvider$delegate = (ReadWriteProperty)new ObservableProperty<Function0<? extends Iterable<? extends FilePath>>>(initialValue$iv, initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ CurrentBranchComponent this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = currentBranchComponent;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Function0 function0 = (Function0)newValue;
                Function0 function02 = (Function0)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                CurrentBranchComponent.access$refresh(this.this$0);
            }
        };
        this.setVisible(false);
        this.setIcon(AllIcons.Vcs.Branch);
        this.setForeground((Color)TEXT_COLOR);
        final PropertyChangeListener treeChangeListener2 = new PropertyChangeListener(this){
            final /* synthetic */ CurrentBranchComponent this$0;

            public final void propertyChange(PropertyChangeEvent e) {
                PropertyChangeEvent propertyChangeEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)propertyChangeEvent, (String)"e");
                if (Intrinsics.areEqual((Object)propertyChangeEvent.getPropertyName(), (Object)"model")) {
                    CurrentBranchComponent.access$refresh(this.this$0);
                }
            }
            {
                this.this$0 = currentBranchComponent;
            }
        };
        this.tree.addPropertyChangeListener(treeChangeListener2);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                tree.removePropertyChangeListener(treeChangeListener2);
            }
        });
    }

    public static final /* synthetic */ String access$getMultiTooltip(CurrentBranchComponent $this, BranchData branch) {
        return $this.getMultiTooltip(branch);
    }

    public static final /* synthetic */ String access$getText(CurrentBranchComponent $this, Collection branches) {
        return $this.getText(branches);
    }

    public static final /* synthetic */ String access$getTooltip(CurrentBranchComponent $this, Collection branches) {
        return $this.getTooltip(branches);
    }

    public static final /* synthetic */ EventDispatcher access$getChangeEventDispatcher$p(CurrentBranchComponent $this) {
        return $this.changeEventDispatcher;
    }

    public static final /* synthetic */ void access$refresh(CurrentBranchComponent $this) {
        $this.refresh();
    }

    @JvmStatic
    @NotNull
    public static final Color getBranchPresentationBackground(@NotNull Color background) {
        return Companion.getBranchPresentationBackground(background);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\t2\u0006\u0010\r\u001a\u00020\fH\u0007J\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u00102\u0006\u0010\u001b\u001a\u00020\u000fH\u0007J<\u0010\u001c\u001a.\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0015\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0 \u00a2\u0006\u0002\b\t0\u001d\u00a2\u0006\u0002\b\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0007J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent$Companion;", "", "()V", "BACKGROUND_BALANCE", "", "getBACKGROUND_BALANCE", "()D", "BACKGROUND_BASE_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "TEXT_COLOR", "getBranchPresentationBackground", "Ljava/awt/Color;", "background", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPresentableText", "", "branch", "getProviders", "", "Lcom/intellij/vcs/branch/BranchStateProvider;", "kotlin.jvm.PlatformType", "", "getSingleTooltip", "namedDouble", "name", "default", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private final double getBACKGROUND_BALANCE() {
            return Companion.namedDouble("VersionControl.RefLabel.backgroundBrightness", 0.08);
        }

        private final double namedDouble(String name, double d) {
            double d2;
            Object value = UIManager.get(name);
            Object object = value;
            if (object instanceof Double) {
                d2 = ((Number)value).doubleValue();
            } else if (object instanceof Integer) {
                d2 = ((Number)value).intValue();
            } else if (object instanceof String) {
                Double d3 = StringsKt.toDoubleOrNull((String)((String)value));
                d2 = d3 != null ? d3 : d;
            } else {
                d2 = d;
            }
            return d2;
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project, @NotNull Change change) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(change)");
            return this.getCurrentBranch(project, filePath);
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(file)");
            return this.getCurrentBranch(project, filePath);
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project, @NotNull FilePath path2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return (BranchData)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getProviders(project)), (Function1)((Function1)new Function1<BranchStateProvider, BranchData>(path2){
                final /* synthetic */ FilePath $path;

                @Nullable
                public final BranchData invoke(BranchStateProvider it) {
                    return it.getCurrentBranch(this.$path);
                }
                {
                    this.$path = filePath;
                    super(1);
                }
            })));
        }

        @Nls
        @NotNull
        public final String getPresentableText(@NotNull BranchData branch) {
            String string;
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            if (branch instanceof LinkedBranchData) {
                string = ((LinkedBranchData)branch).getBranchName();
                if (string == null) {
                    string = "!";
                }
            } else {
                String string2 = branch.getBranchName();
                boolean bl = false;
                string = string2;
                if (string == null) {
                    string = "";
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (branch is LinkedBran\u2026anch.branchName.orEmpty()");
            return string;
        }

        @Nls
        @Nullable
        public final String getSingleTooltip(@NotNull BranchData branch) {
            String string;
            block4: {
                block2: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                        if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                        string = ((LinkedBranchData)branch).getLinkedBranchName();
                        if (string == null) break block3;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        string = ((LinkedBranchData)branch).getBranchName() + ' ' + UIUtil.rightArrow() + ' ' + it;
                        if (string != null) break block4;
                    }
                    String string3 = VcsBundle.message((String)"changes.no.tracking.branch", (Object[])new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VcsBundle.message(\"changes.no.tracking.branch\")");
                    break block4;
                }
                string = null;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final Color getBranchPresentationBackground(@NotNull Color background) {
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Color color = ColorUtil.mix((Color)background, (Color)((Color)BACKGROUND_BASE_COLOR), (double)this.getBACKGROUND_BALANCE());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ColorUtil.mix(background\u2026OLOR, BACKGROUND_BALANCE)");
            return color;
        }

        private final List<BranchStateProvider> getProviders(Project project) {
            List list = BranchStateProvider.EP_NAME.getExtensionList((AreaInstance)project);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"BranchStateProvider.EP_N\u2026getExtensionList(project)");
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

