/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DefaultChangeListOwner;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangesViewDnDSupport
extends ChangesTreeDnDSupport {
    @NotNull
    private final Project myProject;

    public static void install(@NotNull Project project, @NotNull ChangesTree tree, @NotNull Disposable disposable) {
        if (project == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(2);
        }
        new ChangesViewDnDSupport(project, tree).install(disposable);
    }

    private ChangesViewDnDSupport(@NotNull Project project, @NotNull ChangesTree tree) {
        if (project == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(3);
        }
        if (tree == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(4);
        }
        super(tree);
        this.myProject = project;
    }

    @Override
    @Nullable
    protected DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(5);
        }
        if (info.isMove()) {
            Change[] changes = (Change[])ChangesListView.getChanges(this.myProject, this.myTree.getSelectionPaths()).toList().toArray(Change[]::new);
            List unversionedFiles = ChangesListView.getFilePaths(this.myTree.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG).toList();
            List ignoredFiles = ChangesListView.getFilePaths(this.myTree.getSelectionPaths(), ChangesBrowserNode.IGNORED_FILES_TAG).toList();
            if (changes.length > 0 || !unversionedFiles.isEmpty() || !ignoredFiles.isEmpty()) {
                return new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)((Object)this.myTree), changes, unversionedFiles, ignoredFiles));
            }
        }
        return null;
    }

    @Override
    protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @NotNull ChangesBrowserNode<?> dropNode) {
        Object attached;
        if (aEvent == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(6);
        }
        if (dropNode == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(7);
        }
        if ((attached = aEvent.getAttachedObject()) instanceof ChangeListDragBean) {
            ChangeListDragBean dragBean = (ChangeListDragBean)attached;
            dragBean.setTargetNode(dropNode);
            return dragBean.getSourceComponent() == this.myTree && dropNode.canAcceptDrop(dragBean);
        }
        if (attached instanceof ShelvedChangeListDragBean) {
            return dropNode instanceof ChangesBrowserChangeListNode;
        }
        return false;
    }

    public void drop(DnDEvent aEvent) {
        ChangeListDragBean dragBean;
        ChangesBrowserNode changesBrowserNode;
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ShelvedChangeListDragBean) {
            ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attached, ChangesViewDnDSupport.getDropRootNode(this.myTree, aEvent), !ChangesViewDnDSupport.isCopyAction(aEvent));
        } else if (attached instanceof ChangeListDragBean && (changesBrowserNode = (dragBean = (ChangeListDragBean)attached).getTargetNode()) != null) {
            changesBrowserNode.acceptDrop(new DefaultChangeListOwner(this.myProject), dragBean);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesViewDnDSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDragStartBean";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandleDropEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

