/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ChangesBrowserSpecificFilePathsNode<T>
extends ChangesBrowserNode<T> {
    protected final boolean myIsMany;
    @NotNull
    protected final Runnable myDialogShower;
    private final int myManyFileCount;
    private final int myManyDirectoryCount;

    protected ChangesBrowserSpecificFilePathsNode(T userObject, @NotNull Collection<FilePath> files, @NotNull Runnable shower) {
        if (files == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(0);
        }
        if (shower == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(1);
        }
        super(userObject);
        this.myManyDirectoryCount = ContainerUtil.count(files, it -> it.isDirectory());
        this.myManyFileCount = files.size() - this.myManyDirectoryCount;
        this.myIsMany = ChangesBrowserSpecificFilePathsNode.isManyFiles(files);
        this.myDialogShower = shower;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(2);
        }
        super.render(renderer, selected, expanded, hasFocus);
        if (this.isManyFiles()) {
            renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append(VcsBundle.message((String)"changes.browse", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getFileCount() {
        return this.myIsMany ? this.myManyFileCount : super.getFileCount();
    }

    @Override
    public int getDirectoryCount() {
        return this.myIsMany ? this.myManyDirectoryCount : super.getDirectoryCount();
    }

    public boolean isManyFiles() {
        return this.myIsMany;
    }

    public static boolean isManyFiles(@NotNull Collection<?> files) {
        if (files == null) {
            ChangesBrowserSpecificFilePathsNode.$$$reportNull$$$0(3);
        }
        return files.size() > Registry.intValue((String)"vcs.unversioned.files.max.intree", (int)1000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shower";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isManyFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

