/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserRootNode;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class ChangesBrowserNode<T>
extends DefaultMutableTreeNode
implements UserDataHolderEx {
    public static final Tag IGNORED_FILES_TAG = new VcsBundleTag("changes.nodetitle.ignored.files");
    public static final Tag LOCKED_FOLDERS_TAG = new VcsBundleTag("changes.nodetitle.locked.folders");
    public static final Tag LOGICALLY_LOCKED_TAG = new VcsBundleTag("changes.nodetitle.logicallt.locked.folders");
    public static final Tag UNVERSIONED_FILES_TAG = new VcsBundleTag("changes.nodetitle.unversioned.files");
    public static final Tag MODIFIED_WITHOUT_EDITING_TAG = new VcsBundleTag("changes.nodetitle.modified.without.editing");
    public static final Tag SWITCHED_FILES_TAG = new VcsBundleTag("changes.nodetitle.switched.files");
    public static final Tag SWITCHED_ROOTS_TAG = new VcsBundleTag("changes.nodetitle.switched.roots");
    public static final Tag LOCALLY_DELETED_NODE_TAG = new VcsBundleTag("changes.nodetitle.locally.deleted.files");
    protected static final int CONFLICTS_SORT_WEIGHT = 0;
    protected static final int DEFAULT_CHANGE_LIST_SORT_WEIGHT = 1;
    protected static final int CHANGE_LIST_SORT_WEIGHT = 2;
    protected static final int REPOSITORY_SORT_WEIGHT = 3;
    protected static final int MODULE_SORT_WEIGHT = 4;
    protected static final int DIRECTORY_PATH_SORT_WEIGHT = 5;
    protected static final int FILE_PATH_SORT_WEIGHT = 6;
    protected static final int CHANGE_SORT_WEIGHT = 7;
    protected static final int VIRTUAL_FILE_SORT_WEIGHT = 8;
    protected static final int UNVERSIONED_SORT_WEIGHT = 9;
    protected static final int DEFAULT_SORT_WEIGHT = 10;
    protected static final int IGNORED_SORT_WEIGHT = 11;
    public static final Convertor<TreePath, String> TO_TEXT_CONVERTER = path2 -> ((ChangesBrowserNode)path2.getLastPathComponent()).getTextPresentation();
    private SimpleTextAttributes myAttributes;
    private int myFileCount = -1;
    private int myDirectoryCount = -1;
    private boolean myHelper;
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();

    protected ChangesBrowserNode(T userObject) {
        super(userObject);
        this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    @NotNull
    public static ChangesBrowserNode createRoot() {
        ChangesBrowserRootNode root = new ChangesBrowserRootNode();
        root.markAsHelperNode();
        ChangesBrowserRootNode changesBrowserRootNode = root;
        if (changesBrowserRootNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(0);
        }
        return changesBrowserRootNode;
    }

    @NotNull
    public static ChangesBrowserNode createChange(@Nullable Project project, @NotNull Change userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(1);
        }
        return new ChangesBrowserChangeNode(project, userObject, null);
    }

    @NotNull
    public static ChangesBrowserNode createFile(@Nullable Project project, @NotNull VirtualFile userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(2);
        }
        return new ChangesBrowserFileNode(project, userObject);
    }

    @NotNull
    public static ChangesBrowserNode createFilePath(@NotNull FilePath userObject, @Nullable FileStatus status) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(3);
        }
        return new ChangesBrowserFilePathNode(userObject, status);
    }

    @NotNull
    public static ChangesBrowserNode createFilePath(@NotNull FilePath userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(4);
        }
        return ChangesBrowserNode.createFilePath(userObject, null);
    }

    @NotNull
    public static ChangesBrowserNode createLogicallyLocked(@Nullable Project project, @NotNull VirtualFile file, @NotNull LogicalLock lock) {
        if (file == null) {
            ChangesBrowserNode.$$$reportNull$$$0(5);
        }
        if (lock == null) {
            ChangesBrowserNode.$$$reportNull$$$0(6);
        }
        return new ChangesBrowserLogicallyLockedFile(project, file, lock);
    }

    @NotNull
    public static ChangesBrowserNode createLockedFolders(@NotNull Project project) {
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(7);
        }
        return new ChangesBrowserLockedFoldersNode(project);
    }

    @NotNull
    public static ChangesBrowserNode createLocallyDeleted(@NotNull LocallyDeletedChange change) {
        if (change == null) {
            ChangesBrowserNode.$$$reportNull$$$0(8);
        }
        return new ChangesBrowserLocallyDeletedNode(change);
    }

    @Override
    public ChangesBrowserNode<?> getParent() {
        return (ChangesBrowserNode)super.getParent();
    }

    @Nullable
    public <V> V getUserData(@NotNull Key<V> key) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(9);
        }
        return (V)this.myUserDataHolder.getUserData(key);
    }

    public <V> void putUserData(@NotNull Key<V> key, @Nullable V value) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(10);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <V> V putUserDataIfAbsent(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(11);
        }
        if (value == null) {
            ChangesBrowserNode.$$$reportNull$$$0(12);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            ChangesBrowserNode.$$$reportNull$$$0(13);
        }
        return (V)object;
    }

    public <V> boolean replace(@NotNull Key<V> key, @Nullable V oldValue, @Nullable V newValue) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(14);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.resetFileCounters();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.resetFileCounters();
    }

    protected boolean isFile() {
        return false;
    }

    protected boolean isDirectory() {
        return false;
    }

    public void markAsHelperNode() {
        this.myHelper = true;
    }

    public boolean isMeaningfulNode() {
        return !this.myHelper;
    }

    public int getFileCount() {
        if (this.myFileCount == -1) {
            this.myFileCount = (this.isFile() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getFileCount).sum();
        }
        return this.myFileCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getDirectoryCount).sum();
        }
        return this.myDirectoryCount;
    }

    private void resetFileCounters() {
        this.myFileCount = -1;
        this.myDirectoryCount = -1;
    }

    @NotNull
    public Stream<ChangesBrowserNode<?>> getNodesUnderStream() {
        return ChangesBrowserNode.toStream(this.preorderEnumeration());
    }

    @NotNull
    public List<Change> getAllChangesUnder() {
        List<Change> list = this.getAllObjectsUnder(Change.class);
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public <U> List<U> getAllObjectsUnder(@NotNull Class<U> clazz) {
        if (clazz == null) {
            ChangesBrowserNode.$$$reportNull$$$0(16);
        }
        List list = this.traverseObjectsUnder().filter(clazz).toList();
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public JBIterable<?> traverseObjectsUnder() {
        JBIterable jBIterable = TreeUtil.treeNodeTraverser((TreeNode)this).traverse().map(TreeUtil::getUserObject);
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @NotNull
    public List<VirtualFile> getAllFilesUnder() {
        List<VirtualFile> list = this.getFilesUnderStream().collect(Collectors.toList());
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public Stream<VirtualFile> getFilesUnderStream() {
        StreamEx streamEx = StreamEx.of((Iterator)this.traverseObjectsUnder().filter(VirtualFile.class).filter(VirtualFile::isValid).iterator());
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(20);
        }
        return streamEx;
    }

    @NotNull
    public List<FilePath> getAllFilePathsUnder() {
        List<FilePath> list = this.getFilePathsUnderStream().collect(Collectors.toList());
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public Stream<FilePath> getFilePathsUnderStream() {
        StreamEx streamEx = ((StreamEx)ChangesBrowserNode.toStream(this.preorderEnumeration()).filter(DefaultMutableTreeNode::isLeaf)).map(ChangesBrowserNode::getUserObject).select(FilePath.class);
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(22);
        }
        return streamEx;
    }

    @NotNull
    private static StreamEx<ChangesBrowserNode<?>> toStream(@NotNull Enumeration enumeration) {
        if (enumeration == null) {
            ChangesBrowserNode.$$$reportNull$$$0(23);
        }
        StreamEx streamEx = StreamEx.of((Enumeration)enumeration);
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(24);
        }
        return streamEx;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(25);
        }
        renderer.append(this.getTextPresentation(), this.myAttributes);
        this.appendCount(renderer);
    }

    @Nls
    @NotNull
    protected String getCountText() {
        int count = this.getFileCount();
        int dirCount = this.getDirectoryCount();
        Object result2 = "";
        if (dirCount != 0 || count != 0) {
            result2 = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count}) : (count == 0 ? VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount}) : VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count})));
        }
        String string = result2;
        if (string == null) {
            ChangesBrowserNode.$$$reportNull$$$0(26);
        }
        return string;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(27);
        }
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    @Nls
    public String getTextPresentation() {
        DeprecatedMethodException.report((String)("Please implement `ChangesBrowserNode#getTextPresentation()` explicitly. " + this.getClass()));
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 10;
    }

    public int compareUserObjects(T o2) {
        return 0;
    }

    protected static int compareFileNames(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(28);
        }
        if (name2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(29);
        }
        return FileNameComparator.INSTANCE.compare(name1, name2);
    }

    public static int compareFilePaths(@NotNull FilePath path1, @NotNull FilePath path2) {
        if (path1 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(30);
        }
        if (path2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(31);
        }
        return ChangesComparator.getFilePathComparator(true).compare(path1, path2);
    }

    public void setAttributes(@NotNull SimpleTextAttributes attributes2) {
        if (attributes2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(32);
        }
        this.myAttributes = attributes2;
    }

    @NotNull
    protected SimpleTextAttributes getAttributes() {
        SimpleTextAttributes simpleTextAttributes = this.myAttributes;
        if (simpleTextAttributes == null) {
            ChangesBrowserNode.$$$reportNull$$$0(33);
        }
        return simpleTextAttributes;
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable FilePath parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(34);
        }
        if (parentPath != null) {
            ChangesBrowserNode.appendParentPath(renderer, parentPath.getPresentableUrl());
        }
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable VirtualFile parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(35);
        }
        if (parentPath != null) {
            ChangesBrowserNode.appendParentPath(renderer, parentPath.getPresentableUrl());
        }
    }

    private static void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @NotNull String parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(36);
        }
        if (parentPath == null) {
            ChangesBrowserNode.$$$reportNull$$$0(37);
        }
        renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.getLocationRelativeToUserHome((String)parentPath), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    protected void appendUpdatingState(@NotNull ChangesBrowserNodeRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(38);
        }
        renderer.append((this.getCountText().isEmpty() ? FontUtil.spaceAndThinSpace() : ", ") + VcsBundle.message((String)"changes.nodetitle.updating", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Nullable
    public Color getBackgroundColor(@NotNull Project project) {
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(39);
        }
        return ChangesBrowserNode.getBackgroundColorFor(project, this.getUserObject());
    }

    @Nullable
    protected static Color getBackgroundColorFor(@NotNull Project project, @Nullable Object object) {
        VirtualFile file;
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(40);
        }
        if ((file = object instanceof FilePath ? ChangesBrowserNode.getScopeVirtualFileFor((FilePath)object) : (object instanceof Change ? ChangesBrowserNode.getScopeVirtualFileFor(ChangesUtil.getFilePath((Change)((Change)object))) : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class))) != null) {
            return VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)file);
        }
        return null;
    }

    @Nullable
    private static VirtualFile getScopeVirtualFileFor(@NotNull FilePath filePath) {
        if (filePath == null) {
            ChangesBrowserNode.$$$reportNull$$$0(41);
        }
        if (filePath.isNonLocal()) {
            return null;
        }
        return ChangesUtil.findValidParentAccurately((FilePath)filePath);
    }

    public boolean shouldExpandByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 7: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 25: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChangesUnder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllObjectsUnder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseObjectsUnder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesUnder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesUnderStream";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilePathsUnder";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathsUnderStream";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toStream";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLogicallyLocked";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLockedFolders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLocallyDeleted";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllObjectsUnder";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toStream";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendCount";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "compareFileNames";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareFilePaths";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendParentPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "appendUpdatingState";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColorFor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getScopeVirtualFileFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VcsBundleTag
    implements Tag {
        @PropertyKey(resourceBundle="messages.VcsBundle")
        @NotNull
        private final @PropertyKey(resourceBundle="messages.VcsBundle") @NotNull String myKey;

        public VcsBundleTag(@PropertyKey(resourceBundle="messages.VcsBundle") @NotNull @PropertyKey(resourceBundle="messages.VcsBundle") @NotNull String key) {
            if (key == null) {
                VcsBundleTag.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        @Nls
        public String toString() {
            return VcsBundle.message((String)this.myKey, (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$VcsBundleTag", "<init>"));
        }
    }

    public static class WrapperTag
    implements Tag {
        @NotNull
        private final Object myValue;

        public static Tag wrap(@Nullable Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Tag) {
                return (Tag)object;
            }
            return new WrapperTag(object);
        }

        public WrapperTag(@NotNull Object value) {
            if (value == null) {
                WrapperTag.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @Nls
        public String toString() {
            return this.myValue.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$WrapperTag", "<init>"));
        }
    }

    public static class TagImpl
    implements Tag {
        @NotNull
        @Nls
        private final String myValue;

        public TagImpl(@NotNull @Nls String value) {
            if (value == null) {
                TagImpl.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @Nls
        public String toString() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$TagImpl", "<init>"));
        }
    }

    public static interface Tag {
        @Nls
        public String toString();
    }
}

