/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooser
extends DialogWrapper {
    private final Project myProject;
    private LocalChangeList mySelectedList;
    private final ChangeListChooserPanel myPanel;

    public ChangeListChooser(@NotNull Project project, @Nullable Collection<? extends ChangeList> changelists, @Nullable ChangeList defaultSelection, @NlsContexts.DialogTitle String title2, @Nullable @Nls String suggestedName) {
        if (project == null) {
            ChangeListChooser.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myProject = project;
        this.myPanel = new ChangeListChooserPanel(this.myProject, (Consumer<? super String>)new Consumer<String>(){

            @Override
            public void accept(@Nullable @NlsContexts.DialogMessage String errorMessage) {
                ChangeListChooser.this.setOKActionEnabled(errorMessage == null);
                ChangeListChooser.this.setErrorText(errorMessage, ChangeListChooser.this.myPanel);
            }
        });
        this.myPanel.init();
        this.myPanel.setChangeLists(changelists);
        this.myPanel.setDefaultSelection(defaultSelection);
        this.setTitle(title2);
        if (suggestedName != null) {
            this.myPanel.setSuggestedName(suggestedName);
        }
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.vcs.changelist.chooser";
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangelistChooser";
    }

    protected void doOKAction() {
        this.mySelectedList = this.myPanel.getSelectedList(this.myProject);
        if (this.mySelectedList != null) {
            super.doOKAction();
        }
    }

    @Nullable
    public LocalChangeList getSelectedList() {
        return this.mySelectedList;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangeListChooser", "<init>"));
    }
}

