/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ignore.actions.CreateNewIgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileAction;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroupKt;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionKt;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0014J \u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010!\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#*\u00020$H\u0082\u0002J\u0012\u0010%\u001a\u00070\u0016\u00a2\u0006\u0002\b&*\u00020$H\u0082\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J+\u0010*\u001a\u00070+\u00a2\u0006\u0002\b,*\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010\u00162\u0006\u0010.\u001a\u00020)H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "ignoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "(Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;)V", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createAdditionalActions", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "unversionedFiles", "createNewIgnoreFileAction", "filterSelectedFiles", "files", "findSuitableIgnoreFiles", "file", "getChildren", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "component1", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/vcs/VcsRoot;", "component2", "Lorg/jetbrains/annotations/NotNull;", "toActions", "additionalActionsSize", "", "toTextRepresentation", "", "Lorg/jetbrains/annotations/Nls;", "projectDir", "size", "intellij.platform.vcs.impl"})
public class IgnoreFileActionGroup
extends ActionGroup
implements DumbAware {
    private Collection<? extends AnAction> actions;
    private final IgnoreFileType ignoreFileType;

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<VirtualFile> selectedFiles = IgnoreFileActionKt.getSelectedFiles(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation2.setVisible(false);
            return;
        }
        Stream<VirtualFile> stream = ScheduleForAdditionAction.getUnversionedFiles(e, project);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"ScheduleForAdditionActio\u2026ersionedFiles(e, project)");
        List unversionedFiles = StreamsKt.toList(stream);
        if (unversionedFiles.isEmpty()) {
            presentation2.setVisible(false);
            return;
        }
        Iterable $this$map$iv = this.filterSelectedFiles(project, selectedFiles);
        boolean $i$f$map = false;
        Collection<? extends AnAction> collection = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Collection<VirtualFile> collection3 = this.findSuitableIgnoreFiles(project, (VirtualFile)it);
            collection2.add(collection3);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Collection p1 = (Collection)element$iv$iv;
            boolean bl = false;
            if (p1.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ignoreFiles = (List)destination$iv$iv;
        HashSet resultedIgnoreFiles = CollectionsKt.toHashSet((Iterable)CollectionsKt.flatten((Iterable)ignoreFiles));
        for (Collection files : ignoreFiles) {
            resultedIgnoreFiles.retainAll(files);
        }
        List<AnAction> additionalActions = this.createAdditionalActions(project, selectedFiles, unversionedFiles);
        collection = resultedIgnoreFiles;
        boolean bl = false;
        this.actions = !collection.isEmpty() ? this.toActions(resultedIgnoreFiles, project, additionalActions.size()) : (Collection)CollectionsKt.listOfNotNull((Object)this.createNewIgnoreFileAction(project, selectedFiles));
        collection = additionalActions;
        bl = false;
        if (!collection.isEmpty()) {
            this.actions = CollectionsKt.plus(this.actions, (Iterable)additionalActions);
        }
        this.setPopup(this.actions.size() > 1);
        collection = this.actions;
        bl = false;
        presentation2.setVisible(!collection.isEmpty());
    }

    @NotNull
    protected List<AnAction> createAdditionalActions(@NotNull Project project, @NotNull List<? extends VirtualFile> selectedFiles, @NotNull List<? extends VirtualFile> unversionedFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
        Intrinsics.checkNotNullParameter(unversionedFiles, (String)"unversionedFiles");
        return CollectionsKt.emptyList();
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.actions.size() == 1;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AnAction anAction = (AnAction)CollectionsKt.firstOrNull((Iterable)this.actions);
            if (anAction == null) break block0;
            anAction.actionPerformed(e);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Collection<? extends AnAction> $this$toTypedArray$iv = this.actions;
        boolean $i$f$toTypedArray = false;
        Collection<? extends AnAction> thisCollection$iv = $this$toTypedArray$iv;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        if (anActionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return anActionArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> filterSelectedFiles(Project project, List<? extends VirtualFile> files) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file)) && !ChangeListManager.getInstance((Project)project).isIgnoredFile(file))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> findSuitableIgnoreFiles(Project project, VirtualFile file) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        VirtualFile fileParent = file.getParent();
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)this.ignoreFileType), (GlobalSearchScope)ProjectScope.getProjectScope((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"FileTypeIndex.getFiles(i\u2026getProjectScope(project))");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
            if (!(Intrinsics.areEqual((Object)fileParent, (Object)virtualFile.getParent()) || fileParent != null && it.getParent() != null && VfsUtil.isAncestor((VirtualFile)it.getParent(), (VirtualFile)fileParent, (boolean)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<AnAction> toActions(Collection<? extends VirtualFile> $this$toActions, Project project, int additionalActionsSize) {
        void $this$mapTo$iv$iv;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        Iterable $this$map$iv = $this$toActions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IgnoreFileAction ignoreFileAction = new IgnoreFileAction((VirtualFile)file);
            boolean bl2 = false;
            boolean bl3 = false;
            IgnoreFileAction $this$apply = ignoreFileAction;
            boolean bl4 = false;
            Presentation presentation = $this$apply.getTemplatePresentation();
            boolean bl5 = false;
            boolean bl6 = false;
            Presentation $this$apply2 = presentation;
            boolean bl7 = false;
            $this$apply2.setIcon(this.ignoreFileType.getIcon());
            $this$apply2.setText(this.toTextRepresentation((VirtualFile)file, project, projectDir, $this$toActions.size() + additionalActionsSize));
            IgnoreFileAction ignoreFileAction2 = ignoreFileAction;
            collection.add(ignoreFileAction2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final AnAction createNewIgnoreFileAction(Project project, List<? extends VirtualFile> selectedFiles) {
        void rootVcs;
        IgnoreLanguage ignoreLanguage = this.ignoreFileType.getIgnoreLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ignoreLanguage), (String)"ignoreFileType.ignoreLanguage");
        String string = ignoreLanguage.getFilename();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ignoreFileType.ignoreLanguage.filename");
        String filename = string;
        VcsRoot vcsRoot = IgnoreFileActionGroupKt.access$getCommonIgnoreFileRoot(selectedFiles, project);
        if (vcsRoot == null) {
            return null;
        }
        VcsRoot vcsRoot2 = vcsRoot;
        AbstractVcs abstractVcs = this.component1(vcsRoot2);
        VirtualFile commonIgnoreFileRoot = this.component2(vcsRoot2);
        if (rootVcs == null) {
            return null;
        }
        if (commonIgnoreFileRoot.findChild(filename) != null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider((AbstractVcs)rootVcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ignoredFileContentProvider, (String)"VcsImplUtil.findIgnoredF\u2026r(rootVcs) ?: return null");
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        if (Intrinsics.areEqual((Object)ignoredFileContentProvider2.getFileName(), (Object)filename) ^ true) {
            return null;
        }
        CreateNewIgnoreFileAction createNewIgnoreFileAction = new CreateNewIgnoreFileAction(filename, commonIgnoreFileRoot);
        boolean bl = false;
        boolean bl2 = false;
        CreateNewIgnoreFileAction $this$apply = createNewIgnoreFileAction;
        boolean bl3 = false;
        Presentation presentation = $this$apply.getTemplatePresentation();
        boolean bl4 = false;
        boolean bl5 = false;
        Presentation $this$apply2 = presentation;
        boolean bl6 = false;
        $this$apply2.setIcon(this.ignoreFileType.getIcon());
        $this$apply2.setText(VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])new Object[]{filename}));
        return (AnAction)createNewIgnoreFileAction;
    }

    private final String toTextRepresentation(VirtualFile $this$toTextRepresentation, Project project, VirtualFile projectDir, int size) {
        if (size == 1) {
            Object[] objectArray = new Object[1];
            IgnoreLanguage ignoreLanguage = this.ignoreFileType.getIgnoreLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)ignoreLanguage), (String)"ignoreFileType.ignoreLanguage");
            objectArray[0] = ignoreLanguage.getFilename();
            String string = VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"vcs.add.to.igno\u2026.ignoreLanguage.filename)");
            return string;
        }
        VirtualFile virtualFile = projectDir;
        if (virtualFile == null) {
            virtualFile = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)$this$toTextRepresentation);
        }
        if (virtualFile == null) {
            String string = $this$toTextRepresentation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return string;
        }
        VirtualFile projectRootOrVcsRoot = virtualFile;
        String string = VfsUtil.getRelativePath((VirtualFile)$this$toTextRepresentation, (VirtualFile)projectRootOrVcsRoot);
        if (string == null) {
            String string2 = $this$toTextRepresentation.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        }
        return string;
    }

    private final AbstractVcs component1(VcsRoot $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"$this$component1");
        return $this$component1.getVcs();
    }

    private final VirtualFile component2(VcsRoot $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"$this$component2");
        VirtualFile virtualFile = $this$component2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"path");
        return virtualFile;
    }

    public IgnoreFileActionGroup(@NotNull IgnoreFileType ignoreFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)ignoreFileType), (String)"ignoreFileType");
        Object[] objectArray = new Object[1];
        IgnoreLanguage ignoreLanguage = ignoreFileType.getIgnoreLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ignoreLanguage), (String)"ignoreFileType.ignoreLanguage");
        objectArray[0] = ignoreLanguage.getFilename();
        String string = VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.text", (Object[])objectArray);
        Object[] objectArray2 = new Object[1];
        IgnoreLanguage ignoreLanguage2 = ignoreFileType.getIgnoreLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ignoreLanguage2), (String)"ignoreFileType.ignoreLanguage");
        objectArray2[0] = ignoreLanguage2.getFilename();
        super(string, VcsBundle.message((String)"vcs.add.to.ignore.file.action.group.description", (Object[])objectArray2), ignoreFileType.getIcon());
        this.ignoreFileType = ignoreFileType;
        this.actions = CollectionsKt.emptyList();
    }
}

