/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredFileGeneratorImpl
implements IgnoredFileGenerator {
    private static final Logger LOG = Logger.getInstance(IgnoredFileGeneratorImpl.class);
    private final Project myProject;
    private final Object myWriteLock;
    private static final Object myNotificationLock = new Object();
    @Nullable
    private static Notification myNotification;
    @Nullable
    private static VirtualFile myIgnoreFileRootNotificationShowFor;

    protected IgnoredFileGeneratorImpl(@NotNull Project project) {
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(0);
        }
        this.myWriteLock = new Object();
        this.myProject = project;
    }

    public void generateFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean notify) {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(2);
        }
        this.doGenerate(ignoreFileRoot, vcs, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGenerate(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean notify) {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(4);
        }
        if (this.skipGeneration(ignoreFileRoot, notify)) {
            return;
        }
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            LOG.debug("Cannot find content provider for vcs " + vcs.getName());
            return;
        }
        String ignoreFileName = ignoredFileContentProvider.getFileName();
        Object object = this.myWriteLock;
        synchronized (object) {
            String ignoreFileContent2 = ignoredFileContentProvider.buildIgnoreFileContent(ignoreFileRoot, (IgnoredFileProvider[])IgnoredFileProvider.IGNORE_FILE.getExtensions());
            if (StringUtil.isEmptyOrSpaces((String)ignoreFileContent2)) {
                return;
            }
            File ignoreFile = IgnoredFileGeneratorImpl.getIgnoreFile(ignoreFileRoot, ignoreFileName);
            if (notify && IgnoredFileGeneratorImpl.needAskToManageIgnoreFiles(this.myProject)) {
                IgnoredFileGeneratorImpl.notifyVcsIgnoreFileManage(this.myProject, ignoreFileRoot, ignoredFileContentProvider, () -> this.writeToFile(ignoreFileRoot, ignoreFile, ignoreFileContent2, true));
            } else {
                this.writeToFile(ignoreFileRoot, ignoreFile, ignoreFileContent2, false);
            }
        }
    }

    private boolean skipGeneration(@NotNull VirtualFile ignoreFileRoot, boolean notify) {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(5);
        }
        if (notify && !IgnoredFileGeneratorImpl.needGenerateIgnoreFile(this.myProject, ignoreFileRoot)) {
            LOG.debug("Skip VCS ignore file generation");
            return true;
        }
        if (!IgnoredFileGeneratorImpl.needGenerateInternalIgnoreFile(this.myProject, ignoreFileRoot)) {
            LOG.debug("Skip VCS internal ignore file generation");
            return true;
        }
        return false;
    }

    private void writeToFile(@NotNull VirtualFile ignoreFileRoot, @NotNull File ignoreFile, @NotNull String ignoreFileContent2, boolean openFile) {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(6);
        }
        if (ignoreFile == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(7);
        }
        if (ignoreFileContent2 == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(8);
        }
        boolean append = ignoreFile.exists();
        String projectCharsetName = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharsetName();
        try {
            if (append) {
                FileUtil.writeToFile((File)ignoreFile, (byte[])(System.lineSeparator() + ignoreFileContent2).getBytes(projectCharsetName), (boolean)true);
            } else {
                WriteAction.runAndWait(() -> {
                    VirtualFile newIgnoreFile = ignoreFileRoot.createChildData((Object)ignoreFileRoot, ignoreFile.getName());
                    VfsUtil.saveText((VirtualFile)newIgnoreFile, (String)ignoreFileContent2);
                });
            }
        }
        catch (IOException e) {
            LOG.warn("Cannot write to file " + ignoreFile.getPath());
        }
        IgnoredFileGeneratorImpl.markIgnoreFileRootAsGenerated(this.myProject, ignoreFile.getParent());
        LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(ignoreFile));
        if (openFile) {
            this.openFile(ignoreFile);
        }
    }

    private void openFile(@NotNull File file) {
        if (file == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            if (vFile == null) {
                return;
            }
            new OpenFileDescriptor(this.myProject, vFile).navigate(true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyVcsIgnoreFileManage(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileContentProvider ignoredFileContentProvider, @NotNull Runnable writeToIgnoreFile) {
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(10);
        }
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(11);
        }
        if (ignoredFileContentProvider == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(12);
        }
        if (writeToIgnoreFile == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(13);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        Object object = myNotificationLock;
        synchronized (object) {
            if (myNotification != null && myIgnoreFileRootNotificationShowFor != null && !myNotification.isExpired() && myIgnoreFileRootNotificationShowFor.equals(ignoreFileRoot)) {
                return;
            }
            myIgnoreFileRootNotificationShowFor = ignoreFileRoot;
            myNotification = VcsNotifier.getInstance(project).notifyMinorInfo("manage.ignore.files.notification", true, "", VcsBundle.message((String)"ignored.file.manage.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), ignoredFileContentProvider.getFileName()}), NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"ignored.file.manage.this.project", (Object[])new Object[0]), (event, notification) -> {
                writeToIgnoreFile.run();
                propertiesComponent.setValue("MANAGE_IGNORE_FILES", true);
                propertiesComponent.setValue("ASKED_MANAGE_IGNORE_FILES", true);
                Object object = myNotificationLock;
                synchronized (object) {
                    notification.expire();
                    myIgnoreFileRootNotificationShowFor = null;
                }
            }), NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"ignored.file.manage.all.project", (Object[])new Object[0]), (event, notification) -> {
                writeToIgnoreFile.run();
                applicationSettings.MANAGE_IGNORE_FILES = true;
                propertiesComponent.setValue("ASKED_MANAGE_IGNORE_FILES", true);
                Object object = myNotificationLock;
                synchronized (object) {
                    notification.expire();
                    myIgnoreFileRootNotificationShowFor = null;
                }
            }), NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"ignored.file.manage.notmanage", (Object[])new Object[0]), (event, notification) -> {
                propertiesComponent.setValue("ASKED_MANAGE_IGNORE_FILES", true);
                Object object = myNotificationLock;
                synchronized (object) {
                    notification.expire();
                    myIgnoreFileRootNotificationShowFor = null;
                }
            }));
        }
    }

    @NotNull
    private static File getIgnoreFile(@NotNull VirtualFile ignoreFileRoot, @NotNull String ignoreFileName) {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(14);
        }
        if (ignoreFileName == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(15);
        }
        File vcsRootFile = VfsUtilCore.virtualToIoFile((VirtualFile)ignoreFileRoot);
        return new File(vcsRootFile.getPath(), ignoreFileName);
    }

    public static boolean needGenerateInternalIgnoreFile(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        boolean wasGeneratedPreviously;
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(16);
        }
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(17);
        }
        if (wasGeneratedPreviously = IgnoredFileRootStore.getInstance(project).containsRoot(ignoreFileRoot.getPath())) {
            LOG.debug("Ignore file generated previously for root " + ignoreFileRoot.getPath());
            return false;
        }
        return true;
    }

    public static void markIgnoreFileRootAsGenerated(@NotNull Project project, @NotNull String ignoreFileRoot) {
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(18);
        }
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(19);
        }
        IgnoredFileRootStore.getInstance(project).addRoot(ignoreFileRoot);
    }

    private static boolean needGenerateIgnoreFile(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(20);
        }
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(21);
        }
        VcsApplicationSettings vcsApplicationSettings = VcsApplicationSettings.getInstance();
        if (vcsApplicationSettings.DISABLE_MANAGE_IGNORE_FILES) {
            return false;
        }
        boolean wasGeneratedPreviously = IgnoredFileRootStore.getInstance(project).containsRoot(ignoreFileRoot.getPath());
        if (wasGeneratedPreviously) {
            LOG.debug("Ignore file generated previously for root " + ignoreFileRoot.getPath());
            return false;
        }
        boolean needGenerateRegistryFlag = Registry.is((String)"vcs.ignorefile.generation", (boolean)true);
        if (!needGenerateRegistryFlag) {
            return false;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        boolean askedToManageIgnores = propertiesComponent.getBoolean("ASKED_MANAGE_IGNORE_FILES", false);
        return IgnoredFileGeneratorImpl.isManageIgnoreTurnOn(project) || !askedToManageIgnores;
    }

    private static boolean isManageIgnoreTurnOn(@NotNull Project project) {
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(22);
        }
        boolean globalManageIgnores = VcsApplicationSettings.getInstance().MANAGE_IGNORE_FILES;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        boolean manageIgnoresInProject = propertiesComponent.getBoolean("MANAGE_IGNORE_FILES", false);
        return globalManageIgnores || manageIgnoresInProject;
    }

    private static boolean needAskToManageIgnoreFiles(@NotNull Project project) {
        PropertiesComponent propertiesComponent;
        boolean askedToManageIgnores;
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(23);
        }
        return !(askedToManageIgnores = (propertiesComponent = PropertiesComponent.getInstance((Project)project)).getBoolean("ASKED_MANAGE_IGNORE_FILES", false)) && !IgnoredFileGeneratorImpl.isManageIgnoreTurnOn(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileContentProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeToIgnoreFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/IgnoredFileGeneratorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "skipGeneration";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "writeToFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyVcsIgnoreFileManage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getIgnoreFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "needGenerateInternalIgnoreFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "markIgnoreFileRootAsGenerated";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "needGenerateIgnoreFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isManageIgnoreTurnOn";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "needAskToManageIgnoreFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @com.intellij.openapi.components.State(name="IgnoredFileRootStore", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
    static final class IgnoredFileRootStore
    implements PersistentStateComponent<State> {
        State myState = new State();

        IgnoredFileRootStore() {
        }

        static IgnoredFileRootStore getInstance(Project project) {
            return (IgnoredFileRootStore)ServiceManager.getService((Project)project, IgnoredFileRootStore.class);
        }

        boolean containsRoot(@NotNull String root) {
            if (root == null) {
                IgnoredFileRootStore.$$$reportNull$$$0(0);
            }
            return this.myState.generatedRoots.contains(root);
        }

        void addRoot(@NotNull String root) {
            if (root == null) {
                IgnoredFileRootStore.$$$reportNull$$$0(1);
            }
            this.myState.generatedRoots.add(root);
        }

        @Nullable
        public State getState() {
            return this.myState;
        }

        public void loadState(@NotNull State state) {
            if (state == null) {
                IgnoredFileRootStore.$$$reportNull$$$0(2);
            }
            this.myState = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/IgnoredFileGeneratorImpl$IgnoredFileRootStore";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class State {
            public Set<String> generatedRoots = new HashSet<String>();

            State() {
            }
        }
    }
}

