/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProvider;
import com.intellij.openapi.vcs.changes.committed.OutdatedVersionNotifierKt;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "Lcom/intellij/openapi/util/Key;", "IncomingChangesListener", "intellij.platform.vcs.impl"})
public final class OutdatedVersionNotifier
extends EditorNotifications.Provider<EditorNotificationPanel> {
    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return OutdatedVersionNotifierKt.access$getKEY$p();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        void incomingChangeList;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CommittedChangesCache committedChangesCache = CommittedChangesCache.getInstanceIfCreated(project);
        if (committedChangesCache == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)committedChangesCache), (String)"CommittedChangesCache.ge\u2026d(project) ?: return null");
        CommittedChangesCache cache = committedChangesCache;
        Pair<CommittedChangeList, Change> pair = cache.getIncomingChangeList(file);
        if (pair == null) {
            return null;
        }
        Pair<CommittedChangeList, Change> pair2 = pair;
        CommittedChangeList committedChangeList = (CommittedChangeList)ExtensionsKt.component1(pair2);
        Change incomingChange = (Change)ExtensionsKt.component2(pair2);
        void v2 = incomingChangeList;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"incomingChangeList");
        AbstractVcs abstractVcs = v2.getVcs();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"incomingChangeList.vcs");
        if (!IncomingChangesViewProvider.Companion.isIncomingChangesAvailable(abstractVcs)) {
            return null;
        }
        Change change = incomingChange;
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"incomingChange");
        return OutdatedVersionNotifierKt.access$createOutdatedVersionPanel((CommittedChangeList)incomingChangeList, change);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$IncomingChangesListener;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changesCleared", "", "incomingChangesUpdated", "receivedChanges", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "intellij.platform.vcs.impl"})
    public static final class IncomingChangesListener
    implements CommittedChangesListener {
        private final Project project;

        public void incomingChangesUpdated(@Nullable List<? extends CommittedChangeList> receivedChanges) {
            CommittedChangesCache cache;
            CommittedChangesCache committedChangesCache = cache = CommittedChangesCache.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)committedChangesCache), (String)"cache");
            if (committedChangesCache.getCachedIncomingChanges() != null) {
                EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
            } else {
                cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)new Consumer<Boolean>(cache){
                    final /* synthetic */ CommittedChangesCache $cache;

                    public final void consume(Boolean hasCaches) {
                        if (!hasCaches.booleanValue()) {
                            return;
                        }
                        this.$cache.loadIncomingChangesAsync(null, true);
                    }
                    {
                        this.$cache = committedChangesCache;
                    }
                }));
            }
        }

        @Override
        public void changesCleared() {
            EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
        }

        public IncomingChangesListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }
}

