/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.StatusText;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\t*\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "browser", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesTreeBrowser;", "createIncomingChangesBrowser", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "loadIncomingChanges", "inBackground", "", "setIncomingChanges", "changeLists", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "Companion", "DisplayNameSupplier", "IncomingChangesListener", "VisibilityPredicate", "intellij.platform.vcs.impl"})
public final class IncomingChangesViewProvider
implements ChangesViewContentProvider {
    private CommittedChangesTreeBrowser browser;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void initTabContent(@NotNull Content content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        CommittedChangesTreeBrowser committedChangesTreeBrowser = this.createIncomingChangesBrowser();
        boolean bl = false;
        boolean bl2 = false;
        CommittedChangesTreeBrowser it = committedChangesTreeBrowser;
        boolean bl3 = false;
        this.browser = it;
        content2.setComponent((JComponent)it);
        content2.setDisposer(new Disposable(this, content2){
            final /* synthetic */ IncomingChangesViewProvider this$0;
            final /* synthetic */ Content $content$inlined;
            {
                this.this$0 = incomingChangesViewProvider;
                this.$content$inlined = content2;
            }

            public final void dispose() {
                IncomingChangesViewProvider.access$setBrowser$p(this.this$0, null);
            }
        });
        this.project.getMessageBus().connect((Disposable)it).subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new IncomingChangesListener());
        this.loadIncomingChanges(false);
    }

    private final CommittedChangesTreeBrowser createIncomingChangesBrowser() {
        CommittedChangesTreeBrowser committedChangesTreeBrowser = new CommittedChangesTreeBrowser(this.project, CollectionsKt.emptyList());
        boolean bl = false;
        boolean bl2 = false;
        CommittedChangesTreeBrowser $this$apply = committedChangesTreeBrowser;
        boolean bl3 = false;
        StatusText statusText2 = $this$apply.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"emptyText");
        statusText2.setText(VcsBundle.message((String)"incoming.changes.not.loaded.message", (Object[])new Object[0]));
        AnAction anAction = ActionManager.getInstance().getAction("IncomingChangesToolbar");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup group2 = (ActionGroup)anAction;
        ActionToolbar actionToolbar = $this$apply.createGroupFilterToolbar(this.project, group2, null, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createGroupFilterToolbar\u2026group, null, emptyList())");
        $this$apply.setToolBar(actionToolbar.getComponent());
        $this$apply.setTableContextMenu(group2, CollectionsKt.emptyList());
        return committedChangesTreeBrowser;
    }

    private final void loadIncomingChanges(boolean inBackground) {
        CommittedChangesCache cache = CommittedChangesCache.getInstance(this.project);
        cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)new Consumer<Boolean>(this, cache, inBackground){
            final /* synthetic */ IncomingChangesViewProvider this$0;
            final /* synthetic */ CommittedChangesCache $cache;
            final /* synthetic */ boolean $inBackground;

            public final void consume(boolean hasCaches) {
                if (!hasCaches) {
                    return;
                }
                CommittedChangesCache committedChangesCache = this.$cache;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)committedChangesCache), (String)"cache");
                List<CommittedChangeList> cachedIncomingChanges = committedChangesCache.getCachedIncomingChanges();
                if (cachedIncomingChanges != null) {
                    CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.access$getBrowser$p(this.this$0);
                    if (committedChangesTreeBrowser != null) {
                        IncomingChangesViewProvider.access$setIncomingChanges(this.this$0, committedChangesTreeBrowser, cachedIncomingChanges);
                    }
                } else {
                    this.$cache.loadIncomingChangesAsync((Consumer<? super List<CommittedChangeList>>)((Consumer)new Consumer<List<CommittedChangeList>>(this){
                        final /* synthetic */ loadIncomingChanges.1 this$0;

                        public final void consume(List<CommittedChangeList> incomingChanges) {
                            Application app$iv;
                            ModalityState modalityState$iv = null;
                            boolean $i$f$runInEdt = false;
                            Application application = app$iv = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                            if (application.isDispatchThread()) {
                                boolean bl = false;
                                CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.access$getBrowser$p(this.this$0.this$0);
                                if (committedChangesTreeBrowser != null) {
                                    List<CommittedChangeList> list = incomingChanges;
                                    Intrinsics.checkNotNullExpressionValue(list, (String)"incomingChanges");
                                    IncomingChangesViewProvider.access$setIncomingChanges(this.this$0.this$0, committedChangesTreeBrowser, list);
                                }
                            } else {
                                boolean $i$f$invokeLater = false;
                                Application application2 = ApplicationManager.getApplication();
                                Runnable runnable = new Runnable(this, incomingChanges){
                                    final /* synthetic */ loadIncomingChanges.1 this$0;
                                    final /* synthetic */ List $incomingChanges$inlined;
                                    {
                                        this.this$0 = var1_1;
                                        this.$incomingChanges$inlined = list;
                                    }

                                    public final void run() {
                                        block0: {
                                            boolean bl = false;
                                            CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.access$getBrowser$p(this.this$0.this$0.this$0);
                                            if (committedChangesTreeBrowser == null) break block0;
                                            List list = this.$incomingChanges$inlined;
                                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"incomingChanges");
                                            IncomingChangesViewProvider.access$setIncomingChanges(this.this$0.this$0.this$0, committedChangesTreeBrowser, list);
                                        }
                                    }
                                };
                                ModalityState modalityState = ModalityState.defaultModalityState();
                                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                                application2.invokeLater(runnable, modalityState);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }), this.$inBackground);
                }
            }
            {
                this.this$0 = incomingChangesViewProvider;
                this.$cache = committedChangesCache;
                this.$inBackground = bl;
            }
        }));
    }

    private final void setIncomingChanges(CommittedChangesTreeBrowser $this$setIncomingChanges, List<? extends CommittedChangeList> changeLists) {
        StatusText statusText2 = $this$setIncomingChanges.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"emptyText");
        statusText2.setText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
        $this$setIncomingChanges.setItems(changeLists, CommittedChangesBrowserUseCase.INCOMING);
    }

    public IncomingChangesViewProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ void access$setBrowser$p(IncomingChangesViewProvider $this, CommittedChangesTreeBrowser committedChangesTreeBrowser) {
        $this.browser = committedChangesTreeBrowser;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$IncomingChangesListener;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesListener;", "(Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider;)V", "changesCleared", "", "changesLoaded", "location", "Lcom/intellij/openapi/vcs/RepositoryLocation;", "changes", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "incomingChangesUpdated", "receivedChanges", "refreshErrorStatusChanged", "lastError", "Lcom/intellij/openapi/vcs/VcsException;", "updateModel", "intellij.platform.vcs.impl"})
    private final class IncomingChangesListener
    implements CommittedChangesListener {
        public void changesLoaded(@NotNull RepositoryLocation location, @NotNull List<? extends CommittedChangeList> changes) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.updateModel();
        }

        public void incomingChangesUpdated(@Nullable List<? extends CommittedChangeList> receivedChanges) {
            this.updateModel();
        }

        @Override
        public void changesCleared() {
            block0: {
                CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.this.browser;
                if (committedChangesTreeBrowser == null) break block0;
                IncomingChangesViewProvider.this.setIncomingChanges(committedChangesTreeBrowser, CollectionsKt.emptyList());
            }
        }

        @Override
        public void refreshErrorStatusChanged(@Nullable VcsException lastError) {
            block0: {
                VcsException vcsException = lastError;
                if (vcsException == null) break block0;
                VcsException vcsException2 = vcsException;
                boolean bl = false;
                boolean bl2 = false;
                VcsException it = vcsException2;
                boolean bl3 = false;
                VcsBalloonProblemNotifier.showOverChangesView(IncomingChangesViewProvider.this.project, it.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }

        private final void updateModel() {
            Application app$iv;
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                if (!IncomingChangesViewProvider.this.project.isDisposed() && IncomingChangesViewProvider.this.browser != null) {
                    IncomingChangesViewProvider.this.loadIncomingChanges(true);
                }
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ IncomingChangesListener this$0;
                    {
                        this.this$0 = incomingChangesListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!IncomingChangesViewProvider.access$getProject$p(this.this$0.IncomingChangesViewProvider.this).isDisposed() && IncomingChangesViewProvider.access$getBrowser$p(this.this$0.IncomingChangesViewProvider.this) != null) {
                            IncomingChangesViewProvider.access$loadIncomingChanges(this.this$0.IncomingChangesViewProvider.this, true);
                        }
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application2.invokeLater(runnable, modalityState);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate;", "Lcom/intellij/util/NotNullFunction;", "Lcom/intellij/openapi/project/Project;", "", "()V", "fun", "project", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "intellij.platform.vcs.impl"})
    public static final class VisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(@NotNull Project project) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
                AbstractVcs[] abstractVcsArray = projectLevelVcsManager.getAllActiveVcss();
                Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"ProjectLevelVcsManager.g\u2026ce(project).allActiveVcss");
                AbstractVcs[] $this$any$iv = abstractVcsArray;
                boolean $i$f$any = false;
                AbstractVcs[] abstractVcsArray2 = $this$any$iv;
                int n = abstractVcsArray2.length;
                for (int i = 0; i < n; ++i) {
                    AbstractVcs element$iv;
                    AbstractVcs it = element$iv = abstractVcsArray2[i];
                    boolean bl2 = false;
                    AbstractVcs abstractVcs = it;
                    Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"it");
                    if (!Companion.isIncomingChangesAvailable(abstractVcs)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "()V", "get", "intellij.platform.vcs.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string = VcsBundle.message((String)"incoming.changes.tab", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"incoming.changes.tab\")");
            return string;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$Companion;", "", "()V", "isIncomingChangesAvailable", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        public final boolean isIncomingChangesAvailable(@NotNull AbstractVcs vcs) {
            Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
            CachingCommittedChangesProvider cachingCommittedChangesProvider = vcs.getCachingCommittedChangesProvider();
            return cachingCommittedChangesProvider != null && cachingCommittedChangesProvider.supportsIncomingChanges();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

