/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.FontMetrics;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommittedChangeListRenderer
extends ColoredTreeCellRenderer {
    private final IssueLinkRenderer myRenderer;
    private final List<? extends CommittedChangeListDecorator> myDecorators;
    private final Project myProject;
    private int myDateWidth;
    private int myFontSize;

    public CommittedChangeListRenderer(Project project, List<? extends CommittedChangeListDecorator> decorators) {
        this.myProject = project;
        this.myRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
        this.myDecorators = decorators;
        this.myDateWidth = 0;
        this.myFontSize = -1;
    }

    @NotNull
    public static String getDescriptionOfChangeList(@NotNull String text2) {
        if (text2 == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(0);
        }
        String string = text2.replaceAll("\n", " // ");
        if (string == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String truncateDescription(@NotNull String initDescription, @NotNull FontMetrics fontMetrics, int maxWidth) {
        if (initDescription == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(2);
        }
        if (fontMetrics == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(3);
        }
        String description = initDescription;
        int descWidth = fontMetrics.stringWidth(description);
        while (description.length() > 0 && descWidth > maxWidth) {
            description = CommittedChangeListRenderer.trimLastWord(description);
            descWidth = fontMetrics.stringWidth(description + " ");
        }
        String string = description;
        if (string == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        this.customize(tree, value, selected, expanded, leaf, row2, hasFocus);
    }

    public void customize(JComponent tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof CommittedChangeList) {
            CommittedChangeList changeList = (CommittedChangeList)userObject;
            this.renderChangeList(tree, changeList);
        } else if (userObject instanceof String) {
            this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    public void renderChangeList(JComponent tree, CommittedChangeList changeList) {
        CachingCommittedChangesProvider provider;
        Container parent = tree.getParent();
        int rowX = CommittedChangeListRenderer.getRowX(this.myTree, 2);
        int availableWidth = parent == null ? 100 : parent.getWidth() - rowX;
        FontMetrics fontMetrics = tree.getFontMetrics(tree.getFont());
        FontMetrics boldMetrics = tree.getFontMetrics(tree.getFont().deriveFont(1));
        FontMetrics italicMetrics = tree.getFontMetrics(tree.getFont().deriveFont(2));
        if (this.myDateWidth <= 0 || fontMetrics.getFont().getSize() != this.myFontSize) {
            this.myDateWidth = Math.max(fontMetrics.stringWidth(", Yesterday 00:00 PM "), fontMetrics.stringWidth(", 00/00/00 00:00 PM "));
            this.myDateWidth = Math.max(this.myDateWidth, fontMetrics.stringWidth(DateFormatUtil.formatPrettyDateTime((Date)DateFormatUtil.getSampleDateTime())));
            this.myFontSize = fontMetrics.getFont().getSize();
        }
        int dateCommitterSize = this.myDateWidth + boldMetrics.stringWidth(changeList.getCommitterName());
        String description = CommittedChangeListRenderer.getDescriptionOfChangeList(changeList.getName().trim());
        for (CommittedChangeListDecorator committedChangeListDecorator : this.myDecorators) {
            Icon icon2 = committedChangeListDecorator.decorate(changeList);
            if (icon2 == null) continue;
            this.setIcon(icon2);
        }
        int descMaxWidth = availableWidth - dateCommitterSize - 8;
        boolean bl = changeList instanceof ReceivedChangeList && ((ReceivedChangeList)changeList).isPartial();
        int descWidth = 0;
        int partialMarkerWidth = 0;
        if (bl) {
            String partialMarker = VcsBundle.message((String)"committed.changes.partial.list", (Object[])new Object[0]) + " ";
            this.append(partialMarker, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            partialMarkerWidth = boldMetrics.stringWidth(partialMarker);
            descWidth += partialMarkerWidth;
        }
        descWidth += fontMetrics.stringWidth(description);
        int numberWidth = 0;
        AbstractVcs vcs = changeList.getVcs();
        if (vcs != null && (provider = vcs.getCachingCommittedChangesProvider()) != null && provider.getChangelistTitle() != null) {
            String number = "#" + changeList.getNumber() + "  ";
            numberWidth = fontMetrics.stringWidth(number);
            descWidth += numberWidth;
            this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        int branchWidth = 0;
        Object branch = changeList.getBranch();
        if (branch != null) {
            branch = (String)branch + " ";
            branchWidth = italicMetrics.stringWidth((String)branch);
            descWidth += branchWidth;
            this.append((String)branch, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        if (description.isEmpty()) {
            this.append(VcsBundle.message((String)"committed.changes.empty.comment", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.appendTextPadding(descMaxWidth);
        } else if (descMaxWidth < 0) {
            this.myRenderer.appendTextWithLinks(description);
        } else if (descWidth < descMaxWidth) {
            this.myRenderer.appendTextWithLinks(description);
            this.appendTextPadding(descMaxWidth);
        } else {
            String moreMarker = VcsBundle.message((String)"changes.browser.details.marker", (Object[])new Object[0]);
            int moreWidth = fontMetrics.stringWidth(moreMarker);
            int remainingWidth = descMaxWidth - moreWidth - numberWidth - branchWidth - partialMarkerWidth;
            description = CommittedChangeListRenderer.truncateDescription(description, fontMetrics, remainingWidth);
            this.myRenderer.appendTextWithLinks(description);
            if (!StringUtil.isEmpty((String)description)) {
                this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(moreMarker, SimpleTextAttributes.LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            } else if (remainingWidth > 0) {
                this.append(moreMarker, SimpleTextAttributes.LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            }
            this.appendTextPadding(descMaxWidth);
        }
        this.append(changeList.getCommitterName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (changeList.getCommitDate() != null) {
            this.append(", " + DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private static String trimLastWord(String description) {
        int pos = description.trim().lastIndexOf(32);
        if (pos >= 0) {
            return description.substring(0, pos).trim();
        }
        return description.substring(0, description.length() - 1);
    }

    public static int getRowX(JTree tree, int depth) {
        if (tree == null) {
            return 0;
        }
        TreeUI ui2 = tree.getUI();
        if (ui2 instanceof BasicTreeUI) {
            BasicTreeUI treeUI = (BasicTreeUI)ui2;
            return (treeUI.getLeftChildIndent() + treeUI.getRightChildIndent()) * depth;
        }
        int leftIndent = UIUtil.getTreeLeftChildIndent();
        int rightIndent = UIUtil.getTreeRightChildIndent();
        return (leftIndent + rightIndent) * depth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CommittedChangeListRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initDescription";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CommittedChangeListRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionOfChangeList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionOfChangeList";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "truncateDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

