/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListDetailsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangeList[] changeLists = (ChangeList[])e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        ChangeListDetailsAction.showDetailsPopup(project, (CommittedChangeList)changeLists[0]);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(1);
        }
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        e.getPresentation().setEnabled(e.getProject() != null && changeLists != null && changeLists.length == 1 && changeLists[0] instanceof CommittedChangeList);
    }

    public static void showDetailsPopup(@NotNull Project project, @NotNull CommittedChangeList changeList) {
        if (project == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(2);
        }
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(3);
        }
        String htmlFormat = "<html><head>%s</head><body>%s</body></html>";
        String details = String.format(htmlFormat, UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()), ChangeListDetailsAction.getDetails(project, changeList));
        JEditorPane editorPane = new JEditorPane("text/html", details);
        editorPane.setEditable(false);
        editorPane.setBackground(HintUtil.getInformationColor());
        editorPane.select(0, 0);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)editorPane), (JComponent)editorPane).setDimensionServiceKey(project, "changelist.details.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(VcsBundle.message((String)"changelist.details.title", (Object[])new Object[0])).createPopup().showInBestPositionFor(DataManager.getInstance().getDataContext());
    }

    @Nls
    @NotNull
    private static String getDetails(@NotNull Project project, @NotNull CommittedChangeList changeList) {
        if (project == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(4);
        }
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(5);
        }
        String string = StringUtil.join((Collection)ContainerUtil.packNullables((Object[])new String[]{ChangeListDetailsAction.getNumber(changeList), ChangeListDetailsAction.getCommitterAndDate(changeList), ChangeListDetailsAction.getCustomDetails(changeList), IssueLinkHtmlRenderer.formatTextWithLinks(project, changeList.getComment())}), (String)"<br/>");
        if (string == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @Nullable
    private static String getNumber(@NotNull CommittedChangeList changeList) {
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(7);
        }
        return Optional.ofNullable(changeList.getVcs()).map(AbstractVcs::getCachingCommittedChangesProvider).map(CachingCommittedChangesProvider::getChangelistTitle).map(changeListTitle -> changeListTitle + " #" + changeList.getNumber()).orElse(null);
    }

    @Nls
    @NotNull
    private static String getCommitterAndDate(@NotNull CommittedChangeList changeList) {
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(8);
        }
        @NonNls String committer = "<b>" + changeList.getCommitterName() + "</b>";
        String string = VcsBundle.message((String)"changelist.details.committed.format", (Object[])new Object[]{committer, DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate())});
        if (string == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nls
    @Nullable
    private static String getCustomDetails(@NotNull CommittedChangeList changeList) {
        AbstractVcs vcs;
        if (changeList == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(10);
        }
        if ((vcs = changeList.getVcs()) != null && vcs.getCachingCommittedChangesProvider() != null) {
            CommittedChangeList originalChangeList = ReceivedChangeList.unwrap(changeList);
            List customColumns = ContainerUtil.filter((Object[])vcs.getCachingCommittedChangesProvider().getColumns(), ChangeListColumn::isCustom);
            if (customColumns.isEmpty()) {
                return null;
            }
            return new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map((Collection)customColumns, column -> HtmlChunk.text((String)(column.getTitle() + ": " + ChangeListDetailsAction.toString(column.getValue((ChangeList)originalChangeList)))))).toString();
        }
        return null;
    }

    @Nls
    @NotNull
    private static String toString(@Nullable Object value) {
        String result2 = value != null ? value.toString() : "";
        String string = result2.isEmpty() ? VcsBundle.message((String)"changes.none", (Object[])new Object[0]) : result2;
        if (string == null) {
            ChangeListDetailsAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/ChangeListDetailsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/ChangeListDetailsAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterAndDate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showDetailsPopup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommitterAndDate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDetails";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

