/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"askMaxCount", "", "project", "Lcom/intellij/openapi/project/Project;", "getChangeBrowserSettings", "Lcom/intellij/openapi/vcs/versionBrowser/ChangeBrowserSettings;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "showCommittedChanges", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesActionKt {
    private static final ChangeBrowserSettings getChangeBrowserSettings(AbstractVcs vcs) {
        Object v = vcs.getConfiguration().changeBrowserSettings.computeIfAbsent(vcs.getName(), (Function)new Function<String, ChangeBrowserSettings>(vcs){
            final /* synthetic */ AbstractVcs $vcs;

            public final ChangeBrowserSettings apply(String vcsName) {
                CommittedChangesProvider committedChangesProvider = this.$vcs.getCommittedChangesProvider();
                Intrinsics.checkNotNull((Object)committedChangesProvider);
                ChangeBrowserSettings changeBrowserSettings = committedChangesProvider.createDefaultSettings();
                boolean bl = false;
                boolean bl2 = false;
                ChangeBrowserSettings it = changeBrowserSettings;
                boolean bl3 = false;
                Project project = this.$vcs.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"vcs.project");
                IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)project));
                ChangeBrowserSettings changeBrowserSettings2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)changeBrowserSettings2, (String)"it");
                iComponentStore.initPersistencePlainComponent((Object)changeBrowserSettings2, "VcsManager.ChangeBrowser." + vcsName);
                return changeBrowserSettings;
            }
            {
                this.$vcs = abstractVcs;
            }
        });
        Intrinsics.checkNotNullExpressionValue(v, (String)"vcs.configuration.change\u2026wser.$vcsName\")\n    }\n  }");
        return (ChangeBrowserSettings)v;
    }

    private static final void showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        int maxCount;
        int n;
        if (!settings.isAnyFilterSpecified()) {
            Project project = vcs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"vcs.project");
            n = BrowseCommittedChangesActionKt.askMaxCount(project);
        } else {
            n = maxCount = 0;
        }
        if (maxCount < 0) {
            return;
        }
        CommittedChangesCache committedChangesCache = CommittedChangesCache.getInstance(vcs.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)committedChangesCache), (String)"CommittedChangesCache.getInstance(vcs.project)");
        RepositoryLocation repositoryLocation = committedChangesCache.getLocationCache().getLocation(vcs, VcsUtil.getFilePath((VirtualFile)file), false);
        if (repositoryLocation == null) {
            VcsBalloonProblemNotifier.showOverVersionControlView(vcs.getProject(), VcsBundle.message((String)"changes.notification.content.repository.location.not.found.for", (Object[])new Object[]{file.getPresentableUrl()}), MessageType.ERROR);
            return;
        }
        AbstractVcsHelper abstractVcsHelper = AbstractVcsHelper.getInstance((Project)vcs.getProject());
        CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
        Intrinsics.checkNotNull((Object)committedChangesProvider);
        abstractVcsHelper.openCommittedChangesTab(committedChangesProvider, repositoryLocation, settings, maxCount, null);
    }

    private static final int askMaxCount(Project project) {
        int n;
        switch (Messages.showYesNoCancelDialog((Project)project, (String)VcsBundle.message((String)"browse.changes.no.filter.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.recent.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.all.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
            case 2: {
                n = -1;
                break;
            }
            case 0: {
                n = 50;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static final /* synthetic */ ChangeBrowserSettings access$getChangeBrowserSettings(AbstractVcs vcs) {
        return BrowseCommittedChangesActionKt.getChangeBrowserSettings(vcs);
    }

    public static final /* synthetic */ void access$showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        BrowseCommittedChangesActionKt.showCommittedChanges(vcs, file, settings);
    }
}

