/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffFromLocalChangesActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(ChangesListView.DATA_KEY) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        JBIterable<Change> changes = view.getSelectedChanges();
        JBIterable<FilePath> unversionedFiles = view.getSelectedUnversionedFiles();
        if ("MainMenu".equals(e.getPlace())) {
            e.getPresentation().setEnabled(project != null && (changes.isNotEmpty() || unversionedFiles.isNotEmpty()));
        } else {
            e.getPresentation().setEnabled(project != null && ShowDiffFromLocalChangesActionProvider.canShowDiff(project, changes, unversionedFiles));
        }
    }

    private static boolean canShowDiff(@Nullable Project project, @NotNull JBIterable<? extends Change> changes, @NotNull JBIterable<? extends FilePath> paths) {
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(2);
        }
        if (paths == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(3);
        }
        return paths.isNotEmpty() || changes.filter(it -> ChangeDiffRequestProducer.canCreate(project, it)).isNotEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GoToChangePopupBuilder.Chain chain;
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(4);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List changes = view.getSelectedChanges().toList();
        List unversioned = view.getSelectedUnversionedFiles().toList();
        boolean needsConversion = ShowDiffFromLocalChangesActionProvider.checkIfThereAreFakeRevisions(project, changes);
        if (needsConversion) {
            final FutureResult resultRef = new FutureResult();
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(true, () -> {
                try {
                    ChangesViewManager.getInstanceEx(project).refreshImmediately();
                    List<Change> actualChanges = ShowDiffFromLocalChangesActionProvider.loadFakeRevisions(project, changes);
                    resultRef.set(ShowDiffFromLocalChangesActionProvider.collectRequestProducers(project, actualChanges, unversioned, view));
                }
                catch (Throwable err) {
                    resultRef.setException(err);
                }
            });
            chain = new ChangeDiffRequestChain.Async(){

                @Override
                @NotNull
                protected ListSelection<? extends ChangeDiffRequestChain.Producer> loadRequestProducers() throws DiffRequestProducerException {
                    ListSelection listSelection;
                    try {
                        listSelection = (ListSelection)resultRef.get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        throw new DiffRequestProducerException((Throwable)ex);
                    }
                    if (listSelection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return listSelection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider$1", "loadRequestProducers"));
                }
            };
        } else {
            ListSelection<ChangeDiffRequestChain.Producer> producers2 = ShowDiffFromLocalChangesActionProvider.collectRequestProducers(project, changes, unversioned, view);
            if (producers2.isEmpty()) {
                return;
            }
            chain = new ChangeDiffRequestChain(producers2.getList(), producers2.getSelectedIndex());
        }
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, (Object)true);
        ShowDiffFromLocalChangesActionProvider.setAllowExcludeFromCommit(project, (DiffRequestChain)chain);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project, @NotNull List<? extends Change> changes) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(5);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(6);
        }
        boolean needsConversion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @NotNull
    private static List<Change> loadFakeRevisions(@NotNull Project project, @NotNull List<? extends Change> changes) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(8);
        }
        ArrayList<Change> actualChanges = new ArrayList<Change>();
        for (Change change : changes) {
            actualChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        ArrayList<Change> arrayList = actualChanges;
        if (arrayList == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static ListSelection<ChangeDiffRequestChain.Producer> collectRequestProducers(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull List<? extends FilePath> unversioned, @NotNull ChangesListView changesView2) {
        Change selectedChange;
        List<Change> changelistChanges;
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(10);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(11);
        }
        if (unversioned == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(12);
        }
        if (changesView2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(13);
        }
        if (changes.size() == 1 && unversioned.isEmpty() && (changelistChanges = changesView2.getAllChangesFromSameChangelist(selectedChange = changes.get(0))) != null) {
            int selectedIndex = ContainerUtil.indexOf(changelistChanges, it -> ChangeListChange.HASHING_STRATEGY.equals((Object)selectedChange, it));
            if (selectedIndex == -1) {
                selectedIndex = changelistChanges.indexOf(selectedChange);
            }
            ListSelection<ChangeDiffRequestChain.Producer> listSelection = ShowDiffFromLocalChangesActionProvider.createChangeProducers(project, changelistChanges, selectedIndex);
            if (listSelection == null) {
                ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(14);
            }
            return listSelection;
        }
        if (unversioned.size() == 1 && changes.isEmpty()) {
            FilePath selectedFile = unversioned.get(0);
            List allUnversioned = changesView2.getUnversionedFiles().collect(Collectors.toList());
            int selectedIndex = allUnversioned.indexOf(selectedFile);
            ListSelection<ChangeDiffRequestChain.Producer> listSelection = ShowDiffFromLocalChangesActionProvider.createUnversionedProducers(project, allUnversioned, selectedIndex);
            if (listSelection == null) {
                ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(15);
            }
            return listSelection;
        }
        ListSelection<ChangeDiffRequestChain.Producer> changeProducers = ShowDiffFromLocalChangesActionProvider.createChangeProducers(project, changes, 0);
        ListSelection<ChangeDiffRequestChain.Producer> unversionedProducers = ShowDiffFromLocalChangesActionProvider.createUnversionedProducers(project, unversioned, 0);
        ListSelection listSelection = ListSelection.createAt((List)ContainerUtil.concat((List)changeProducers.getList(), (List)unversionedProducers.getList()), (int)0);
        if (listSelection == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(16);
        }
        return listSelection;
    }

    private static ListSelection<ChangeDiffRequestChain.Producer> createChangeProducers(@NotNull Project project, @NotNull List<? extends Change> changes, int selected) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(17);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(18);
        }
        return ListSelection.createAt(changes, (int)selected).map(change -> ChangeDiffRequestProducer.create(project, change));
    }

    private static ListSelection<ChangeDiffRequestChain.Producer> createUnversionedProducers(@NotNull Project project, @NotNull List<? extends FilePath> unversioned, int selected) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(19);
        }
        if (unversioned == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(20);
        }
        return ListSelection.createAt(unversioned, (int)selected).map(path2 -> UnversionedDiffRequestProducer.create(project, path2));
    }

    private static void setAllowExcludeFromCommit(@NotNull Project project, @NotNull DiffRequestChain chain) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(21);
        }
        if (chain == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(22);
        }
        boolean allowExcludeFromCommit = ChangesViewManager.getInstanceEx(project).isAllowExcludeFromCommit();
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)allowExcludeFromCommit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unversioned";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesView";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFakeRevisions";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRequestProducers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canShowDiff";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkIfThereAreFakeRevisions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadFakeRevisions";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectRequestProducers";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createChangeProducers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createUnversionedProducers";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setAllowExcludeFromCommit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

