/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDeletionAction;
import com.intellij.openapi.vcs.changes.actions.RollbackFilesAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackAction
extends AnAction
implements DumbAware,
UpdateInBackground {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(false);
        Project project = e.getProject();
        if (project == null || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return;
        }
        if (RollbackFilesAction.isPreferCheckboxesOverSelection() && CommitModeManager.getInstance(project).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode && "ChangesViewPopup".equals(e.getPlace())) {
            return;
        }
        Object[] leadSelection = (Change[])e.getData(VcsDataKeys.CHANGE_LEAD_SELECTION);
        boolean hasDataToRollback = !ArrayUtil.isEmpty((Object[])leadSelection) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_LOCALLY_DELETED)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES)) || !RollbackAction.getIncludedChanges(e).isEmpty() || RollbackAction.hasReversibleFiles(e) || RollbackAction.currentChangelistNotEmpty(project);
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(hasDataToRollback);
        e.getPresentation().setText(RollbackUtil.getRollbackOperationName(project) + "\u2026");
    }

    private static boolean hasReversibleFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(1);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)((Project)e.getRequiredData(CommonDataKeys.PROJECT)));
        HashSet modifiedWithoutEditing = new HashSet(manager.getModifiedWithoutEditing());
        return JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).filter(file -> manager.haveChangesUnder(file) != ThreeState.NO || manager.isFileAffected(file) || modifiedWithoutEditing.contains(file)).isNotEmpty();
    }

    private static boolean currentChangelistNotEmpty(Project project) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        LocalChangeList list = clManager.getDefaultChangeList();
        return !list.getChanges().isEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(2);
        }
        if (!RollbackFilesAction.checkClmActive(e)) {
            return;
        }
        Project project = Objects.requireNonNull(e.getProject());
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        List changes = RollbackAction.getChanges(e);
        LinkedHashSet<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e, project);
        if (modifiedWithoutEditing != null) {
            changes = ContainerUtil.filter(changes, change -> !modifiedWithoutEditing.contains(change.getVirtualFile()));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean hasChanges = false;
        if (missingFiles != null && !missingFiles.isEmpty()) {
            hasChanges = true;
            new RollbackDeletionAction().actionPerformed(e);
        }
        if (modifiedWithoutEditing != null && !modifiedWithoutEditing.isEmpty()) {
            hasChanges = true;
            RollbackAction.rollbackModifiedWithoutEditing(project, modifiedWithoutEditing);
        }
        if (!changes.isEmpty()) {
            RollbackChangesDialog.rollbackChanges(project, changes);
        } else if (!hasChanges) {
            RollbackChangesDialog.rollbackChanges(project);
        }
    }

    @NotNull
    private static Collection<Change> getChanges(@NotNull AnActionEvent e) {
        VirtualFile[] files;
        Collection<Change> includedChanges;
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(3);
        }
        if (!(includedChanges = RollbackAction.getIncludedChanges(e)).isEmpty()) {
            Collection<Change> collection = includedChanges;
            if (collection == null) {
                RollbackAction.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Object[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null && (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)Objects.requireNonNull(e.getProject()));
            ArrayList changesList = new ArrayList();
            for (VirtualFile vf : files) {
                changesList.addAll(clManager.getChangesIn(vf));
            }
            if (!changesList.isEmpty()) {
                changes = changesList.toArray(new Change[0]);
            }
        }
        if (!ArrayUtil.isEmpty((Object[])changes)) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])changes);
            if (arrayList == null) {
                RollbackAction.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        List<Change> list = Collections.emptyList();
        if (list == null) {
            RollbackAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static Collection<Change> getIncludedChanges(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackAction.$$$reportNull$$$0(7);
        }
        if (!RollbackFilesAction.isPreferCheckboxesOverSelection()) {
            List<Change> list = Collections.emptyList();
            if (list == null) {
                RollbackAction.$$$reportNull$$$0(8);
            }
            return list;
        }
        ChangesListView changesView2 = (ChangesListView)((Object)e.getData(ChangesListView.DATA_KEY));
        if (changesView2 == null) {
            List<Change> list = Collections.emptyList();
            if (list == null) {
                RollbackAction.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = ContainerUtil.filterIsInstance((Collection)changesView2.getInclusionModel().getInclusion(), Change.class);
        if (list == null) {
            RollbackAction.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private static LinkedHashSet<VirtualFile> getModifiedWithoutEditing(AnActionEvent e, Project project) {
        List modifiedWithoutEditing = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        if (modifiedWithoutEditing != null && modifiedWithoutEditing.size() > 0) {
            return new LinkedHashSet<VirtualFile>(modifiedWithoutEditing);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null && virtualFiles.length > 0) {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>(Arrays.asList(virtualFiles));
            result2.retainAll(ChangeListManager.getInstance((Project)project).getModifiedWithoutEditing());
            return result2;
        }
        return null;
    }

    private static void rollbackModifiedWithoutEditing(Project project, LinkedHashSet<VirtualFile> modifiedWithoutEditing) {
        String operationName = StringUtil.decapitalize((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project)));
        String message = modifiedWithoutEditing.size() == 1 ? VcsBundle.message((String)"rollback.modified.without.editing.confirm.single", (Object[])new Object[]{operationName, ((VirtualFile)modifiedWithoutEditing.iterator().next()).getPresentableUrl()}) : VcsBundle.message((String)"rollback.modified.without.editing.confirm.multiple", (Object[])new Object[]{operationName, modifiedWithoutEditing.size()});
        int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.action.rollback.title", (Object[])new Object[]{operationName}), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        ArrayList exceptions = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = () -> {
            ProgressIndicator indicator = progressManager.getProgressIndicator();
            try {
                ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)modifiedWithoutEditing, (vcs, items) -> {
                    RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
                    if (rollbackEnvironment != null) {
                        if (indicator != null) {
                            indicator.setText(VcsBundle.message((String)"progress.text.performing", (Object[])new Object[]{vcs.getDisplayName(), StringUtil.toLowerCase((String)UIUtil.removeMnemonic((String)rollbackEnvironment.getRollbackOperationName()))}));
                            indicator.setIndeterminate(false);
                        }
                        rollbackEnvironment.rollbackModifiedWithoutCheckout(items, exceptions, (RollbackProgressListener)new RollbackProgressModifier(items.size(), indicator));
                        if (indicator != null) {
                            indicator.setText2("");
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (!exceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"rollback.modified.without.checkout.error.tab", (Object[])new Object[]{operationName}));
            }
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)modifiedWithoutEditing));
            VirtualFileManager.getInstance().asyncRefresh(() -> {
                for (VirtualFile virtualFile : modifiedWithoutEditing) {
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(virtualFile);
                }
            });
        };
        progressManager.runProcessWithProgressSynchronously(action, operationName, true, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/RollbackAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RollbackAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasReversibleFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

