/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\u0013\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/changes/VirtualFileHolder;", "Lcom/intellij/openapi/vcs/changes/FileHolder;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFiles", "()Ljava/util/List;", "myFiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addFile", "", "file", "cleanAll", "cleanAndAdjustScope", "scope", "Lcom/intellij/openapi/vcs/changes/VcsModifiableDirtyScope;", "containsFile", "", "copy", "equals", "other", "", "hashCode", "", "removeFile", "Companion", "intellij.platform.vcs.impl"})
public final class VirtualFileHolder
implements FileHolder {
    private final HashSet<VirtualFile> myFiles;
    private final Project myProject;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<VirtualFile> getFiles() {
        return CollectionsKt.toList((Iterable)this.myFiles);
    }

    @Override
    public void cleanAll() {
        this.myFiles.clear();
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Companion.cleanScope((Collection<VirtualFile>)this.myFiles, scope2);
    }

    public final void addFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myFiles.add(file);
    }

    public final void removeFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myFiles.remove(file);
    }

    @Override
    @NotNull
    public VirtualFileHolder copy() {
        VirtualFileHolder virtualFileHolder = new VirtualFileHolder(this.myProject);
        boolean bl = false;
        boolean bl2 = false;
        VirtualFileHolder it = virtualFileHolder;
        boolean bl3 = false;
        it.myFiles.addAll((Collection<VirtualFile>)this.myFiles);
        return virtualFileHolder;
    }

    public final boolean containsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.myFiles.contains(file);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VirtualFileHolder");
        }
        VirtualFileHolder cfr_ignored_0 = (VirtualFileHolder)object2;
        return Intrinsics.areEqual(this.myFiles, ((VirtualFileHolder)other).myFiles);
    }

    public int hashCode() {
        return this.myFiles.hashCode();
    }

    public VirtualFileHolder(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        boolean bl = false;
        this.myFiles = new HashSet();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/VirtualFileHolder$Companion;", "", "()V", "cleanScope", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "scope", "Lcom/intellij/openapi/vcs/changes/VcsModifiableDirtyScope;", "fileDropped", "", "file", "intellij.platform.vcs.impl"})
    public static final class Companion {
        public final void cleanScope(@NotNull Collection<VirtualFile> files, @NotNull VcsModifiableDirtyScope scope2) {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                    ProgressManager.checkCanceled();
                    if (files.isEmpty()) {
                        return;
                    }
                    if (scope2.getRecursivelyDirtyDirectories().size() != 0) break block6;
                    Set dirtyFiles = scope2.getDirtyFiles();
                    boolean cleanDroppedFiles = false;
                    Iterator iterator = dirtyFiles.iterator();
                    while (iterator.hasNext()) {
                        FilePath dirtyFile;
                        FilePath filePath = dirtyFile = (FilePath)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"dirtyFile");
                        VirtualFile f = filePath.getVirtualFile();
                        if (f != null) {
                            files.remove(f);
                            continue;
                        }
                        cleanDroppedFiles = true;
                    }
                    if (!cleanDroppedFiles) break block7;
                    Iterator<VirtualFile> iterator2 = files.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile file = iterator2.next();
                        if (!this.fileDropped(file)) continue;
                        iterator2.remove();
                        scope2.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file));
                    }
                    break block7;
                }
                Iterator<VirtualFile> iterator = files.iterator();
                while (iterator.hasNext()) {
                    VirtualFile file = iterator.next();
                    boolean fileDropped = this.fileDropped(file);
                    if (fileDropped) {
                        scope2.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file));
                    }
                    if (!fileDropped && !scope2.belongsTo(VcsUtil.getFilePath((VirtualFile)file))) continue;
                    iterator.remove();
                }
            }
        }

        private final boolean fileDropped(VirtualFile file) {
            return !file.isValid();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

