/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitter;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewModifier;
import com.intellij.openapi.vcs.changes.ChangesViewPanel;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.problems.ProblemListener;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullFunction;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflow;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.PartialCommitChangeNodeDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewEx,
PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ChangesViewManager.class);
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;
    @Nullable
    private ChangesViewToolWindowPanel myToolWindowPanel;

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(0);
        }
        ChangesViewI changesViewI = (ChangesViewI)project.getService(ChangesViewI.class);
        if (changesViewI == null) {
            ChangesViewManager.$$$reportNull$$$0(1);
        }
        return changesViewI;
    }

    @NotNull
    public static ChangesViewEx getInstanceEx(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(2);
        }
        return (ChangesViewEx)ChangesViewManager.getInstance(project);
    }

    public ChangesViewManager(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(3);
        }
        this.myState = new State();
        this.myProject = project;
        ChangesViewModifier.KEY.addChangeListener((AreaInstance)project, this::refreshImmediately, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(CommitModeManager.COMMIT_MODE_TOPIC, () -> this.updateCommitWorkflow());
        ApplicationManager.getApplication().invokeLater(() -> this.updateCommitWorkflow(), this.myProject.getDisposed());
    }

    @NotNull
    @RequiresEdt
    private ChangesViewToolWindowPanel initToolWindowPanel() {
        if (this.myToolWindowPanel == null) {
            ChangesViewToolWindowPanel panel2 = new ChangesViewToolWindowPanel(this.myProject, this);
            Disposer.register((Disposable)this, (Disposable)panel2);
            this.myToolWindowPanel = panel2;
            Disposer.register((Disposable)panel2, () -> {
                this.myToolWindowPanel = null;
            });
        }
        ChangesViewToolWindowPanel changesViewToolWindowPanel = this.myToolWindowPanel;
        if (changesViewToolWindowPanel == null) {
            ChangesViewManager.$$$reportNull$$$0(4);
        }
        return changesViewToolWindowPanel;
    }

    public void dispose() {
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(5);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(6);
        }
        this.myState = state;
        this.migrateShowFlattenSetting();
    }

    private void migrateShowFlattenSetting() {
        if (!this.myState.myShowFlatten) {
            this.myState.groupingKeys = ContainerUtil.set((Object[])ChangesTree.DEFAULT_GROUPING_KEYS);
            this.myState.myShowFlatten = true;
        }
    }

    @Override
    public void scheduleRefresh() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.scheduleRefresh();
    }

    @Override
    public void selectFile(VirtualFile vFile) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectFile(vFile);
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            ChangesViewManager.$$$reportNull$$$0(7);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectChanges(changes);
    }

    @Override
    public void updateProgressText(@NlsContexts.Label String text2, boolean isError) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateProgressText(text2, isError);
    }

    @Override
    public void setBusy(boolean b) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setBusy(b);
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        if (groupingKey == null) {
            ChangesViewManager.$$$reportNull$$$0(8);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setGrouping(groupingKey);
    }

    @RequiresEdt
    private void updateCommitWorkflow() {
        boolean isNonModal = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode;
        if (this.myToolWindowPanel != null) {
            this.myToolWindowPanel.updateCommitWorkflow(isNonModal);
        } else if (isNonModal) {
            this.initToolWindowPanel().updateCommitWorkflow(isNonModal);
        }
    }

    @Override
    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        if (this.myToolWindowPanel == null) {
            return null;
        }
        return this.myToolWindowPanel.getCommitWorkflowHandler();
    }

    @Override
    public void refreshImmediately() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.refreshImmediately();
    }

    @Override
    public boolean isAllowExcludeFromCommit() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.isAllowExcludeFromCommit();
    }

    public boolean isEditorPreview() {
        return this.myToolWindowPanel != null && !this.myToolWindowPanel.isSplitterPreview();
    }

    public void openEditorPreview() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.openEditorPreview();
    }

    public void closeEditorPreview() {
        this.closeEditorPreview(false);
    }

    public void closeEditorPreview(boolean onlyIfEmpty) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.closeEditorPreview(onlyIfEmpty);
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(@NlsContexts.Label String text2, boolean isError) {
        Factory factory = () -> {
            JLabel label = new JLabel(text2);
            label.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label;
        };
        if (factory == null) {
            ChangesViewManager.$$$reportNull$$$0(9);
        }
        return factory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initToolWindowPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextStatusFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceEx";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectChanges";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyContentDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyContentDnDTarget(@NotNull Project project, @NotNull Content content2) {
            if (project == null) {
                MyContentDnDTarget.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                MyContentDnDTarget.$$$reportNull$$$0(1);
            }
            super(project, content2);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ChangesViewToolWindowPanel panel2 = ((ChangesViewManager)ChangesViewManager.getInstance(this.myProject)).initToolWindowPanel();
                ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attachedObject, ChangesTreeDnDSupport.getDropRootNode(panel2.myView, event), !ChangesTreeDnDSupport.isCopyAction(event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyContentDnDTarget.$$$reportNull$$$0(2);
            }
            if ((attachedObject = event.getAttachedObject()) instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyContentDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ChangesViewToolWindowPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private static final RegistryValue isToolbarHorizontalSetting = Registry.get((String)"vcs.local.changes.toolbar.horizontal");
        @NotNull
        private static final RegistryValue isEditorDiffPreview = Registry.get((String)"show.diff.preview.as.editor.tab");
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesViewManager myChangesViewManager;
        @NotNull
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final BorderLayoutPanel myMainPanel;
        @NotNull
        private final BorderLayoutPanel myContentPanel;
        @NotNull
        private final ChangesViewPanel myChangesPanel;
        @NotNull
        private final ChangesListView myView;
        @NotNull
        private final ChangesViewCommitPanelSplitter myCommitPanelSplitter;
        private ChangesViewDiffPreviewProcessor myChangeProcessor;
        private DiffPreview myDiffPreview;
        @NotNull
        private final Wrapper myProgressLabel;
        @Nullable
        private ChangesViewCommitPanel myCommitPanel;
        @Nullable
        private ChangesViewCommitWorkflowHandler myCommitWorkflowHandler;
        @NotNull
        private final Alarm myTreeUpdateAlarm;
        @NotNull
        private final Object myTreeUpdateIndicatorLock;
        @NotNull
        private ProgressIndicator myTreeUpdateIndicator;
        private boolean myModelUpdateInProgress;
        private boolean myDisposed;

        private ChangesViewToolWindowPanel(@NotNull Project project, @NotNull ChangesViewManager changesViewManager) {
            if (project == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(0);
            }
            if (changesViewManager == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(1);
            }
            super(false, true);
            this.myProgressLabel = new Wrapper();
            this.myTreeUpdateIndicatorLock = new Object();
            this.myTreeUpdateIndicator = new EmptyProgressIndicator();
            this.myDisposed = false;
            this.myProject = project;
            this.myChangesViewManager = changesViewManager;
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myTreeUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
            this.myChangesPanel = new ChangesViewPanel(project);
            this.myView = this.myChangesPanel.getChangesView();
            this.myView.installPopupHandler((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
            this.myView.getGroupingSupport().setGroupingKeysOrSkip(this.myChangesViewManager.myState.groupingKeys);
            this.myView.addGroupingChangeListener(e -> {
                this.myChangesViewManager.myState.groupingKeys = this.myView.getGroupingSupport().getGroupingKeys();
                this.scheduleRefresh();
            });
            ChangesViewDnDSupport.install(this.myProject, this.myView, this);
            this.myChangesPanel.getToolbarActionGroup().addAll(this.createChangesToolbarActions(this.myView.getTreeExpander()));
            ChangesViewToolWindowPanel.registerShortcuts((JComponent)((Object)this));
            this.configureToolbars();
            isToolbarHorizontalSetting.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.configureToolbars();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$1", "afterValueChanged"));
                }
            }, (Disposable)this);
            this.myCommitPanelSplitter = new ChangesViewCommitPanelSplitter(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myCommitPanelSplitter);
            this.myCommitPanelSplitter.setFirstComponent((JComponent)((Object)this.myChangesPanel));
            this.myContentPanel = new BorderLayoutPanel(){

                public Dimension getMinimumSize() {
                    return this.isMinimumSizeSet() || myChangesPanel.isToolbarHorizontal() ? super.getMinimumSize() : myChangesPanel.getToolbar().getComponent().getPreferredSize();
                }
            };
            this.myContentPanel.addToCenter((Component)((Object)this.myCommitPanelSplitter));
            this.myMainPanel = JBUI.Panels.simplePanel((Component)this.myContentPanel);
            this.setDiffPreview();
            isEditorDiffPreview.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.setDiffPreview();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$3", "afterValueChanged"));
                }
            }, (Disposable)this);
            isOpenEditorDiffPreviewWithSingleClick.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (!this.isSplitterPreview()) {
                        this.setDiffPreview(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$4", "afterValueChanged"));
                }
            }, (Disposable)this);
            busConnection.subscribe(ChangesViewContentManagerListener.TOPIC, () -> this.setDiffPreview());
            this.setContent((JComponent)this.myMainPanel.addToBottom((Component)this.myProgressLabel));
            busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

                public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                    if (toolWindowManager == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    this.setCommitSplitOrientation();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$5", "stateChanged"));
                }
            });
            busConnection.subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> this.scheduleRefresh());
            busConnection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

                public void problemsAppeared(@NotNull VirtualFile file) {
                    if (file == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    this.refreshChangesViewNodeAsync(file);
                }

                public void problemsDisappeared(@NotNull VirtualFile file) {
                    if (file == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    this.refreshChangesViewNodeAsync(file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "file";
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "problemsAppeared";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "problemsDisappeared";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            busConnection.subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
            busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, () -> {
                if (this.myChangeProcessor != null) {
                    this.myChangeProcessor.fireDiffSettingsChanged();
                }
            });
            this.scheduleRefresh();
            this.myDiffPreview.updatePreview(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.myDisposed = true;
            this.myTreeUpdateAlarm.cancelAllRequests();
            Object object = this.myTreeUpdateIndicatorLock;
            synchronized (object) {
                this.myTreeUpdateIndicator.cancel();
            }
        }

        private void setDiffPreview() {
            this.setDiffPreview(false);
        }

        private void setDiffPreview(boolean force) {
            boolean isEditorPreview;
            if (this.myDisposed) {
                return;
            }
            boolean bl = isEditorPreview = ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject) || isEditorDiffPreview.asBoolean();
            if (!force) {
                if (isEditorPreview && this.myDiffPreview instanceof EditorTabPreview) {
                    return;
                }
                if (!isEditorPreview && this.isSplitterPreview()) {
                    return;
                }
            }
            if (this.myChangeProcessor != null) {
                Disposer.dispose((Disposable)this.myChangeProcessor);
            }
            String place = isEditorPreview ? "Default" : "ChangesView";
            this.myChangeProcessor = new ChangesViewDiffPreviewProcessor(this.myView, place);
            Disposer.register((Disposable)this, (Disposable)this.myChangeProcessor);
            this.myDiffPreview = isEditorPreview ? this.installEditorPreview(this.myChangeProcessor) : this.installSplitterPreview(this.myChangeProcessor);
            this.configureDiffPreview();
        }

        @NotNull
        private EditorTabPreview installEditorPreview(final @NotNull ChangesViewDiffPreviewProcessor changeProcessor) {
            if (changeProcessor == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(2);
            }
            EditorTabPreview editorPreview = new EditorTabPreview((DiffRequestProcessor)changeProcessor){

                @Override
                protected String getCurrentName() {
                    return changeProcessor.getCurrentChangeName();
                }

                @Override
                protected boolean hasContent() {
                    return changeProcessor.getCurrentChangeName() != null;
                }

                @Override
                protected boolean skipPreviewUpdate() {
                    if (super.skipPreviewUpdate()) {
                        return true;
                    }
                    if (!((Object)((Object)myView)).equals(IdeFocusManager.getInstance((Project)myProject).getFocusOwner())) {
                        return true;
                    }
                    if (!this.isEditorPreviewAllowed()) {
                        return true;
                    }
                    return myModelUpdateInProgress;
                }

                @Override
                protected boolean isPreviewOnDoubleClickAllowed() {
                    return VcsApplicationSettings.getInstance().SHOW_EDITOR_PREVIEW_ON_DOUBLE_CLICK;
                }

                @Override
                protected boolean isPreviewOnEnterAllowed() {
                    return VcsApplicationSettings.getInstance().SHOW_EDITOR_PREVIEW_ON_DOUBLE_CLICK;
                }
            };
            editorPreview.setEscapeHandler(() -> {
                editorPreview.closePreview();
                ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            });
            if (isOpenEditorDiffPreviewWithSingleClick.asBoolean()) {
                editorPreview.openWithSingleClick(this.myView);
            } else {
                editorPreview.openWithDoubleClick(this.myView);
            }
            editorPreview.installNextDiffActionOn((JComponent)this.myContentPanel);
            UIUtil.putClientProperty((JComponent)((Object)this.myView), (Key)ExpandableItemsHandler.IGNORE_ITEM_SELECTION, (Object)true);
            EditorTabPreview editorTabPreview = editorPreview;
            if (editorTabPreview == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(3);
            }
            return editorTabPreview;
        }

        @NotNull
        private PreviewDiffSplitterComponent installSplitterPreview(@NotNull ChangesViewDiffPreviewProcessor changeProcessor) {
            if (changeProcessor == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(4);
            }
            PreviewDiffSplitterComponent previewSplitter = new PreviewDiffSplitterComponent(changeProcessor, ChangesViewManager.CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION);
            previewSplitter.setFirstComponent((JComponent)this.myContentPanel);
            previewSplitter.setPreviewVisible(this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
            this.myView.addSelectionListener(() -> {
                boolean fromModelRefresh = this.myModelUpdateInProgress;
                this.invokeLater(() -> previewSplitter.updatePreview(fromModelRefresh));
            }, (Disposable)changeProcessor);
            this.myMainPanel.addToCenter((Component)((Object)previewSplitter));
            Disposer.register((Disposable)changeProcessor, () -> {
                this.myMainPanel.remove((Component)((Object)previewSplitter));
                this.myMainPanel.addToCenter((Component)this.myContentPanel);
                this.myMainPanel.revalidate();
                this.myMainPanel.repaint();
            });
            PreviewDiffSplitterComponent previewDiffSplitterComponent = previewSplitter;
            if (previewDiffSplitterComponent == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(5);
            }
            return previewDiffSplitterComponent;
        }

        private boolean isSplitterPreview() {
            return this.myDiffPreview instanceof PreviewDiffSplitterComponent;
        }

        private boolean isEditorPreviewAllowed() {
            return !isOpenEditorDiffPreviewWithSingleClick.asBoolean() || this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        }

        private void openEditorPreview() {
            if (this.isSplitterPreview()) {
                return;
            }
            if (!this.isEditorPreviewAllowed()) {
                return;
            }
            ((EditorTabPreview)this.myDiffPreview).openPreview(false);
        }

        private void closeEditorPreview(boolean onlyIfEmpty) {
            if (this.isSplitterPreview()) {
                return;
            }
            EditorTabPreview editorPreview = (EditorTabPreview)this.myDiffPreview;
            if (onlyIfEmpty && editorPreview.hasContent()) {
                return;
            }
            editorPreview.closePreview();
        }

        @Nullable
        public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
            return this.myCommitWorkflowHandler;
        }

        public void updateCommitWorkflow(boolean isNonModal) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myDisposed) {
                return;
            }
            if (isNonModal) {
                if (this.myCommitPanel == null) {
                    this.myCommitPanel = new ChangesViewCommitPanel(this.myChangesPanel, (JComponent)((Object)this));
                    this.myCommitWorkflowHandler = new ChangesViewCommitWorkflowHandler(new ChangesViewCommitWorkflow(this.myProject), this.myCommitPanel);
                    Disposer.register((Disposable)this, (Disposable)this.myCommitPanel);
                    this.myCommitPanelSplitter.setSecondComponent((JComponent)((Object)this.myCommitPanel));
                    this.myCommitWorkflowHandler.addActivityListener(() -> this.configureDiffPreview(), this.myCommitWorkflowHandler);
                }
            } else if (this.myCommitPanel != null) {
                this.myCommitPanelSplitter.setSecondComponent(null);
                Disposer.dispose((Disposable)this.myCommitPanel);
                this.myCommitPanel = null;
                this.myCommitWorkflowHandler = null;
            }
            this.configureDiffPreview();
            this.configureToolbars();
        }

        public boolean isAllowExcludeFromCommit() {
            return this.myCommitWorkflowHandler != null && this.myCommitWorkflowHandler.isActive();
        }

        private void configureDiffPreview() {
            this.myChangeProcessor.setAllowExcludeFromCommit(this.isAllowExcludeFromCommit());
        }

        private void configureToolbars() {
            boolean isToolbarHorizontal = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode().useCommitToolWindow() && isToolbarHorizontalSetting.asBoolean();
            this.myChangesPanel.setToolbarHorizontal(isToolbarHorizontal);
            if (this.myCommitPanel != null) {
                this.myCommitPanel.setToolbarHorizontal(isToolbarHorizontal);
            }
        }

        private void setCommitSplitOrientation() {
            boolean hasPreviewPanel = this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN && this.isSplitterPreview();
            ToolWindow tw = ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes");
            if (tw != null) {
                boolean toolwindowIsHorizontal = tw.getAnchor().isHorizontal();
                this.myCommitPanelSplitter.setOrientation(hasPreviewPanel || !toolwindowIsHorizontal);
            }
        }

        @NotNull
        private Function<ChangeNodeDecorator, ChangeNodeDecorator> getChangeDecoratorProvider() {
            Function<ChangeNodeDecorator, ChangeNodeDecorator> function = baseDecorator -> new PartialCommitChangeNodeDecorator(this.myProject, (ChangeNodeDecorator)baseDecorator, (Function0<Boolean>)((Function0)() -> this.isAllowExcludeFromCommit()));
            if (function == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(6);
            }
            return function;
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            List<AnAction> list = Arrays.asList(this.myChangesPanel.getToolbarActionGroup().getChildren(null));
            if (list == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object data;
            if (dataId == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(8);
            }
            if ((data = super.getData(dataId)) != null) {
                return data;
            }
            return this.myCommitPanel != null ? this.myCommitPanel.getDataFromProviders(dataId) : null;
        }

        private static void registerShortcuts(@NotNull JComponent component) {
            if (component == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(9);
            }
            EmptyAction.registerWithShortcutSet((String)"ChangesView.Refresh", (ShortcutSet)CommonShortcuts.getRerun(), (JComponent)component);
            EmptyAction.registerWithShortcutSet((String)"ChangesView.NewChangeList", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)component);
            EmptyAction.registerWithShortcutSet((String)"ChangesView.RemoveChangeList", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)component);
            EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)component);
        }

        @NotNull
        private List<AnAction> createChangesToolbarActions(@NotNull TreeExpander treeExpander) {
            if (treeExpander == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(10);
            }
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            actions.add(CustomActionsSchema.getInstance().getCorrectedAction("ChangesViewToolbar"));
            actions.add((AnAction)Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
            DefaultActionGroup viewOptionsGroup = DefaultActionGroup.createPopupGroup(() -> VcsBundle.message((String)"action.ChangesViewToolWindowPanel.text", (Object[])new Object[0]));
            viewOptionsGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
            viewOptionsGroup.add((AnAction)new ToggleShowIgnoredAction());
            viewOptionsGroup.add(ActionManager.getInstance().getAction("ChangesView.ViewOptions"));
            actions.add((AnAction)viewOptionsGroup);
            actions.add(CommonActionsManager.getInstance().createExpandAllHeaderAction(treeExpander, (JComponent)((Object)this.myView)));
            actions.add(CommonActionsManager.getInstance().createCollapseAllAction(treeExpander, (JComponent)((Object)this.myView)));
            actions.add((AnAction)Separator.getInstance());
            actions.add((AnAction)new ToggleDetailsAction());
            ArrayList<AnAction> arrayList = actions;
            if (arrayList == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private void updateProgressComponent(@Nullable Factory<? extends JComponent> progress) {
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                JComponent component = progress != null ? (JComponent)progress.create() : null;
                this.myProgressLabel.setContent(component);
                this.myProgressLabel.setMinimumSize((Dimension)JBUI.emptySize());
            });
        }

        public void updateProgressText(@NlsContexts.Label String text2, boolean isError) {
            this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text2, isError));
        }

        public void setBusy(boolean b) {
            this.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
        }

        public void scheduleRefresh() {
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                this.myTreeUpdateAlarm.cancelAllRequests();
                this.myTreeUpdateAlarm.addRequest(() -> this.refreshView(), 100);
            });
        }

        public void refreshImmediately() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myTreeUpdateAlarm.cancelAllRequests();
            this.refreshView(false);
        }

        private void refreshView() {
            this.refreshView(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshView(boolean canBeCancelled) {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            Object object = this.myTreeUpdateIndicatorLock;
            synchronized (object) {
                this.myTreeUpdateIndicator.cancel();
                this.myTreeUpdateIndicator = indicator;
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> this.lambda$refreshView$17(canBeCancelled, (ProgressIndicator)indicator), (ProgressIndicator)(canBeCancelled ? indicator : null));
        }

        public void setGrouping(@NotNull String groupingKey) {
            if (groupingKey == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(12);
            }
            this.myView.getGroupingSupport().setGroupingKeysOrSkip(ContainerUtil.set((Object[])new String[]{groupingKey}));
        }

        public void selectFile(@Nullable VirtualFile vFile) {
            if (vFile == null) {
                return;
            }
            Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
            Change objectToFind = change != null ? change : vFile;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
            DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
            if (node != null) {
                TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
            }
        }

        public void selectChanges(@NotNull List<? extends Change> changes) {
            if (changes == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(13);
            }
            ArrayList paths = new ArrayList();
            for (Change change : changes) {
                ContainerUtil.addIfNotNull(paths, (Object)this.myView.findNodePathInTree(change));
            }
            TreeUtil.selectPaths((JTree)((Object)this.myView), paths);
        }

        public void refreshChangesViewNodeAsync(@NotNull VirtualFile file) {
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(14);
            }
            this.invokeLater(() -> this.refreshChangesViewNode(file));
        }

        private void refreshChangesViewNode(@NotNull VirtualFile file) {
            DefaultMutableTreeNode root;
            DefaultMutableTreeNode node;
            ChangeListManager changeListManager;
            VirtualFile userObject;
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(15);
            }
            Object object = userObject = (changeListManager = ChangeListManager.getInstance((Project)this.myProject)).isUnversioned(file) ? file : changeListManager.getChange(file);
            if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)this.myView.getModel().getRoot()), (Object)userObject)) != null) {
                this.myView.getModel().nodeChanged(node);
            }
        }

        private void invokeLater(Runnable runnable) {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, this.myProject.getDisposed());
        }

        private void invokeLaterIfNeeded(Runnable runnable) {
            GuiUtils.invokeLaterIfNeeded((Runnable)runnable, (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
        }

        private /* synthetic */ void lambda$refreshView$17(boolean canBeCancelled, ProgressIndicator indicator) {
            if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
            List changeLists = changeListManager.getChangeListsCopy();
            List<FilePath> unversionedFiles = changeListManager.getUnversionedFilesPaths();
            TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.getGrouping()).setChangeLists(changeLists, Registry.is((String)"vcs.skip.single.default.changelist"), this.getChangeDecoratorProvider()).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(unversionedFiles);
            if (this.myChangesViewManager.myState.myShowIgnored) {
                treeModelBuilder.setIgnored(changeListManager.getIgnoredFilePaths(), changeListManager.isIgnoredInUpdateMode());
            }
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                if (canBeCancelled) {
                    indicator.checkCanceled();
                }
                for (ChangesViewModifier extension : ChangesViewModifier.KEY.getExtensions((AreaInstance)this.myProject)) {
                    extension.modifyTreeModelBuilder(treeModelBuilder);
                }
                DefaultTreeModel newModel = treeModelBuilder.build();
                this.myModelUpdateInProgress = true;
                try {
                    this.myView.updateModel(newModel);
                    if (this.myCommitWorkflowHandler != null) {
                        this.myCommitWorkflowHandler.synchronizeInclusion(changeLists, unversionedFiles);
                    }
                }
                finally {
                    this.myModelUpdateInProgress = false;
                }
                this.myDiffPreview.updatePreview(true);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesViewManager";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeProcessor";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeExpander";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupingKey";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installEditorPreview";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installSplitterPreview";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeDecoratorProvider";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangesToolbarActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "installEditorPreview";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "installSplitterPreview";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "registerShortcuts";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangesToolbarActions";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setGrouping";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChanges";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshChangesViewNodeAsync";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshChangesViewNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class ToggleDetailsAction
        extends ShowDiffPreviewAction {
            private ToggleDetailsAction() {
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ToggleDetailsAction.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(ChangesViewToolWindowPanel.this.isSplitterPreview() || isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    ToggleDetailsAction.$$$reportNull$$$0(1);
                }
                ChangesViewToolWindowPanel.this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = state;
                ChangesViewToolWindowPanel.this.myDiffPreview.setPreviewVisible(state);
                ChangesViewToolWindowPanel.this.setCommitSplitOrientation();
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    ToggleDetailsAction.$$$reportNull$$$0(2);
                }
                return ChangesViewToolWindowPanel.this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ToggleDetailsAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class ToggleShowIgnoredAction
        extends ToggleAction
        implements DumbAware {
            ToggleShowIgnoredAction() {
                super(VcsBundle.messagePointer((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(0);
                }
                return ChangesViewToolWindowPanel.this.myChangesViewManager.myState.myShowIgnored;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(1);
                }
                ChangesViewToolWindowPanel.this.myChangesViewManager.myState.myShowIgnored = state;
                ChangesViewToolWindowPanel.this.refreshView();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ToggleShowIgnoredAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class MyChangeListListener
        extends ChangeListAdapter {
            private MyChangeListListener() {
            }

            public void changeListsChanged() {
                ChangesViewToolWindowPanel.this.scheduleRefresh();
            }

            public void changeListUpdateDone() {
                ChangesViewToolWindowPanel.this.setBusy(false);
                ChangesViewToolWindowPanel.this.scheduleRefresh();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewToolWindowPanel.this.myProject);
                VcsException updateException = changeListManager.getUpdateException();
                if (updateException == null) {
                    ChangesViewToolWindowPanel.this.updateProgressComponent(changeListManager.getAdditionalUpdateInfo());
                } else {
                    ChangesViewToolWindowPanel.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
                }
            }
        }
    }

    public static class State {
        @Deprecated
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @XCollection
        public Set<String> groupingKeys = new HashSet<String>();
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project) {
            if (project == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void initTabContent(@NotNull Content content2) {
            if (content2 == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            ChangesViewManager viewManager = (ChangesViewManager)ChangesViewManager.getInstance(this.myProject);
            ChangesViewToolWindowPanel panel2 = viewManager.initToolWindowPanel();
            content2.setHelpId("ideaInterface.changes");
            content2.setComponent((JComponent)((Object)panel2));
            content2.setPreferredFocusableComponent((JComponent)((Object)panel2.myView));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @NotNull
        private final Project myProject;

        public DisplayNameSupplier(@NotNull Project project) {
            if (project == null) {
                DisplayNameSupplier.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public String get() {
            return ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject) ? VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]) : VcsBundle.message((String)"local.changes.tab", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager$DisplayNameSupplier", "<init>"));
        }
    }

    public static class ContentPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project) {
            if (!ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
                Boolean bl = false;
                if (bl == null) {
                    ContentPredicate.$$$reportNull$$$0(0);
                }
                return bl;
            }
            if (CommitModeManager.getInstance(project).getCurrentCommitMode().hideLocalChangesTab()) {
                Boolean bl = false;
                if (bl == null) {
                    ContentPredicate.$$$reportNull$$$0(1);
                }
                return bl;
            }
            Boolean bl = true;
            if (bl == null) {
                ContentPredicate.$$$reportNull$$$0(2);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentPredicate", "fun"));
        }
    }

    public static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        public ContentPreloader(@NotNull Project project) {
            if (project == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void preloadTabContent(@NotNull Content content2) {
            if (content2 == null) {
                ContentPreloader.$$$reportNull$$$0(1);
            }
            content2.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyContentDnDTarget(this.myProject, content2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentPreloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preloadTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

