/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.util.text.UniqueNameGenerator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a8\u0010\u000f\u001a\u00130\u0001\u00a2\u0006\u000e\b\u0004\u0012\n\b\u0010\u0012\u0006\b\n0\u00118\u00122\u0017\u0010\u0013\u001a\u00130\u0001\u00a2\u0006\u000e\b\u0004\u0012\n\b\u0010\u0012\u0006\b\n0\u00118\u00122\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d\u001a&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0002\u001a\f0\u0001\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"CHANGELIST_NAME_PATTERN", "", "STASH_MESSAGE_PATTERN", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getSTASH_MESSAGE_PATTERN", "()Ljava/lang/String;", "SYSTEM_CHANGELIST_REGEX", "Lkotlin/text/Regex;", "getSYSTEM_CHANGELIST_REGEX", "()Lkotlin/text/Regex;", "createNameForChangeList", "project", "Lcom/intellij/openapi/project/Project;", "commitMessage", "createSystemShelvedChangeListName", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "systemPrefix", "changelistName", "getChangeListNameForUnshelve", "shelvedList", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "getOriginalName", "shelvedName", "getPredefinedChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "onChangeListAvailabilityChanged", "", "disposable", "Lcom/intellij/openapi/Disposable;", "executeNow", "", "callback", "Ljava/lang/Runnable;", "intellij.platform.vcs.impl"})
@JvmName(name="ChangeListUtil")
public final class ChangeListUtil {
    private static final String CHANGELIST_NAME_PATTERN = "\\s\\[(.*)\\]";

    private static final String getSTASH_MESSAGE_PATTERN() {
        String string = VcsBundle.message((String)"stash.changes.message", (Object[])new Object[]{".*"});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"stash.changes.message\", \".*\")");
        return string;
    }

    private static final Regex getSYSTEM_CHANGELIST_REGEX() {
        String string = ChangeListUtil.getSTASH_MESSAGE_PATTERN() + CHANGELIST_NAME_PATTERN;
        boolean bl = false;
        return new Regex(string);
    }

    @NotNull
    public static final String createSystemShelvedChangeListName(@NotNull String systemPrefix, @NotNull String changelistName) {
        Intrinsics.checkNotNullParameter((Object)systemPrefix, (String)"systemPrefix");
        Intrinsics.checkNotNullParameter((Object)changelistName, (String)"changelistName");
        return systemPrefix + " [" + changelistName + ']';
    }

    private static final String getOriginalName(String shelvedName) {
        Object object = ChangeListUtil.getSYSTEM_CHANGELIST_REGEX().matchEntire((CharSequence)shelvedName);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            object = shelvedName;
        }
        return object;
    }

    @Nullable
    public static final LocalChangeList getPredefinedChangeList(@NotNull ShelvedChangeList shelvedList, @NotNull ChangeListManager changeListManager) {
        Intrinsics.checkNotNullParameter((Object)shelvedList, (String)"shelvedList");
        Intrinsics.checkNotNullParameter((Object)changeListManager, (String)"changeListManager");
        String defaultName = shelvedList.DESCRIPTION;
        LocalChangeList localChangeList = changeListManager.findChangeList(defaultName);
        if (localChangeList == null) {
            if (shelvedList.isMarkedToDelete()) {
                String string = defaultName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultName");
                localChangeList = changeListManager.findChangeList(ChangeListUtil.getOriginalName(string));
            } else {
                localChangeList = null;
            }
        }
        return localChangeList;
    }

    @NotNull
    public static final String getChangeListNameForUnshelve(@NotNull ShelvedChangeList shelvedList) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shelvedList, (String)"shelvedList");
        String defaultName = shelvedList.DESCRIPTION;
        if (shelvedList.isMarkedToDelete()) {
            String string2 = defaultName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultName");
            string = ChangeListUtil.getOriginalName(string2);
        } else {
            String string3 = defaultName;
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"defaultName");
        }
        return string;
    }

    @NotNull
    public static final String createNameForChangeList(@NotNull Project project, @NotNull String commitMessage2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessage2, (String)"commitMessage");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        CharSequence charSequence = commitMessage2;
        boolean bl = false;
        charSequence = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)charSequence)).toString(), (char)'\n', null, (int)2, null);
        bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = "[ ]{2,}";
        boolean bl2 = false;
        string2 = new Regex(string2);
        String string3 = " ";
        boolean bl3 = false;
        String proposedName = string2.replace(charSequence, string3);
        String string4 = UniqueNameGenerator.generateUniqueName((String)proposedName, (String)"", (String)"", (String)"-", (String)"", (Condition)((Condition)new Condition<String>(changeListManager2){
            final /* synthetic */ ChangeListManager $changeListManager;

            public final boolean value(String it) {
                return this.$changeListManager.findChangeList(it) == null;
            }
            {
                this.$changeListManager = changeListManager;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"UniqueNameGenerator.gene\u2026ChangeList(it) == null })");
        return string4;
    }

    public static final void onChangeListAvailabilityChanged(@NotNull Project project, @NotNull Disposable disposable, boolean executeNow, @NotNull Runnable callback2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        project.getMessageBus().connect(disposable).subscribe(ChangeListListener.TOPIC, (Object)new ChangeListListener(callback2){
            final /* synthetic */ Runnable $callback;

            public void changeListAvailabilityChanged() {
                this.$callback.run();
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
        if (executeNow) {
            callback2.run();
        }
    }
}

