/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends DumbAwareAction
implements UpdateInBackground {
    private static final int MANY_CHANGES_THRESHOLD = 1000;

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(0);
        }
        boolean isVisible2 = (project = e.getProject()) != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        e.getPresentation().setEnabled(this.isEnabled(e.getDataContext()));
        e.getPresentation().setVisible(isVisible2);
    }

    protected boolean isEnabled(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        List selectedFiles = VcsContextUtil.selectedFilePathsIterable(context).take(1000).toList();
        if (selectedFiles.isEmpty()) {
            return false;
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, selectedFiles)) {
            return ContainerUtil.all((Collection)selectedFiles, path2 -> AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)path2));
        }
        if (selectedFiles.size() == 1) {
            FilePath selectedPath = (FilePath)ContainerUtil.getFirstItem((List)selectedFiles);
            if (selectedPath == null) {
                return false;
            }
            VirtualFile fileOrParent = TabbedShowHistoryAction.getExistingFileOrParent(selectedPath);
            if (fileOrParent == null) {
                return false;
            }
            if (TabbedShowHistoryAction.canShowOldFileHistory(project, selectedPath, fileOrParent)) {
                return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)selectedPath);
            }
        }
        return false;
    }

    private static boolean canShowOldFileHistory(@NotNull Project project, @NotNull FilePath path2, @NotNull VirtualFile fileOrParent) {
        AbstractVcs vcs;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(3);
        }
        if (fileOrParent == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(4);
        }
        if ((vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project)) == null) {
            return false;
        }
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path2.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        VcsLogFileHistoryProvider historyProvider;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(5);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(6);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)ApplicationManager.getApplication().getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(project, paths, null);
    }

    @Nullable
    private static VirtualFile getExistingFileOrParent(@NotNull FilePath selectedPath) {
        if (selectedPath == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(7);
        }
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)selectedPath.getVirtualFile(), (Object)selectedPath.getVirtualFileParent());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<FilePath> selectedFiles;
        Project project;
        if (e == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(8);
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project = Objects.requireNonNull(e.getProject()), selectedFiles = VcsContextUtil.selectedFilePaths(e.getDataContext()))) {
            TabbedShowHistoryAction.showNewFileHistory(project, selectedFiles);
        } else if (selectedFiles.size() == 1) {
            FilePath path2 = Objects.requireNonNull((FilePath)ContainerUtil.getFirstItem(selectedFiles));
            AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile((VirtualFile)Objects.requireNonNull(TabbedShowHistoryAction.getExistingFileOrParent(path2)), (Project)project));
            TabbedShowHistoryAction.showOldFileHistory(project, vcs, path2);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(9);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(10);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ApplicationManager.getApplication().getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, paths, null);
    }

    private static void showOldFileHistory(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull FilePath path2) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(11);
        }
        if (vcs == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(12);
        }
        if (path2 == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(13);
        }
        VcsHistoryProvider provider = Objects.requireNonNull(vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(provider, vcs.getAnnotationProvider(), path2, vcs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrParent";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowOldFileHistory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowNewFileHistory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getExistingFileOrParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showNewFileHistory";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showOldFileHistory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

