/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedBlockHistoryAction
extends DumbAwareAction {
    private static boolean isEnabled(@Nullable Project project, @Nullable VcsSelection selection) {
        if (project == null || selection == null) {
            return false;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        if (file == null) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (activeVcs == null) {
            return false;
        }
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        if (provider == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(0);
        }
        Project project = event.getProject();
        assert (project != null);
        VcsSelection selection = VcsSelectionUtil.getSelection((DataContext)event.getDataContext());
        assert (selection != null);
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        assert (file != null);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        assert (activeVcs != null);
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        assert (provider != null);
        int selectionStart = selection.getSelectionStartLineNumber();
        int selectionEnd = selection.getSelectionEndLineNumber();
        VcsSelectionHistoryDialog dialog = new VcsSelectionHistoryDialog(project, file, selection.getDocument(), provider, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle());
        dialog.show();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        VcsSelection selection = VcsSelectionUtil.getSelection((DataContext)event.getDataContext());
        presentation.setEnabled(SelectedBlockHistoryAction.isEnabled(project, selection));
        if (selection != null) {
            presentation.setText(selection.getActionName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

