/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShowDiffAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(0);
        }
        AbstractShowDiffAction.updateDiffAction(e.getPresentation(), e.getDataContext());
    }

    protected static void updateDiffAction(@NotNull Presentation presentation, @NotNull DataContext context) {
        if (presentation == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(2);
        }
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(context, true));
        presentation.setVisible(AbstractShowDiffAction.isVisible(context));
    }

    protected static boolean isVisible(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(3);
        }
        return (project = (Project)context.getData(CommonDataKeys.PROJECT)) != null && AbstractShowDiffAction.hasDiffProviders(project);
    }

    private static boolean hasDiffProviders(@NotNull Project project) {
        if (project == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(4);
        }
        return Stream.of(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()).map(AbstractVcs::getDiffProvider).anyMatch(Objects::nonNull);
    }

    protected static boolean isEnabled(@NotNull DataContext context, boolean disableIfRunning) {
        Project project;
        if (context == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(5);
        }
        if ((project = (Project)context.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        if (!AbstractShowDiffAction.isVisible(context)) {
            return false;
        }
        VirtualFile file = (VirtualFile)VcsContextUtil.selectedFilesIterable(context).single();
        if (file == null || file.isDirectory()) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        if (disableIfRunning && BackgroundableActionLock.isLocked(project, new Object[]{VcsBackgroundableActions.COMPARE_WITH, filePath})) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project);
        if (vcs == null || vcs.getDiffProvider() == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AbstractShowDiffAction.$$$reportNull$$$0(6);
        }
        if (ChangeListManager.getInstance((Project)(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).isFreezedWithNotification(null)) {
            return;
        }
        VirtualFile file = Objects.requireNonNull(VcsContextUtil.selectedFile(e.getDataContext()));
        AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project));
        DiffProvider provider = Objects.requireNonNull(vcs.getDiffProvider());
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        this.getExecutor(provider, file, project, editor).showDiff();
    }

    @NotNull
    protected abstract DiffActionExecutor getExecutor(@NotNull DiffProvider var1, @NotNull VirtualFile var2, @NotNull Project var3, @Nullable Editor var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AbstractShowDiffAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDiffAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDiffProviders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

