/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ExternallyAddedFilesProcessorImpl;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.ignore.IgnoreFilesProcessorImpl;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsVFSListener
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VcsVFSListener.class);
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsIgnoreManager myVcsIgnoreManager;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    protected final Project myProject;
    protected final AbstractVcs myVcs;
    protected final ChangeListManager myChangeListManager;
    private final VcsShowConfirmationOption myAddOption;
    protected final VcsShowConfirmationOption myRemoveOption;
    protected final StateProcessor myProcessor;
    private final ProjectConfigurationFilesProcessorImpl myProjectConfigurationFilesProcessor;
    protected final ExternallyAddedFilesProcessorImpl myExternalFilesProcessor;
    private final List<VFileEvent> myEventsToProcess;

    protected VcsVFSListener(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsVFSListener.$$$reportNull$$$0(0);
        }
        this.myProcessor = new StateProcessor();
        this.myEventsToProcess = new SmartList();
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myVcsIgnoreManager = VcsIgnoreManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myAddOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
        this.myProjectConfigurationFilesProcessor = this.createProjectConfigurationFilesProcessor();
        this.myExternalFilesProcessor = this.createExternalFilesProcessor();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected VcsVFSListener(@NotNull Project project, @NotNull AbstractVcs vcs) {
        if (project == null) {
            VcsVFSListener.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            VcsVFSListener.$$$reportNull$$$0(2);
        }
        this(vcs);
        this.installListeners();
    }

    protected void installListeners() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new MyAsyncVfsListener(), (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)new MyCommandAdapter());
        this.myProjectConfigurationFilesProcessor.install();
        this.myExternalFilesProcessor.install();
        new IgnoreFilesProcessorImpl(this.myProject, this.myVcs, this).install();
    }

    public void dispose() {
    }

    protected boolean isEventAccepted(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(3);
        }
        return !event.isFromRefresh() && event.getFileSystem() instanceof LocalFileSystem;
    }

    protected boolean isEventIgnored(@NotNull VFileEvent event) {
        FilePath filePath;
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(4);
        }
        return !this.isUnderMyVcs(filePath = VcsUtil.getFilePath((String)event.getPath())) || this.myChangeListManager.isIgnoredFile(filePath);
    }

    protected boolean isUnderMyVcs(@Nullable VirtualFile file) {
        return file != null && (Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && this.myVcsManager.getVcsFor(file) == this.myVcs) != false;
    }

    protected boolean isUnderMyVcs(@Nullable FilePath filePath) {
        return filePath != null && (Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && this.myVcsManager.getVcsFor(filePath) == this.myVcs) != false;
    }

    private boolean allowedDeletion(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(5);
        }
        if (this.myVcsFileListenerContextHelper.isDeletionContextEmpty()) {
            return true;
        }
        return !this.myVcsFileListenerContextHelper.isDeletionIgnored(VcsUtil.getFilePath((String)event.getPath()));
    }

    private boolean allowedAddition(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(6);
        }
        if (this.myVcsFileListenerContextHelper.isAdditionContextEmpty()) {
            return true;
        }
        return !this.myVcsFileListenerContextHelper.isAdditionIgnored(event.getFile());
    }

    @RequiresBackgroundThread
    protected void executeAdd() {
        Map<VirtualFile, VirtualFile> copyFromMap;
        List<VirtualFile> addedFiles = this.myProcessor.acquireAddedFiles();
        LOG.debug("executeAdd. addedFiles: ", new Object[]{addedFiles});
        addedFiles.removeIf(arg_0 -> ((VcsIgnoreManager)this.myVcsIgnoreManager).isPotentiallyIgnoredFile(arg_0));
        Map<VirtualFile, VirtualFile> map2 = copyFromMap = this.isFileCopyingFromTrackingSupported() ? this.myProcessor.acquireCopiedFiles() : Collections.emptyMap();
        if (!addedFiles.isEmpty()) {
            this.executeAdd(addedFiles, copyFromMap);
        }
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(7);
        }
        if (copyFromMap == null) {
            VcsVFSListener.$$$reportNull$$$0(8);
        }
        VcsShowConfirmationOption.Value addOption = this.myAddOption.getValue();
        LOG.debug("executeAdd. add-option: ", new Object[]{addOption, ", files to add: ", addedFiles});
        if (addOption == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        addedFiles = this.myProjectConfigurationFilesProcessor.filterNotProjectConfigurationFiles(addedFiles);
        if (addOption == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(addedFiles, copyFromMap);
        } else {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            Collection filesToProcess = helper.selectFilesToProcess(addedFiles, this.getAddTitle(), null, this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), this.myAddOption);
            if (filesToProcess != null) {
                this.performAdding(new ArrayList<VirtualFile>(filesToProcess), copyFromMap);
            }
        }
    }

    protected void executeAddWithoutIgnores(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap, @NotNull ExecuteAddCallback executeAddCallback) {
        if (addedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(9);
        }
        if (copyFromMap == null) {
            VcsVFSListener.$$$reportNull$$$0(10);
        }
        if (executeAddCallback == null) {
            VcsVFSListener.$$$reportNull$$$0(11);
        }
        executeAddCallback.executeAdd(addedFiles, copyFromMap);
    }

    @RequiresBackgroundThread
    private void executeMoveRename() {
        List<MovedFileInfo> movedFiles = this.myProcessor.acquireMovedFiles();
        LOG.debug("executeMoveRename ", new Object[]{movedFiles});
        if (!movedFiles.isEmpty()) {
            this.performMoveRename(movedFiles);
        }
    }

    @RequiresBackgroundThread
    protected void executeDelete() {
        AllDeletedFiles allFiles = this.myProcessor.acquireAllDeletedFiles();
        List<FilePath> filesToDelete = allFiles.deletedWithoutConfirmFiles;
        List<FilePath> deletedFiles = allFiles.deletedFiles;
        filesToDelete.removeIf(arg_0 -> ((VcsIgnoreManager)this.myVcsIgnoreManager).isPotentiallyIgnoredFile(arg_0));
        deletedFiles.removeIf(arg_0 -> ((VcsIgnoreManager)this.myVcsIgnoreManager).isPotentiallyIgnoredFile(arg_0));
        VcsShowConfirmationOption.Value removeOption = this.myRemoveOption.getValue();
        if (removeOption == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToDelete.addAll(deletedFiles);
        } else if (removeOption == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && !deletedFiles.isEmpty()) {
            Collection<FilePath> filePaths = this.selectFilePathsToDelete(deletedFiles);
            filesToDelete.addAll(filePaths);
        }
        if (!filesToDelete.isEmpty()) {
            this.performDeletion(filesToDelete);
        }
    }

    protected void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(12);
        }
        if (newParentPath == null) {
            VcsVFSListener.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            VcsVFSListener.$$$reportNull$$$0(14);
        }
        this.myProcessor.processMovedFile(file, newParentPath, newName);
    }

    protected void saveUnsavedVcsIgnoreFiles() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Set ignoreFileNames = VcsUtil.getVcsIgnoreFileNames((Project)this.myProject);
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file == null || !ignoreFileNames.contains(file.getName())) continue;
            ApplicationManager.getApplication().invokeAndWait(() -> fileDocumentManager.saveDocument(document));
        }
    }

    @NotNull
    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(15);
        }
        return this.selectFilesForOption(this.myRemoveOption, deletedFiles, this.getDeleteTitle(), this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate());
    }

    @NotNull
    protected Collection<FilePath> selectFilePathsToAdd(@NotNull List<FilePath> addFiles) {
        if (addFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(16);
        }
        return this.selectFilesForOption(this.myAddOption, addFiles, this.getAddTitle(), this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate());
    }

    @NotNull
    private Collection<FilePath> selectFilesForOption(@NotNull VcsShowConfirmationOption option2, @NotNull List<FilePath> files, @NlsContexts.DialogTitle String title2, @NlsContexts.DialogTitle String singleFileTitle, @NlsContexts.DialogMessage String singleFilePromptTemplate) {
        VcsShowConfirmationOption.Value optionValue;
        if (option2 == null) {
            VcsVFSListener.$$$reportNull$$$0(17);
        }
        if (files == null) {
            VcsVFSListener.$$$reportNull$$$0(18);
        }
        if ((optionValue = option2.getValue()) == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            List<FilePath> list = Collections.emptyList();
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (optionValue == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            List<FilePath> list = files;
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(20);
            }
            return list;
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
        Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)helper.selectFilePathsToProcess(files, title2, null, singleFileTitle, singleFilePromptTemplate, option2)));
        List<FilePath> selectedFilePaths = (List<FilePath>)ref.get();
        List<FilePath> list = selectedFilePaths != null ? selectedFilePaths : Collections.emptyList();
        if (list == null) {
            VcsVFSListener.$$$reportNull$$$0(21);
        }
        return list;
    }

    protected void beforeContentsChange(@NotNull VFileContentChangeEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(22);
        }
    }

    private void addFileToMove(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(23);
        }
        if (newParentPath == null) {
            VcsVFSListener.$$$reportNull$$$0(24);
        }
        if (newName == null) {
            VcsVFSListener.$$$reportNull$$$0(25);
        }
        if (file.isDirectory() && !file.is(VFileProperty.SYMLINK) && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile child : children) {
                    ProgressManager.checkCanceled();
                    this.addFileToMove(child, newParentPath + "/" + newName, child.getName());
                }
            }
        } else {
            this.processMovedFile(file, newParentPath, newName);
        }
    }

    protected boolean filterOutUnknownFiles() {
        return true;
    }

    protected boolean filterOutByStatus(@NotNull FileStatus status) {
        if (status == null) {
            VcsVFSListener.$$$reportNull$$$0(26);
        }
        return status == FileStatus.IGNORED || this.filterOutUnknownFiles() && status == FileStatus.UNKNOWN;
    }

    @NotNull
    protected VcsDeleteType needConfirmDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(27);
        }
        VcsDeleteType vcsDeleteType = VcsDeleteType.CONFIRM;
        if (vcsDeleteType == null) {
            VcsVFSListener.$$$reportNull$$$0(28);
        }
        return vcsDeleteType;
    }

    @NotNull
    @NlsContexts.DialogTitle
    protected abstract String getAddTitle();

    @NotNull
    @NlsContexts.DialogTitle
    protected abstract String getSingleFileAddTitle();

    @NotNull
    @NlsContexts.DialogMessage
    protected abstract String getSingleFileAddPromptTemplate();

    @NotNull
    @NlsContexts.DialogTitle
    protected abstract String getDeleteTitle();

    @NlsContexts.DialogTitle
    protected abstract String getSingleFileDeleteTitle();

    @NlsContexts.DialogMessage
    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performAdding(@NotNull Collection<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);

    protected abstract void performDeletion(@NotNull List<FilePath> var1);

    protected abstract void performMoveRename(@NotNull List<MovedFileInfo> var1);

    protected abstract boolean isDirectoryVersioningSupported();

    protected boolean isRecursiveDeleteSupported() {
        return false;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return true;
    }

    private ExternallyAddedFilesProcessorImpl createExternalFilesProcessor() {
        return new ExternallyAddedFilesProcessorImpl(this.myProject, this, this.myVcs, (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files -> {
            this.performAdding((Collection<VirtualFile>)files, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private ProjectConfigurationFilesProcessorImpl createProjectConfigurationFilesProcessor() {
        return new ProjectConfigurationFilesProcessorImpl(this.myProject, this, this.myVcs.getDisplayName(), (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files -> {
            this.performAdding((Collection<VirtualFile>)files, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeAddCallback";
                break;
            }
            case 12: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentPath";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsVFSListener";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFilesForOption";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "needConfirmDeletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEventAccepted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEventIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allowedDeletion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allowedAddition";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAddWithoutIgnores";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMovedFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToAdd";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectFilesForOption";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeContentsChange";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addFileToMove";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterOutByStatus";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "needConfirmDeletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCommandAdapter
    implements CommandListener {
        private MyCommandAdapter() {
        }

        public void commandFinished(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandAdapter.$$$reportNull$$$0(0);
            }
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            List events = ContainerUtil.filter(VcsVFSListener.this.myEventsToProcess, e -> !(e instanceof VFileCreateEvent) || VcsVFSListener.this.allowedAddition((VFileEvent)e));
            VcsVFSListener.this.myEventsToProcess.clear();
            if (events.isEmpty() && !VcsVFSListener.this.myProcessor.isAnythingToProcess()) {
                return;
            }
            this.processEventsInBackground(events);
        }

        private void processEventsInBackground(final List<VFileEvent> events) {
            new Task.Backgroundable(VcsVFSListener.this.myProject, VcsBundle.message((String)"progress.title.version.control.processing.changed.files", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.checkCanceled();
                    VcsVFSListener.this.myProcessor.process(events);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/VcsVFSListener$MyCommandAdapter$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyCommandAdapter", "commandFinished"));
        }
    }

    private class MyAsyncVfsListener
    implements AsyncFileListener {
        private MyAsyncVfsListener() {
        }

        private boolean isBeforeEvent(@NotNull VFileEvent event) {
            if (event == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(0);
            }
            return event instanceof VFileContentChangeEvent || event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent;
        }

        private boolean isAfterEvent(@NotNull VFileEvent event) {
            if (event == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(1);
            }
            return event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileMoveEvent;
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(2);
            }
            final ArrayList<VFileEvent> beforeEvents = new ArrayList<VFileEvent>();
            final ArrayList<VFileEvent> afterEvents = new ArrayList<VFileEvent>();
            for (VFileEvent vFileEvent : events) {
                ProgressManager.checkCanceled();
                if (vFileEvent instanceof VFileContentChangeEvent) {
                    VirtualFile file = Objects.requireNonNull(vFileEvent.getFile());
                    if (!VcsVFSListener.this.isUnderMyVcs(file)) continue;
                    beforeEvents.add(vFileEvent);
                    continue;
                }
                if (!VcsVFSListener.this.isEventAccepted(vFileEvent)) continue;
                if (this.isBeforeEvent(vFileEvent)) {
                    beforeEvents.add(vFileEvent);
                }
                if (!this.isAfterEvent(vFileEvent)) continue;
                afterEvents.add(vFileEvent);
            }
            return beforeEvents.isEmpty() && afterEvents.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    for (VFileEvent event : beforeEvents) {
                        if (event instanceof VFileContentChangeEvent) {
                            VcsVFSListener.this.beforeContentsChange((VFileContentChangeEvent)event);
                        }
                        if (VcsVFSListener.this.isEventIgnored(event)) continue;
                        if (event instanceof VFileDeleteEvent && VcsVFSListener.this.allowedDeletion(event)) {
                            VcsVFSListener.this.myProcessor.processDeletedFile(((VFileDeleteEvent)event).getFile());
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            VcsVFSListener.this.myProcessor.processBeforeFileMovement((VFileMoveEvent)event);
                            continue;
                        }
                        if (!(event instanceof VFilePropertyChangeEvent)) continue;
                        VcsVFSListener.this.myProcessor.processBeforePropertyChange((VFilePropertyChangeEvent)event);
                    }
                }

                public void afterVfsChange() {
                    VcsVFSListener.this.myEventsToProcess.addAll(afterEvents);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$MyAsyncVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBeforeEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAfterEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    protected static interface ExecuteAddCallback {
        public void executeAdd(@NotNull List<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);
    }

    protected final class StateProcessor {
        private final Set<VirtualFile> myAddedFiles = new SmartHashSet();
        private final Map<VirtualFile, VirtualFile> myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
        private final Set<FilePath> myDeletedFiles = new SmartHashSet();
        private final Set<FilePath> myDeletedWithoutConfirmFiles = new SmartHashSet();
        private final Set<MovedFileInfo> myMovedFiles = new SmartHashSet();
        private final List<VcsException> myExceptions = new SmartList();
        private final ReentrantReadWriteLock PROCESSING_LOCK = new ReentrantReadWriteLock();

        protected StateProcessor() {
        }

        public boolean addException(@NotNull VcsException exception) {
            if (exception == null) {
                StateProcessor.$$$reportNull$$$0(0);
            }
            return (Boolean)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myExceptions.add(exception));
        }

        @NotNull
        public List<VcsException> acquireExceptions() {
            return this.acquireListUnderLock(this.myExceptions);
        }

        @NotNull
        public List<VirtualFile> acquireAddedFiles() {
            return this.acquireListUnderLock(this.myAddedFiles);
        }

        @NotNull
        public List<MovedFileInfo> acquireMovedFiles() {
            return this.acquireListUnderLock(this.myMovedFiles);
        }

        @NotNull
        public AllDeletedFiles acquireAllDeletedFiles() {
            AllDeletedFiles allDeletedFiles = (AllDeletedFiles)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                ArrayList<FilePath> deletedWithoutConfirmFiles = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
                ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
                this.myDeletedWithoutConfirmFiles.clear();
                this.myDeletedFiles.clear();
                return new AllDeletedFiles(deletedFiles, deletedWithoutConfirmFiles);
            });
            if (allDeletedFiles == null) {
                StateProcessor.$$$reportNull$$$0(1);
            }
            return allDeletedFiles;
        }

        @NotNull
        private <T> List<T> acquireListUnderLock(@NotNull Collection<T> files) {
            if (files == null) {
                StateProcessor.$$$reportNull$$$0(2);
            }
            List list = (List)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                ArrayList copiedFiles = new ArrayList(files);
                files.clear();
                return copiedFiles;
            });
            if (list == null) {
                StateProcessor.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public Map<VirtualFile, VirtualFile> acquireCopiedFiles() {
            Map map2 = (Map)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
                this.myCopyFromMap.clear();
                return copyFromMap;
            });
            if (map2 == null) {
                StateProcessor.$$$reportNull$$$0(4);
            }
            return map2;
        }

        private void checkMovedAddedSourceBack() {
            if (this.myAddedFiles.isEmpty() || this.myMovedFiles.isEmpty()) {
                return;
            }
            HashMap<String, VirtualFile> addedPaths = new HashMap<String, VirtualFile>(this.myAddedFiles.size());
            for (VirtualFile file : this.myAddedFiles) {
                addedPaths.put(file.getPath(), file);
            }
            Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFile = iterator.next();
                VirtualFile oldAdded = (VirtualFile)addedPaths.get(movedFile.myOldPath);
                if (oldAdded == null) continue;
                iterator.remove();
                this.myAddedFiles.remove(oldAdded);
                this.myAddedFiles.add(movedFile.myFile);
                if (!VcsVFSListener.this.isFileCopyingFromTrackingSupported()) continue;
                this.myCopyFromMap.put(oldAdded, movedFile.myFile);
            }
        }

        private void doNotDeleteAddedCopiedOrMovedFiles() {
            if (this.myDeletedFiles.isEmpty() && this.myDeletedWithoutConfirmFiles.isEmpty()) {
                return;
            }
            HashSet<String> copiedAddedMoved = new HashSet<String>();
            for (VirtualFile file : this.myCopyFromMap.keySet()) {
                copiedAddedMoved.add(file.getPath());
            }
            for (VirtualFile file : this.myAddedFiles) {
                copiedAddedMoved.add(file.getPath());
            }
            for (MovedFileInfo movedFileInfo : this.myMovedFiles) {
                copiedAddedMoved.add(movedFileInfo.myNewPath);
            }
            this.myDeletedFiles.removeIf(path2 -> copiedAddedMoved.contains(path2.getPath()));
            this.myDeletedWithoutConfirmFiles.removeIf(path2 -> copiedAddedMoved.contains(path2.getPath()));
        }

        private boolean isAnythingToProcess() {
            return (Boolean)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.readLock(), () -> !this.myAddedFiles.isEmpty() || !this.myDeletedFiles.isEmpty() || !this.myDeletedWithoutConfirmFiles.isEmpty() || !this.myMovedFiles.isEmpty());
        }

        @RequiresBackgroundThread
        private void process(@NotNull List<VFileEvent> events) {
            if (events == null) {
                StateProcessor.$$$reportNull$$$0(5);
            }
            this.processEvents(events);
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                this.doNotDeleteAddedCopiedOrMovedFiles();
                this.checkMovedAddedSourceBack();
            });
            VcsVFSListener.this.executeAdd();
            VcsVFSListener.this.executeDelete();
            VcsVFSListener.this.executeMoveRename();
            List<VcsException> exceptions = this.acquireExceptions();
            if (!exceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)VcsVFSListener.this.myProject).showErrors(exceptions, VcsBundle.message((String)"vcs.tab.title.vcs.name.operations.errors", (Object[])new Object[]{VcsVFSListener.this.myVcs.getDisplayName()}));
            }
        }

        private void processFileCreated(@NotNull VFileCreateEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(6);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("fileCreated: ", new Object[]{event.getFile()});
            }
            if (VcsVFSListener.this.isDirectoryVersioningSupported() || !event.isDirectory()) {
                VirtualFile file = event.getFile();
                if (file == null) {
                    return;
                }
                LOG.debug("Adding [", new Object[]{file, "] to added files"});
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(file));
            }
        }

        private void processFileMoved(@NotNull VFileMoveEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(7);
            }
            VirtualFile file = event.getFile();
            VirtualFile oldParent = event.getOldParent();
            if (!VcsVFSListener.this.isUnderMyVcs(oldParent)) {
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(file));
            }
        }

        private void processFileCopied(@NotNull VFileCopyEvent event) {
            VirtualFile newFile;
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(8);
            }
            if ((newFile = event.getNewParent().findChild(event.getNewChildName())) == null || VcsVFSListener.this.myChangeListManager.isIgnoredFile(newFile)) {
                return;
            }
            VirtualFile originalFile = event.getFile();
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                if (VcsVFSListener.this.isFileCopyingFromTrackingSupported() && VcsVFSListener.this.isUnderMyVcs(originalFile)) {
                    this.myAddedFiles.add(newFile);
                    this.myCopyFromMap.put(newFile, originalFile);
                } else {
                    this.myAddedFiles.add(newFile);
                }
            });
        }

        private void processDeletedFile(@NotNull VirtualFile file) {
            if (file == null) {
                StateProcessor.$$$reportNull$$$0(9);
            }
            if (file.isDirectory() && file instanceof NewVirtualFile && !VcsVFSListener.this.isDirectoryVersioningSupported() && !VcsVFSListener.this.isRecursiveDeleteSupported()) {
                for (VirtualFile child : ((NewVirtualFile)file).getCachedChildren()) {
                    ProgressManager.checkCanceled();
                    FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(child);
                    if (VcsVFSListener.this.filterOutByStatus(status)) continue;
                    this.processDeletedFile(child);
                }
            } else {
                VcsDeleteType type = VcsVFSListener.this.needConfirmDeletion(file);
                if (type == VcsDeleteType.IGNORE) {
                    return;
                }
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(filePath);
                if (VcsVFSListener.this.filterOutByStatus(status)) {
                    return;
                }
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                    if (type == VcsDeleteType.CONFIRM) {
                        this.myDeletedFiles.add(filePath);
                    } else if (type == VcsDeleteType.SILENT) {
                        this.myDeletedWithoutConfirmFiles.add(filePath);
                    }
                });
            }
        }

        private void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
            if (file == null) {
                StateProcessor.$$$reportNull$$$0(10);
            }
            if (newParentPath == null) {
                StateProcessor.$$$reportNull$$$0(11);
            }
            if (newName == null) {
                StateProcessor.$$$reportNull$$$0(12);
            }
            FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(file);
            LOG.debug("Checking moved file ", new Object[]{file, "; status=", status});
            String newPath = newParentPath + "/" + newName;
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                if (!VcsVFSListener.this.filterOutByStatus(status)) {
                    MovedFileInfo existingMovedFile = (MovedFileInfo)ContainerUtil.find(this.myMovedFiles, info -> Comparing.equal((Object)info.myFile, (Object)file));
                    if (existingMovedFile != null) {
                        LOG.debug("Reusing existing moved file [" + file + "] with new path [" + newPath + "]");
                        existingMovedFile.myNewPath = newPath;
                    } else {
                        LOG.debug("Registered moved file ", new Object[]{file});
                        this.myMovedFiles.add(new MovedFileInfo(file, newPath));
                    }
                } else {
                    this.myDeletedFiles.remove(VcsUtil.getFilePath((String)newPath));
                }
            });
        }

        private void processBeforeFileMovement(@NotNull VFileMoveEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(13);
            }
            VirtualFile file = event.getFile();
            if (VcsVFSListener.this.isUnderMyVcs(event.getNewParent())) {
                LOG.debug("beforeFileMovement ", new Object[]{event, " into same vcs"});
                VcsVFSListener.this.addFileToMove(file, event.getNewParent().getPath(), file.getName());
            } else {
                LOG.debug("beforeFileMovement ", new Object[]{event, " into different vcs"});
                VcsVFSListener.this.myProcessor.processDeletedFile(file);
            }
        }

        private void processBeforePropertyChange(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(14);
            }
            if (event.isRename()) {
                LOG.debug("before file rename ", new Object[]{event});
                String newName = (String)event.getNewValue();
                VirtualFile file = event.getFile();
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    VcsVFSListener.this.addFileToMove(file, parent.getPath(), newName);
                }
            }
        }

        private void processEvents(@NotNull List<VFileEvent> events) {
            if (events == null) {
                StateProcessor.$$$reportNull$$$0(15);
            }
            for (VFileEvent event : events) {
                ProgressManager.checkCanceled();
                if (VcsVFSListener.this.isEventIgnored(event)) continue;
                if (event instanceof VFileCreateEvent) {
                    this.processFileCreated((VFileCreateEvent)event);
                    continue;
                }
                if (event instanceof VFileCopyEvent) {
                    this.processFileCopied((VFileCopyEvent)event);
                    continue;
                }
                if (!(event instanceof VFileMoveEvent)) continue;
                this.processFileMoved((VFileMoveEvent)event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/VcsVFSListener$StateProcessor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 5: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParentPath";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$StateProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acquireAllDeletedFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acquireListUnderLock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acquireCopiedFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addException";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "acquireListUnderLock";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processFileCreated";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processFileMoved";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processFileCopied";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeletedFile";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processMovedFile";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeFileMovement";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforePropertyChange";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "processEvents";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum VcsDeleteType {
        SILENT,
        CONFIRM,
        IGNORE;

    }

    protected static class AllDeletedFiles {
        public final List<FilePath> deletedFiles;
        public final List<FilePath> deletedWithoutConfirmFiles;

        public AllDeletedFiles(@NotNull List<FilePath> deletedFiles, @NotNull List<FilePath> deletedWithoutConfirmFiles) {
            if (deletedFiles == null) {
                AllDeletedFiles.$$$reportNull$$$0(0);
            }
            if (deletedWithoutConfirmFiles == null) {
                AllDeletedFiles.$$$reportNull$$$0(1);
            }
            this.deletedFiles = deletedFiles;
            this.deletedWithoutConfirmFiles = deletedWithoutConfirmFiles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deletedFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deletedWithoutConfirmFiles";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/VcsVFSListener$AllDeletedFiles";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MovedFileInfo {
        @NotNull
        public final String myOldPath;
        @NotNull
        public String myNewPath;
        @NotNull
        private final VirtualFile myFile;

        MovedFileInfo(@NotNull VirtualFile file, @NotNull String newPath) {
            if (file == null) {
                MovedFileInfo.$$$reportNull$$$0(0);
            }
            if (newPath == null) {
                MovedFileInfo.$$$reportNull$$$0(1);
            }
            this.myOldPath = file.getPath();
            this.myNewPath = newPath;
            this.myFile = file;
        }

        public String toString() {
            return String.format("MovedFileInfo{[%s] -> [%s]}", this.myOldPath, this.myNewPath);
        }

        public boolean isCaseSensitive() {
            return this.myFile.isCaseSensitive();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/VcsVFSListener$MovedFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

