/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TriggerAdditionOrDeletion {
    private static final Logger LOG = Logger.getInstance(TriggerAdditionOrDeletion.class);
    private final Project myProject;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    private final Set<FilePath> myAffected;
    private final Map<AbstractVcs, Set<FilePath>> myPreparedAddition;
    private final Map<AbstractVcs, Set<FilePath>> myPreparedDeletion;

    public TriggerAdditionOrDeletion(@NotNull Project project) {
        if (project == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(0);
        }
        this.myAffected = new HashSet<FilePath>();
        this.myPreparedAddition = new HashMap<AbstractVcs, Set<FilePath>>();
        this.myPreparedDeletion = new HashMap<AbstractVcs, Set<FilePath>>();
        this.myProject = project;
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
    }

    public Set<FilePath> getAffected() {
        return this.myAffected;
    }

    public void prepare(@NotNull Collection<? extends FilePath> toBeAdded, @NotNull Collection<? extends FilePath> toBeDeleted) {
        if (toBeAdded == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(1);
        }
        if (toBeDeleted == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(2);
        }
        this.processAddition(toBeAdded);
        this.processDeletion(toBeDeleted);
    }

    public void cleanup() {
        this.myVcsFileListenerContextHelper.clearContext();
    }

    public void processIt() {
        ArrayList filePaths;
        CheckinEnvironment localChangesProvider;
        AbstractVcs vcs;
        ArrayList<FilePath> incorrectFilePath = new ArrayList<FilePath>();
        for (Map.Entry<AbstractVcs, Set<FilePath>> entry : this.myPreparedDeletion.entrySet()) {
            vcs = entry.getKey();
            localChangesProvider = Objects.requireNonNull(vcs.getCheckinEnvironment());
            filePaths = new ArrayList(entry.getValue());
            if (filePaths.isEmpty()) continue;
            localChangesProvider.scheduleMissingFileForDeletion(filePaths);
        }
        for (Map.Entry<AbstractVcs, Set<FilePath>> entry : this.myPreparedAddition.entrySet()) {
            vcs = entry.getKey();
            localChangesProvider = Objects.requireNonNull(vcs.getCheckinEnvironment());
            filePaths = new ArrayList(entry.getValue());
            if (filePaths.isEmpty()) continue;
            ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
            for (FilePath path2 : filePaths) {
                VirtualFile vf = path2.getVirtualFile();
                if (vf == null) {
                    incorrectFilePath.add(path2);
                    continue;
                }
                virtualFiles.add(vf);
            }
            localChangesProvider.scheduleUnversionedFilesForAddition(virtualFiles);
        }
        if (!incorrectFilePath.isEmpty()) {
            this.notifyAndLogFiles(incorrectFilePath);
        }
    }

    private void notifyAndLogFiles(@NotNull List<FilePath> incorrectFilePath) {
        if (incorrectFilePath == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(3);
        }
        String message = VcsBundle.message((String)"patch.apply.incorrectly.processed.warning", (Object[])new Object[]{incorrectFilePath.size(), incorrectFilePath});
        LOG.warn(message);
        VcsNotifier.getInstance(this.myProject).notifyImportantWarning("vcs.patch.apply.new.files.error", VcsBundle.message((String)"patch.apply.new.files.warning", (Object[])new Object[0]), message);
    }

    private void processDeletion(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(4);
        }
        Map map2 = VcsUtil.groupByRoots((Project)this.myProject, filePaths, (Function)Functions.identity());
        for (VcsRoot vcsRoot : map2.keySet()) {
            CheckinEnvironment localChangesProvider;
            AbstractVcs vcs = vcsRoot.getVcs();
            if (vcs == null || (localChangesProvider = vcs.getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcs.areDirectoriesVersionedItems();
            Collection files = (Collection)map2.get(vcsRoot);
            ArrayList<FilePath> toBeDeleted = new ArrayList<FilePath>();
            for (FilePath file : files) {
                FilePath parent;
                if (!takeDirs && file.isDirectory() || (parent = file.getParentPath()) == null || !parent.getIOFile().exists()) continue;
                toBeDeleted.add(file);
            }
            if (toBeDeleted.isEmpty()) {
                return;
            }
            this.myAffected.addAll(toBeDeleted);
            if (vcs.fileListenerIsSynchronous()) continue;
            for (FilePath filePath : toBeDeleted) {
                this.myVcsFileListenerContextHelper.ignoreDeleted(filePath);
            }
            Set paths = this.myPreparedDeletion.computeIfAbsent(vcs, key -> new HashSet());
            paths.addAll(toBeDeleted);
        }
    }

    private void processAddition(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(5);
        }
        Map map2 = VcsUtil.groupByRoots((Project)this.myProject, filePaths, (Function)Functions.identity());
        for (VcsRoot vcsRoot : map2.keySet()) {
            CheckinEnvironment localChangesProvider;
            AbstractVcs vcs = vcsRoot.getVcs();
            if (vcs == null || (localChangesProvider = vcs.getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcs.areDirectoriesVersionedItems();
            Collection files = (Collection)map2.get(vcsRoot);
            ArrayList<FilePath> toBeAdded = new ArrayList<FilePath>();
            if (takeDirs) {
                Iterator adder = new RecursiveCheckAdder(vcsRoot.getPath());
                for (FilePath file : files) {
                    ((RecursiveCheckAdder)((Object)adder)).process(file);
                }
                toBeAdded.addAll(((RecursiveCheckAdder)((Object)adder)).getToBeAdded());
            } else {
                for (FilePath file : files) {
                    if (file.isDirectory()) continue;
                    toBeAdded.add(file);
                }
            }
            if (toBeAdded.isEmpty()) {
                return;
            }
            this.myAffected.addAll(toBeAdded);
            if (vcs.fileListenerIsSynchronous()) continue;
            for (FilePath filePath : ContainerUtil.sorted(toBeAdded, (Comparator)FilePathByPathComparator.getInstance())) {
                this.myVcsFileListenerContextHelper.ignoreAdded(filePath.getVirtualFile());
            }
            Set paths = this.myPreparedAddition.computeIfAbsent(vcs, key -> new HashSet());
            paths.addAll(toBeAdded);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeAdded";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeDeleted";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incorrectFilePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/TriggerAdditionOrDeletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyAndLogFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeletion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processAddition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RecursiveCheckAdder {
        private final Set<FilePath> myToBeAdded = new HashSet<FilePath>();
        private final VirtualFile myRoot;

        private RecursiveCheckAdder(VirtualFile root) {
            this.myRoot = root;
        }

        public void process(FilePath path2) {
            for (FilePath current = path2; current != null; current = current.getParentPath()) {
                VirtualFile vf = current.getVirtualFile();
                if (vf == null) {
                    vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(current.getPath());
                }
                if (vf == null) {
                    return;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)this.myRoot, (VirtualFile)vf, (boolean)true)) {
                    return;
                }
                this.myToBeAdded.add(current);
            }
        }

        public Collection<FilePath> getToBeAdded() {
            return this.myToBeAdded;
        }
    }
}

