/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.commit;

import com.intellij.dvcs.commit.AmendCommitServiceKt;
import com.intellij.dvcs.commit.LoadDetailsTaskInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dvcs/commit/AmendCommitService;", "Lcom/intellij/vcs/commit/AmendCommitAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "getVcsLog", "()Lcom/intellij/vcs/log/impl/VcsProjectLog;", "vcsLogObjectsFactory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getVcsLogObjectsFactory", "()Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getAmendCommitDetails", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lcom/intellij/vcs/commit/EditedCommitDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCommitDetails", "Lorg/jetbrains/concurrency/AsyncPromise;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "hash", "Lcom/intellij/vcs/log/Hash;", "intellij.platform.vcs.dvcs.impl"})
public abstract class AmendCommitService
implements AmendCommitAware {
    @NotNull
    private final Project project;

    private final VcsProjectLog getVcsLog() {
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
        return vcsProjectLog;
    }

    private final VcsLogObjectsFactory getVcsLogObjectsFactory() {
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(VcsLogObjectsFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (VcsLogObjectsFactory)object;
    }

    @Override
    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Repository repository = VcsRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        if (repository == null) {
            String string = DvcsBundle.message((String)"error.message.amend.no.repository.for.root", (Object[])new Object[]{root});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DvcsBundle.message(\"erro\u2026pository.for.root\", root)");
            return AmendCommitServiceKt.access$rejected(string);
        }
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"VcsRepositoryManager.get\u2026ository.for.root\", root))");
        Repository repository2 = repository;
        VcsLogData vcsLogData = this.getVcsLog().getDataManager();
        if (vcsLogData == null) {
            String string = DvcsBundle.message((String)"error.message.amend.no.vcs.log.available", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DvcsBundle.message(\"erro\u2026nd.no.vcs.log.available\")");
            return AmendCommitServiceKt.access$rejected(string);
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"vcsLog.dataManager ?: re\u2026d.no.vcs.log.available\"))");
        VcsLogData logData = vcsLogData;
        String string = repository2.getCurrentRevision();
        if (string == null) {
            String string2 = DvcsBundle.message((String)"error.message.amend.repository.is.empty.for.root", (Object[])new Object[]{root});
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DvcsBundle.message(\"erro\u2026is.empty.for.root\", root)");
            return AmendCommitServiceKt.access$rejected(string2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.currentRevisi\u2026s.empty.for.root\", root))");
        String lastCommitId = string;
        Hash hash = this.getVcsLogObjectsFactory().createHash(lastCommitId);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"vcsLogObjectsFactory.createHash(lastCommitId)");
        return (CancellablePromise)this.getCommitDetails(logData, root, hash);
    }

    private final AsyncPromise<EditedCommitDetails> getCommitDetails(VcsLogData logData, VirtualFile root, Hash hash) {
        AsyncPromise promise = new AsyncPromise();
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.project, (TaskInfo)new LoadDetailsTaskInfo(), PerformInBackgroundOption.ALWAYS_BACKGROUND);
        promise.onError((java.util.function.Consumer)new java.util.function.Consumer<Throwable>(indicator){
            final /* synthetic */ BackgroundableProcessIndicator $indicator;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Promises.errorIfNotMessage((Logger)AmendCommitServiceKt.access$getLOG$p(), (Throwable)it);
                if (this.$indicator.isRunning()) {
                    this.$indicator.cancel();
                }
            }
            {
                this.$indicator = backgroundableProcessIndicator;
            }
        });
        logData.getCommitDetailsGetter().loadCommitsData(CollectionsKt.listOf((Object)logData.getCommitIndex(hash, root)), (Consumer)new Consumer<List<VcsFullCommitDetails>>(promise, hash, logData, root){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Hash $hash;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ VirtualFile $root;

            public final void consume(List<VcsFullCommitDetails> commits) {
                List<VcsFullCommitDetails> list = commits;
                Intrinsics.checkNotNullExpressionValue(list, (String)"commits");
                AmendCommitServiceKt.access$setCommit(this.$promise, this.$hash, (VcsFullCommitDetails)CollectionsKt.firstOrNull(list), this.$logData.getCurrentUser().get(this.$root));
            }
            {
                this.$promise = asyncPromise;
                this.$hash = hash;
                this.$logData = vcsLogData;
                this.$root = virtualFile;
            }
        }, (Consumer)new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(Throwable error) {
                Throwable throwable = error;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"error");
                this.$promise.setError(throwable);
            }
            {
                this.$promise = asyncPromise;
            }
        }, (ProgressIndicator)indicator);
        return promise;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public AmendCommitService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

