/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsTaskHandler<R extends Repository>
extends VcsTaskHandler {
    @NotNull
    private final AbstractRepositoryManager<R> myRepositoryManager;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchType;

    protected DvcsTaskHandler(@NotNull AbstractRepositoryManager<R> repositoryManager, @NotNull Project project, @NotNull String branchType) {
        if (repositoryManager == null) {
            DvcsTaskHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DvcsTaskHandler.$$$reportNull$$$0(1);
        }
        if (branchType == null) {
            DvcsTaskHandler.$$$reportNull$$$0(2);
        }
        this.myRepositoryManager = repositoryManager;
        this.myProject = project;
        this.myBranchType = branchType;
    }

    public boolean isEnabled() {
        return !this.myRepositoryManager.getRepositories().isEmpty();
    }

    public VcsTaskHandler.TaskInfo startNewTask(@NotNull String taskName) {
        if (taskName == null) {
            DvcsTaskHandler.$$$reportNull$$$0(3);
        }
        List<R> repositories = this.myRepositoryManager.getRepositories();
        List problems = ContainerUtil.filter(repositories, repository -> this.hasBranch(repository, new VcsTaskHandler.TaskInfo(taskName, Collections.emptyList())));
        ArrayList<R> map2 = new ArrayList<R>();
        if (!problems.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DvcsBundle.message((String)"dialog.title.already.exists", (Object[])new Object[]{StringUtil.capitalize((String)this.myBranchType)}), (String)DvcsBundle.message((String)"dialog.message.following.repositories.already.have.specified", (Object[])new Object[]{this.myBranchType, taskName, StringUtil.join((Iterable)problems, (String)"<br/>"), this.myBranchType})).icon(Messages.getWarningIcon())).ask(this.myProject))) {
            this.checkout(taskName, problems, null);
            map2.addAll(problems);
        }
        repositories.removeAll(problems);
        if (!repositories.isEmpty()) {
            this.checkoutAsNewBranch(taskName, repositories);
        }
        map2.addAll(repositories);
        return new VcsTaskHandler.TaskInfo(taskName, (Collection)ContainerUtil.map(map2, r -> r.getPresentableUrl()));
    }

    public boolean switchToTask(@NotNull VcsTaskHandler.TaskInfo taskInfo, @Nullable Runnable invokeAfter) {
        if (taskInfo == null) {
            DvcsTaskHandler.$$$reportNull$$$0(4);
        }
        List<R> repositories = this.getRepositories(taskInfo.getRepositories());
        List notFound = ContainerUtil.filter(repositories, repository -> !this.hasBranch(repository, taskInfo));
        String branchName = taskInfo.getName();
        if (!notFound.isEmpty()) {
            this.checkoutAsNewBranch(branchName, notFound);
        }
        repositories.removeAll(notFound);
        if (!repositories.isEmpty()) {
            this.checkout(branchName, repositories, invokeAfter);
            return true;
        }
        return false;
    }

    public void closeTask(@NotNull VcsTaskHandler.TaskInfo taskInfo, @NotNull VcsTaskHandler.TaskInfo original) {
        if (taskInfo == null) {
            DvcsTaskHandler.$$$reportNull$$$0(5);
        }
        if (original == null) {
            DvcsTaskHandler.$$$reportNull$$$0(6);
        }
        this.checkout(original.getName(), this.getRepositories(original.getRepositories()), () -> this.mergeAndClose(taskInfo.getName(), this.getRepositories(taskInfo.getRepositories())));
    }

    public boolean isSyncEnabled() {
        return this.myRepositoryManager.isSyncEnabled();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    VcsTaskHandler.TaskInfo @NotNull [] getCurrentTasks() {
        List<R> repositories = this.myRepositoryManager.getRepositories();
        Map tasks = FactoryMap.create(key -> new VcsTaskHandler.TaskInfo(key, new ArrayList()));
        for (Repository repository : repositories) {
            String branch = this.getActiveBranch(repository);
            if (branch == null) continue;
            ((VcsTaskHandler.TaskInfo)tasks.get(branch)).getRepositories().add(repository.getPresentableUrl());
        }
        if (tasks.size() == 0) {
            return new VcsTaskHandler.TaskInfo[0];
        }
        if (this.isSyncEnabled()) {
            VcsTaskHandler.TaskInfo[] taskInfoArray = new VcsTaskHandler.TaskInfo[]{(VcsTaskHandler.TaskInfo)tasks.values().iterator().next()};
            if (taskInfoArray == null) {
                DvcsTaskHandler.$$$reportNull$$$0(7);
            }
            return taskInfoArray;
        }
        VcsTaskHandler.TaskInfo[] taskInfoArray = tasks.values().toArray(new VcsTaskHandler.TaskInfo[0]);
        if (taskInfoArray == null) {
            DvcsTaskHandler.$$$reportNull$$$0(8);
        }
        return taskInfoArray;
    }

    public VcsTaskHandler.TaskInfo[] getAllExistingTasks() {
        List<R> repositories = this.myRepositoryManager.getRepositories();
        MultiMap tasks = new MultiMap();
        for (Repository repository : repositories) {
            for (VcsTaskHandler.TaskInfo branch : this.getAllBranches(repository)) {
                tasks.putValue((Object)branch.getName(), (Object)branch);
            }
        }
        return (VcsTaskHandler.TaskInfo[])ContainerUtil.map2Array((Collection)tasks.entrySet(), VcsTaskHandler.TaskInfo.class, entry -> {
            HashSet repositories1 = new HashSet();
            boolean remote = false;
            for (VcsTaskHandler.TaskInfo info : (Collection)entry.getValue()) {
                remote |= info.isRemote();
                repositories1.addAll(info.getRepositories());
            }
            return new VcsTaskHandler.TaskInfo((String)entry.getKey(), repositories1, remote);
        });
    }

    @NotNull
    private List<R> getRepositories(@NotNull Collection<String> urls) {
        if (urls == null) {
            DvcsTaskHandler.$$$reportNull$$$0(9);
        }
        List repositories = this.myRepositoryManager.getRepositories();
        List list = ContainerUtil.mapNotNull(urls, s -> (Repository)ContainerUtil.find((Iterable)repositories, repository -> s.equals(repository.getPresentableUrl())));
        if (list == null) {
            DvcsTaskHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected abstract void checkout(@NotNull String var1, @NotNull List<? extends R> var2, @Nullable Runnable var3);

    protected abstract void checkoutAsNewBranch(@NotNull String var1, @NotNull List<? extends R> var2);

    @Nullable
    protected abstract String getActiveBranch(R var1);

    @NotNull
    protected abstract Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull R var1);

    protected abstract void mergeAndClose(@NotNull String var1, @NotNull List<? extends R> var2);

    protected abstract boolean hasBranch(@NotNull R var1, @NotNull VcsTaskHandler.TaskInfo var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsTaskHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsTaskHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTasks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startNewTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "switchToTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "closeTask";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

