/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker.phpunit.coverage;

import com.intellij.docker.RemoteDockerRuntimeUtil;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.remote.DockerComposeContainerUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeStartCommand;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeTypeData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkTypeData;
import com.jetbrains.php.remote.phpunit.coverage.PhpRemoteCoverageResultManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PhpDockerCoverageResultManager
extends PhpRemoteCoverageResultManager {
    private static final Logger LOG = Logger.getInstance(PhpDockerCoverageResultManager.class);
    private static final String COVERAGE_DIR = "/opt/phpstorm-coverage/";
    private final PhpRemoteSdkAdditionalData mySdkData;
    private String myLocalPath;
    private String myRemotePath;

    public PhpDockerCoverageResultManager(@NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (sdkData == null) {
            PhpDockerCoverageResultManager.$$$reportNull$$$0(0);
        }
        super(sdkData);
        this.mySdkData = sdkData;
    }

    @NotNull
    public String processCoverageFile(@NotNull String localPath) {
        if (localPath == null) {
            PhpDockerCoverageResultManager.$$$reportNull$$$0(1);
        }
        this.myLocalPath = localPath;
        this.myRemotePath = COVERAGE_DIR + PathUtil.getFileName((String)localPath);
        String string = this.myRemotePath;
        if (string == null) {
            PhpDockerCoverageResultManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void copyFromRemote(@NotNull Project project) {
        PhpRemoteSdkTypeData typeData;
        if (project == null) {
            PhpDockerCoverageResultManager.$$$reportNull$$$0(3);
        }
        if (!((typeData = this.mySdkData.getTypeData()) instanceof PhpDockerComposeTypeData) || ((PhpDockerComposeTypeData)typeData).getCommand() != PhpDockerComposeStartCommand.EXEC) {
            return;
        }
        DockerComposeCredentialsHolder holder = PhpDockerProcessUtil.tryGetDockerCredentials(this.mySdkData);
        if (holder != null) {
            RemoteDockerRuntime runtime;
            try {
                runtime = PhpDockerProcessUtil.createDockerRuntime(holder, project);
            }
            catch (RemoteSdkException | ServerRuntimeException e) {
                LOG.warn(PhpBundle.message((String)"docker.compose.coverage.file.failed.to.copy", (Object[])new Object[0]));
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    DockerAgentApplication container = DockerComposeContainerUtil.findContainerByServiceName((Project)project, (RemoteDockerRuntime)runtime, (DockerComposeCredentialsHolder)holder, (boolean)true);
                    if (container != null) {
                        RemoteDockerRuntimeUtil.download((DockerAgentApplication)container, (AgentTaskExecutor)runtime.getAgentExecutor(), (String)this.myRemotePath, (File)new File(this.myLocalPath), (Map)null, null);
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.warn(PhpBundle.message((String)"docker.compose.coverage.file.is.not.found", (Object[])new Object[0]));
                }
                catch (ExecutionException | ServerRuntimeException e) {
                    LOG.warn(PhpBundle.message((String)"docker.compose.coverage.file.failed.to.copy", (Object[])new Object[0]));
                }
                catch (IOException e) {
                    LOG.warn(PhpBundle.message((String)"docker.compose.coverage.file.failed.to.extract", (Object[])new Object[0]));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/phpunit/coverage/PhpDockerCoverageResultManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/phpunit/coverage/PhpDockerCoverageResultManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processCoverageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCoverageFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

