/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker.compose;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceExecCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.remote.DockerComposeContainerUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.docker.PhpDockerHelpersManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposePrefixProcessor;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeStartCommand;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeTypeData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkTypeData;
import com.jetbrains.php.run.PhpExternalExecutionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerComposeRemoteProcessRunner
extends PhpRemoteProcessRunner {
    private static final Logger LOG = Logger.getInstance(PhpDockerComposeRemoteProcessRunner.class);
    private static final PhpDockerComposeRemoteProcessRunner ourInstance = new PhpDockerComposeRemoteProcessRunner();
    private final Set<String> myContainersWithHelpers = new HashSet<String>();

    @NotNull
    public static PhpRemoteProcessRunner getInstance() {
        PhpDockerComposeRemoteProcessRunner phpDockerComposeRemoteProcessRunner = ourInstance;
        if (phpDockerComposeRemoteProcessRunner == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(0);
        }
        return phpDockerComposeRemoteProcessRunner;
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, @NotNull String title, @Nullable JComponent component) throws ExecutionException, InterruptedException {
        ProcessOutput processOutput;
        DockerComposeCredentialsHolder docker;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(1);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(3);
        }
        if (title == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(4);
        }
        if ((docker = PhpDockerProcessUtil.tryGetDockerCredentials(sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteDockerRuntime dockerRuntime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceRunCmd cmd = serviceClient.runServiceCmd();
            PhpDockerComposeRemoteProcessRunner.fillSettings(commandLine, docker, (AbstractServiceCmd)cmd, true);
            cmd.withSharedVolume(PhpDockerHelpersManager.getHelpersContainerSharedVolume(dockerRuntime));
            KillableColoredProcessHandler processHandler = ((ComposeServiceRunCmd)cmd.withRestartPolicy((RestartPolicy)RestartPolicy.noRestart())).withRemove(true).execute();
            processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw (UndeclaredThrowableException)DockerUtil.propagateRuntimeExceptionCause((RuntimeException)e, InterruptedException.class);
        }
        if (processOutput == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    public static void fillSettings(@NotNull GeneralCommandLine commandLine, @NotNull DockerComposeCredentialsHolder docker, @NotNull AbstractServiceCmd service, boolean overwriteEntrypoint) {
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(6);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(7);
        }
        if (service == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(8);
        }
        service.withConfigurationPath(docker.getComposeFilePaths());
        service.withServiceName(docker.getComposeServiceName());
        File workingDir = commandLine.getWorkDirectory();
        if (workingDir != null) {
            service.withWorkingDir(DockerUtil.toUnixPath((String)workingDir.getPath()));
        }
        ArrayList<String> params = new ArrayList<String>();
        if (overwriteEntrypoint) {
            service.withEntrypoint(new String[]{commandLine.getExePath()});
        } else {
            params.add(commandLine.getExePath());
        }
        for (String param : commandLine.getParametersList().getArray()) {
            params.add(StringUtil.replace((String)param, (String)"$", (String)"$$"));
        }
        service.withCommand(params.toArray(new String[0]));
        HashMap<String, String> newEnvs = new HashMap<String, String>();
        newEnvs.put("JETBRAINS_REMOTE_RUN", "1");
        newEnvs.putAll(commandLine.getEnvironment());
        service.withEnvironment(newEnvs);
        service.withEnvs((Map)DockerComposeContainerUtil.getEnvs((DockerComposeCredentialsHolder)docker));
    }

    @NotNull
    public Process getRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(9);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(11);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(12);
        }
        PhpDockerComposeStartCommand command = PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand(sdkData);
        return this.startRemoteProcess(project, sdkData, commandLine, true, command, additionalMappings);
    }

    @NotNull
    public static PhpDockerComposeStartCommand getDockerComposeCommand(@NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(13);
        }
        if (Registry.is((String)"php.use.docker.compose.up")) {
            PhpDockerComposeStartCommand phpDockerComposeStartCommand = PhpDockerComposeStartCommand.UP;
            if (phpDockerComposeStartCommand == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(14);
            }
            return phpDockerComposeStartCommand;
        }
        PhpRemoteSdkTypeData typeData = sdkData.getTypeData();
        PhpDockerComposeStartCommand phpDockerComposeStartCommand = typeData instanceof PhpDockerComposeTypeData ? ((PhpDockerComposeTypeData)typeData).getCommand() : PhpDockerComposeStartCommand.RUN;
        if (phpDockerComposeStartCommand == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(15);
        }
        return phpDockerComposeStartCommand;
    }

    public boolean canRunBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(16);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(17);
        }
        return false;
    }

    @NotNull
    public Process getRemoteBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(18);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(19);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(20);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(21);
        }
        return this.startRemoteProcess(project, sdkData, commandLine, false, PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand(sdkData), additionalMappings);
    }

    @NotNull
    private Process startRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, boolean withHelpers, @NotNull PhpDockerComposeStartCommand command, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        Process process;
        DockerComposeCredentialsHolder docker;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(22);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(23);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(24);
        }
        if (command == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(25);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(26);
        }
        if ((docker = PhpDockerProcessUtil.tryGetDockerCredentials(sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteDockerRuntime runtime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            AbstractServiceCmd cmd = this.buildDockerComposeCommand(project, runtime, docker, commandLine, sdkData, withHelpers, command, additionalMappings);
            KillableColoredProcessHandler processHandler = cmd.execute();
            LOG.debug("Executing: " + processHandler.getCommandLine());
            process = processHandler.getProcess();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(27);
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AbstractServiceCmd buildDockerComposeCommand(@NotNull Project project, @NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerComposeCredentialsHolder docker, @NotNull GeneralCommandLine commandLine, PhpRemoteSdkAdditionalData sdkData, boolean withHelpers, @NotNull PhpDockerComposeStartCommand command, // Could not load outer class - annotation placement on inner may be incorrect
    PathMappingSettings.PathMapping @NotNull [] additionalMappings) throws IOException, ServerRuntimeException, ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(28);
        }
        if (dockerRuntime == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(29);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(30);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(31);
        }
        if (command == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(32);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(33);
        }
        if (command == PhpDockerComposeStartCommand.EXEC) {
            int index;
            DockerAgentApplication container = DockerComposeContainerUtil.findContainerByServiceName((Project)project, (RemoteDockerRuntime)dockerRuntime, (DockerComposeCredentialsHolder)docker, (boolean)true);
            if (container == null) {
                throw new PhpExternalExecutionException(PhpBundle.message((String)"docker.compose.failed.to.start.container", (Object[])new Object[0]));
            }
            ComposeServiceExecCmd cmd = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).execServiceCmd();
            SmartList subcommand = new SmartList();
            if (SystemInfo.isWindows) {
                cmd.withNoPty(Boolean.valueOf(true));
                subcommand.add("-T");
            }
            if ((index = DockerComposeContainerUtil.getContainerIndex((Map)container.getContainerLabels(), (int)1)) != 1) {
                subcommand.add("--index=" + index);
            }
            if (!subcommand.isEmpty()) {
                cmd.withSubcommandOptions((List)subcommand);
            }
            PhpDockerComposeRemoteProcessRunner.fillSettings(commandLine, docker, (AbstractServiceCmd)cmd, false);
            String containerId = container.getContainerId();
            String remotePath = sdkData.getHelpersPath();
            if (withHelpers && !this.myContainersWithHelpers.contains(containerId)) {
                File tempDirectory = FileUtil.createTempDirectory((String)"phpstorm-helpers-docker-compose", (String)"", (boolean)false);
                try {
                    File newHelpersDir = new File(tempDirectory.getPath() + "/" + PathUtil.getFileName((String)remotePath));
                    FileUtil.copyDir((File)new File(PhpRemoteTransfer.getHelpersRoot().getPath()), (File)newHelpersDir);
                    container.copyArchiveToContainer(PathUtil.getParentPath((String)remotePath), newHelpersDir.getPath());
                }
                finally {
                    FileUtil.delete((File)tempDirectory);
                }
                this.myContainersWithHelpers.add(containerId);
            }
            for (PathMappingSettings.PathMapping mapping : additionalMappings) {
                container.copyArchiveToContainer(PathUtil.getParentPath((String)remotePath), FileUtil.toSystemDependentName((String)mapping.getLocalRoot()));
            }
            ComposeServiceExecCmd composeServiceExecCmd = cmd;
            if (composeServiceExecCmd == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(34);
            }
            return composeServiceExecCmd;
        }
        if (command == PhpDockerComposeStartCommand.RUN) {
            ComposeServiceRunCmd cmd = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).runServiceCmd();
            PhpDockerComposeRemoteProcessRunner.configureUpOrRunService(dockerRuntime, docker, commandLine, withHelpers, additionalMappings, (AbstractServiceCmd)cmd);
            ((ComposeServiceRunCmd)cmd.withRestartPolicy((RestartPolicy)RestartPolicy.noRestart())).withNoDeps(false).withRemove(true);
            ComposeServiceRunCmd composeServiceRunCmd = cmd;
            if (composeServiceRunCmd == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(35);
            }
            return composeServiceRunCmd;
        }
        ComposeServiceUpCmd cmd = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).upServicesCmd();
        PhpDockerComposeRemoteProcessRunner.configureUpOrRunService(dockerRuntime, docker, commandLine, withHelpers, additionalMappings, (AbstractServiceCmd)cmd);
        ComposeServiceUpCmd composeServiceUpCmd = cmd;
        if (composeServiceUpCmd == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(36);
        }
        return composeServiceUpCmd;
    }

    private static void configureUpOrRunService(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerComposeCredentialsHolder docker, @NotNull GeneralCommandLine commandLine, boolean withHelpers, // Could not load outer class - annotation placement on inner may be incorrect
    PathMappingSettings.PathMapping @NotNull [] additionalMappings, @NotNull AbstractServiceCmd cmd) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(37);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(38);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(39);
        }
        if (cmd == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(40);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(41);
        }
        PhpDockerComposeRemoteProcessRunner.fillSettings(commandLine, docker, cmd, true);
        if (withHelpers) {
            cmd.withSharedVolume(PhpDockerHelpersManager.getHelpersContainerSharedVolume(dockerRuntime));
        }
        VolumesBuilder volumesBuilder = VolumesBuilder.builder();
        for (PathMappingSettings.PathMapping mapping : additionalMappings) {
            volumesBuilder.addBoundVolume(mapping.getRemoteRoot(), FileUtil.toSystemDependentName((String)mapping.getLocalRoot()));
        }
        cmd.withVolumes(volumesBuilder.build());
    }

    @NotNull
    public ProcessHandler createRemoteProcessHandler(@NotNull Process process, @NotNull String commandTitle, @NotNull Charset charset, @NotNull PhpRemoteSdkAdditionalData remoteData, boolean verbose) {
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(42);
        }
        if (commandTitle == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(43);
        }
        if (charset == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(44);
        }
        if (remoteData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(45);
        }
        if (!verbose) {
            return PhpDockerComposeRemoteProcessRunner.createNotVerboseHandler(process, commandTitle, charset, remoteData);
        }
        ProcessHandler processHandler = super.createRemoteProcessHandler(process, commandTitle, charset, remoteData, true);
        if (processHandler == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(46);
        }
        return processHandler;
    }

    @NotNull
    public Process startRemoteProcessWithoutHelpers(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(47);
        }
        if (data == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(48);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(49);
        }
        PhpDockerComposeStartCommand command = PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand(data);
        return this.startRemoteProcess(project, data, commandLine, false, command, new PathMappingSettings.PathMapping[0]);
    }

    @NotNull
    private static ProcessHandler createNotVerboseHandler(@NotNull Process process, @NotNull String commandTitle, @NotNull Charset charset, @NotNull PhpRemoteSdkAdditionalData remoteData) {
        DockerComposeCredentialsHolder credentials;
        String composeServiceName;
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(50);
        }
        if (commandTitle == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(51);
        }
        if (charset == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(52);
        }
        if (remoteData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(53);
        }
        String string = composeServiceName = (credentials = (DockerComposeCredentialsHolder)ObjectUtils.tryCast((Object)remoteData.connectionCredentials().getCredentials(), DockerComposeCredentialsHolder.class)) != null ? credentials.getComposeServiceName() : null;
        if (process instanceof RemoteProcess) {
            return new MyColoredRemoteProcessHandler((RemoteProcess)process, commandTitle, charset, composeServiceName);
        }
        return new MyColoredKillableRemoteProcessHandler(process, commandTitle, charset, composeServiceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner";
                break;
            }
            case 1: 
            case 9: 
            case 16: 
            case 18: 
            case 22: 
            case 28: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 20: 
            case 24: 
            case 31: 
            case 39: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 12: 
            case 21: 
            case 26: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandTitle";
                break;
            }
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 45: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteData";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeCommand";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeCommand";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillSettings";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeCommand";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canRunBackgroundProcess";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteBackgroundProcess";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeCommand";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "configureUpOrRunService";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcessHandler";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcessWithoutHelpers";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createNotVerboseHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyColoredKillableRemoteProcessHandler
    extends KillableColoredProcessHandler
    implements AnsiEscapeDecoder.ColoredChunksAcceptor {
        private final PhpDockerComposePrefixProcessor myProcessor;

        MyColoredKillableRemoteProcessHandler(@NotNull Process process, String commandLine, Charset charset, String composeServiceName) {
            if (process == null) {
                MyColoredKillableRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process, commandLine, charset);
            this.myProcessor = new PhpDockerComposePrefixProcessor(composeServiceName, (x$0, x$1) -> super.coloredTextAvailable(x$0, x$1));
        }

        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> chunks) {
            if (chunks == null) {
                MyColoredKillableRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            this.myProcessor.accept(chunks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner$MyColoredKillableRemoteProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredChunksAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyColoredRemoteProcessHandler
    extends ColoredRemoteProcessHandler<RemoteProcess>
    implements AnsiEscapeDecoder.ColoredChunksAcceptor {
        private final PhpDockerComposePrefixProcessor myProcessor;

        MyColoredRemoteProcessHandler(@NotNull RemoteProcess process, String commandLine, Charset charset, String composeServiceName) {
            if (process == null) {
                MyColoredRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process, commandLine, charset);
            this.myProcessor = new PhpDockerComposePrefixProcessor(composeServiceName, (x$0, x$1) -> super.coloredTextAvailable(x$0, x$1));
        }

        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> chunks) {
            if (chunks == null) {
                MyColoredRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            this.myProcessor.accept(chunks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner$MyColoredRemoteProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredChunksAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

