/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.RedshiftExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.RsIntermediateFacade;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsJdbcHelper
extends PgBaseJdbcHelper {
    private static final Pattern RS_VERSION_PATTERN = Pattern.compile("redshift\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public RsJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("REDSHIFT", version, connection);
    }

    public RsJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return RsJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            RsJdbcHelper.$$$reportNull$$$0(0);
        }
        return new RsIntermediateFacade(ds, RedshiftExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.SELECTS_ONLY;
    }

    @Override
    protected Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Array a, @Nullable RemoteResultSet.DataRetrievingOptions options) throws SQLException, RemoteException {
        if (exporter == null) {
            RsJdbcHelper.$$$reportNull$$$0(1);
        }
        try {
            return super.wrapIfNeeded(exporter, a, options);
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 500056) {
                throw e;
            }
            return a.toString();
        }
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            RsJdbcHelper.$$$reportNull$$$0(2);
        }
        if ("bpchar".equals(e.typeName)) {
            e.typeName = "char";
            return;
        }
        super.adjustType(e);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            RsJdbcHelper.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            RsJdbcHelper.$$$reportNull$$$0(4);
        }
        if (sslMode == null) {
            RsJdbcHelper.$$$reportNull$$$0(5);
        }
        RsJdbcHelper.setIfEmpty(properties, "ssl", "true");
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            RsJdbcHelper.setIfEmpty(properties, "sslmode", RsJdbcHelper.getSslMode(sslMode));
        }
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            RsJdbcHelper.$$$reportNull$$$0(6);
        }
        return RsJdbcHelper.classNameContains(driver, "redshift");
    }

    @NotNull
    protected static RsJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = RsJdbcHelper.extractVersion(versionStr);
        return new RsJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, RS_VERSION_PATTERN);
    }

    @Override
    @Nullable
    public Boolean supportsSavepoints() {
        return false;
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        String typeName;
        if (options == null) {
            RsJdbcHelper.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            RsJdbcHelper.$$$reportNull$$$0(8);
        }
        if (metaData == null) {
            RsJdbcHelper.$$$reportNull$$$0(9);
        }
        return "interval".equals(typeName = metaData.getColumnTypeName(index)) ? resultSet.getString(index) : ("bit".equals(typeName) && metaData.getPrecision(index) > 1 ? resultSet.getString(index) : super.tryGetObject(options, resultSet, metaData, index));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/RsJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

