/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.AseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.AzureJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.BigQueryJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.CHouseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.CouchbaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2LuwJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.DerbyJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.ExaJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.GBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.GPlumJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.GenericJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.H2JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.HiveJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.HsqlJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.MariaJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MemJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MsJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MysqlJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.OraJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.PgJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.RsJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.SFlakeJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.SqliteJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.VertJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtilRt;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JdbcNativeUtil {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final int UNKNOWN_UPDATE_COUNT = -2;
    protected static final Pattern DEFAULT_VERSION_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)+)");
    private static final GenericJdbcHelper ourGenericHelper = new GenericJdbcHelper();
    private static final List<JdbcHelperImpl> ourImpls = Arrays.asList(new AseJdbcHelper(), new BigQueryJdbcHelper(), new Db2JdbcHelper(), new Db2LuwJdbcHelper(), new CHouseJdbcHelper(), new CassJdbcHelper(), new H2JdbcHelper(), new HsqlJdbcHelper(), new ExaJdbcHelper(), new MsJdbcHelper(), new AzureJdbcHelper(), new MysqlJdbcHelper(), new MariaJdbcHelper(), new MemJdbcHelper(), new GBaseJdbcHelper(), new OraJdbcHelper(), new PgJdbcHelper(), new RsJdbcHelper(), new GPlumJdbcHelper(), new SqliteJdbcHelper(), new DerbyJdbcHelper(), new HiveJdbcHelper(), new VertJdbcHelper(), new SFlakeJdbcHelper(), new MongoJdbcHelper(), new CouchbaseJdbcHelper(), ourGenericHelper);

    public static void logInfo(@NotNull String s) {
        if (s == null) {
            JdbcNativeUtil.$$$reportNull$$$0(0);
        }
        System.out.println(s);
    }

    public static void logWarn(@Nullable String s, @Nullable Throwable t) {
        if (s != null) {
            System.err.println(s);
        }
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    public static void closeRemoteStatementSafe(final @Nullable RemoteStatement statement) {
        if (statement == null) {
            return;
        }
        JdbcNativeUtil.performSafe((ThrowableRunnable<? extends Exception>)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                statement.close();
            }
        });
    }

    public static void performSafe(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        if (runnable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(1);
        }
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static <T> T computeSafe(@NotNull ThrowableComputable<T, ? extends Exception> computable) {
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(2);
        }
        try {
            return (T)computable.compute();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static boolean getBooleanSafe(@NotNull ThrowableComputable<Boolean, ? extends Exception> computable) {
        Boolean res;
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(3);
        }
        return (res = JdbcNativeUtil.computeSafe(computable)) != null && res != false;
    }

    public static int getIntSafe(@NotNull ThrowableComputable<Integer, ? extends Exception> computable) {
        Integer res;
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(4);
        }
        return (res = JdbcNativeUtil.computeSafe(computable)) != null ? res : -1;
    }

    public static void performRemote(@NotNull ThrowableRunnable<? extends Exception> runnable) throws SQLException {
        if (runnable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(5);
        }
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (ExceptionUtilRt.causedBy((Throwable)e, AbstractMethodError.class)) {
                return;
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Nullable
    public static <T> T computeRemote(@NotNull ThrowableComputable<T, ? extends Exception> computable) throws SQLException {
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(6);
        }
        try {
            return (T)computable.compute();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (ExceptionUtilRt.causedBy((Throwable)e, AbstractMethodError.class)) {
                return null;
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
        catch (AssertionError ignore) {
            return null;
        }
    }

    @Nullable
    public static Object tryGetString(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(7);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
    }

    @Nullable
    public static Object tryGetBytes(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(8);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getBytes", null, null);
    }

    @NotNull
    public static JdbcHelperImpl detect(@NotNull Connection delegate) {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(9);
        }
        JdbcHelperImpl res = null;
        try {
            res = JdbcNativeUtil.detectImpl(delegate);
            JdbcNativeUtil.logInfo("Detected: " + res.getDbmsName() + " " + res.getVersion());
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("DBMS detection failed", e);
        }
        JdbcHelperImpl jdbcHelperImpl = res == null ? new GenericJdbcHelper() : res;
        if (jdbcHelperImpl == null) {
            JdbcNativeUtil.$$$reportNull$$$0(10);
        }
        return jdbcHelperImpl;
    }

    @NotNull
    public static JdbcHelperImpl detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            JdbcNativeUtil.$$$reportNull$$$0(11);
        }
        for (JdbcHelperImpl impl : JdbcNativeUtil.getImplsFor("detect", Driver.class, String.class)) {
            if (!impl.detect(driver, url)) continue;
            JdbcHelperImpl jdbcHelperImpl = impl;
            if (jdbcHelperImpl == null) {
                JdbcNativeUtil.$$$reportNull$$$0(12);
            }
            return jdbcHelperImpl;
        }
        GenericJdbcHelper genericJdbcHelper = ourGenericHelper;
        if (genericJdbcHelper == null) {
            JdbcNativeUtil.$$$reportNull$$$0(13);
        }
        return genericJdbcHelper;
    }

    @NotNull
    static JdbcHelperImpl detectImpl(@NotNull Connection delegate) throws Exception {
        String version;
        String name;
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(14);
        }
        DatabaseMetaData metaData = delegate.getMetaData();
        try {
            JdbcNativeUtil.logInfo("Driver: " + metaData.getDriverName() + " " + metaData.getDriverVersion());
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Driver version detection failed", e);
        }
        try {
            name = metaData.getDatabaseProductName();
        }
        catch (Throwable th) {
            name = null;
        }
        try {
            version = metaData.getDatabaseProductVersion();
        }
        catch (Throwable th) {
            version = null;
        }
        return JdbcNativeUtil.detectImpl(delegate, name, version);
    }

    @NotNull
    @TestOnly
    public static JdbcHelperImpl detect(@Nullable String name, @Nullable String version) throws Exception {
        return JdbcNativeUtil.detectImpl(null, name, version);
    }

    @NotNull
    private static JdbcHelperImpl detectImpl(@Nullable Connection delegate, String name, String version) throws Exception {
        for (JdbcHelperImpl impl : JdbcNativeUtil.getImplsFor("detect", Connection.class, String.class, String.class)) {
            JdbcHelperImpl res = impl.detect(delegate, name, version);
            if (res == null) continue;
            JdbcHelperImpl jdbcHelperImpl = res;
            if (jdbcHelperImpl == null) {
                JdbcNativeUtil.$$$reportNull$$$0(15);
            }
            return jdbcHelperImpl;
        }
        throw new AssertionError((Object)"Should not happen");
    }

    static boolean detectString(@Nullable String product, @NotNull String part) {
        if (part == null) {
            JdbcNativeUtil.$$$reportNull$$$0(16);
        }
        return product != null && Pattern.compile("\\b" + part, 2).matcher(product).find();
    }

    @Nullable
    static String getString(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(17);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(18);
        }
        return JdbcNativeUtil.getString(delegate, sql, 1);
    }

    @Nullable
    static String getString(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, final int col) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(19);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(20);
        }
        final Ref res = Ref.create();
        JdbcNativeUtil.consume(delegate, sql, (ThrowableConsumer<? super ResultSet, ? extends Exception>)new ThrowableConsumer<ResultSet, Exception>(){

            public void consume(ResultSet rs) throws Exception {
                res.set(rs.next() ? rs.getString(col) : null);
            }
        });
        return (String)res.get();
    }

    @NotNull
    static String[] getStrings(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(21);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(22);
        }
        final Ref res = Ref.create();
        JdbcNativeUtil.consume(delegate, sql, (ThrowableConsumer<? super ResultSet, ? extends Exception>)new ThrowableConsumer<ResultSet, Exception>(){

            public void consume(ResultSet rs) throws Exception {
                if (!rs.next()) {
                    return;
                }
                String[] cols = new String[rs.getMetaData().getColumnCount()];
                for (int i = 0; i < cols.length; ++i) {
                    cols[i] = rs.getString(i + 1);
                }
                res.set((Object)cols);
            }
        });
        String[] stringArray = res.isNull() ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])res.get();
        if (stringArray == null) {
            JdbcNativeUtil.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    static void consume(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, final @NotNull ThrowableConsumer<? super ResultSet, ? extends Exception> computable) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(24);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(25);
        }
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(26);
        }
        JdbcNativeUtil.prepared(delegate, sql, new ThrowableConsumer<PreparedStatement, Exception>(){

            public void consume(PreparedStatement stmt) throws Exception {
                stmt.execute();
                ResultSet rs = stmt.getResultSet();
                try {
                    computable.consume((Object)rs);
                }
                finally {
                    rs.close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <E extends Exception> void prepared(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, @NotNull ThrowableConsumer<? super PreparedStatement, E> computable) throws E, SQLException {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(27);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(28);
        }
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(29);
        }
        PreparedStatement stmt = delegate.prepareStatement(sql);
        try {
            computable.consume((Object)stmt);
        }
        finally {
            stmt.close();
        }
    }

    @Nullable
    static String findVersion(@Nullable String versionStr, @NotNull Pattern pattern) {
        if (pattern == null) {
            JdbcNativeUtil.$$$reportNull$$$0(30);
        }
        if (versionStr == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(versionStr);
        return matcher.find() ? matcher.group(1) : null;
    }

    @NotNull
    public static Calendar getUtcCalendar() {
        Calendar calendar = Calendar.getInstance(UTC);
        if (calendar == null) {
            JdbcNativeUtil.$$$reportNull$$$0(31);
        }
        return calendar;
    }

    @NotNull
    public static Date createSqlDate(@NotNull java.util.Date value) {
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(32);
        }
        return value instanceof Date ? (Date)value : new Date(value.getTime());
    }

    private static Iterable<JdbcHelperImpl> getImplsFor(String name, Class<?> ... params) {
        LinkedHashMap items = new LinkedHashMap();
        for (JdbcHelperImpl impl : ourImpls) {
            try {
                Class<?> declaring = impl.getClass().getMethod(name, params).getDeclaringClass();
                if (items.containsKey(declaring)) continue;
                items.put(declaring, impl);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        ArrayList entries = new ArrayList(items.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<Class<?>, JdbcHelperImpl>>(){

            @Override
            public int compare(Map.Entry<Class<?>, JdbcHelperImpl> o1, Map.Entry<Class<?>, JdbcHelperImpl> o2) {
                return JdbcNativeUtil.compareClasses(o1.getKey(), o2.getKey());
            }
        });
        return ContainerUtilRt.map2List(entries, (Function)new Function<Map.Entry<Class<?>, JdbcHelperImpl>, JdbcHelperImpl>(){

            public JdbcHelperImpl fun(Map.Entry<Class<?>, JdbcHelperImpl> entry) {
                return entry.getValue();
            }
        });
    }

    private static int compareClasses(Class<?> o1, Class<?> o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.isAssignableFrom(o2)) {
            return 1;
        }
        if (o2.isAssignableFrom(o1)) {
            return -1;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcNativeUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcNativeUtil";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "detectImpl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrings";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtcCalendar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performSafe";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeSafe";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanSafe";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntSafe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRemote";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeRemote";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryGetString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryGetBytes";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 31: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "detectImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "detectString";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStrings";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "prepared";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSqlDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

