/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> DERBY_UNLIMITED_TYPES = new HashSet<String>(Arrays.asList("integer", "smallint", "bigint", "date", "time", "xml", "timestamp", "boolean", "double", "real", "float", "long varchar", "long varchar for bit data"));

    public DerbyJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("DERBY", version, connection);
    }

    public DerbyJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return DerbyJdbcHelper.extractVersion(version);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(0);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (DERBY_UNLIMITED_TYPES.contains(t) || DEFAULT_UNLIMITED_TYPES.contains(t) && e.length == Integer.MAX_VALUE) {
            e.length = -1;
        }
        DerbyJdbcHelper.processForBitData(e);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "derby")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return DerbyJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static DerbyJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new DerbyJdbcHelper(DerbyJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/remote/jdbc/helpers/DerbyJdbcHelper", "adjustType"));
    }
}

