/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.Db2IsJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2LuwJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2ZosJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.openapi.util.text.StringUtilRt;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Db2BaseJdbcHelper
extends JdbcHelperImpl {
    private static final Pattern DB2_VERSION_PATTERN = Pattern.compile("\\w\\w\\w(\\d\\d)(\\d\\d)(\\d+)");
    private static final Set<String> DB2_UNLIMITED_TYPES = new HashSet<String>(Arrays.asList("integer", "smallint", "boolean", "bigint", "double", "real", "date", "time", "xml"));
    private static final Set<String> DB2_TWICE_TYPES = new HashSet<String>(Arrays.asList("graphic", "vargraphic", "dbclob"));

    public Db2BaseJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection);
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(1);
        }
        if (value == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Class<?> c = o.getClass();
        String className = c.getName();
        if (className.equals("com.ibm.db2.jcc.am.ke") || className.equals("com.ibm.db2.jcc.am.bf") || className.equals("com.ibm.db2.jcc.am.dc")) {
            return JdbcNativeUtil.tryGetString(o);
        }
        return super.convertValue(exporter, o);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(3);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (DB2_UNLIMITED_TYPES.contains(t) || e.length == 0) {
            e.length = -1;
        } else if (t.equals("timestamp")) {
            e.length = e.scale;
            e.scale = 0;
        } else if (DB2_TWICE_TYPES.contains(t)) {
            e.length /= 2;
        }
        Db2BaseJdbcHelper.processForBitData(e);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "db2")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        String version = StringUtilRt.notNullize((String)productVer);
        return version.startsWith("SQL") ? Db2LuwJdbcHelper.create(delegate, productVer) : (version.startsWith("QSQ") ? Db2IsJdbcHelper.create(delegate, productVer) : (version.startsWith("DSN") ? Db2ZosJdbcHelper.create(delegate, productVer) : Db2JdbcHelper.create(delegate, productVer)));
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return Db2BaseJdbcHelper.extractVersion(version);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = DB2_VERSION_PATTERN.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String s = matcher.group(1);
        if (s.startsWith("0")) {
            s = s.substring(1);
        }
        return s + "." + matcher.group(2) + "." + matcher.group(3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/Db2BaseJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setBigInteger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

