/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.util.PipedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PipedOutputStream
extends OutputStream {
    private PipedInputStream sink;

    public PipedOutputStream(PipedInputStream snk) throws IOException {
        this.connect(snk);
    }

    public PipedOutputStream() {
    }

    public synchronized void connect(PipedInputStream snk) throws IOException {
        if (snk == null) {
            throw new NullPointerException();
        }
        if (this.sink != null || snk.connected) {
            throw new IOException("Already connected");
        }
        this.sink = snk;
        snk.in = -1;
        snk.out = 0;
        snk.connected = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        this.sink.receive(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.sink.receive(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        if (this.sink != null) {
            PipedInputStream pipedInputStream = this.sink;
            synchronized (pipedInputStream) {
                this.sink.notifyAll();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }
}

