/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.settings.DockerSystemInfo;
import com.intellij.docker.agent.terminal.pipe.DockerConsolePipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DockerAgentApplication
extends CloudRemoteApplication {
    public static final DockerAgentApplication[] EMPTY_ARRAY = new DockerAgentApplication[0];

    @Nullable
    public String getPresentableName();

    @NotNull
    public String getUniqueName();

    @Nullable
    public String getAgentApplicationStatus();

    public String getContainerId();

    public String getContainerName();

    @Nullable
    public Map<String, String> getContainerLabels();

    public String getImageName();

    public String getImageId();

    public String[] getImageRepoTags();

    public String[] getContainerNames();

    public String getImageParentId();

    public void startContainer();

    public void stopContainer();

    public void stopContainerImmediate(CloudAgentErrorHandler var1);

    public void killContainer(CloudAgentErrorHandler var1);

    public void deleteContainer();

    public void deleteImage();

    public String createContainer();

    public CompletableFuture<DockerConsolePipe> showLog();

    public String computeInspectJson();

    public DockerSystemInfo getSystemInfo();

    public String computeProcessesJson();

    default public CompletableFuture<DockerTerminalPipe> attach() {
        return this.attach(false);
    }

    public CompletableFuture<DockerTerminalPipe> attach(boolean var1);

    default public CompletableFuture<DockerTerminalPipe> exec(String[] command) {
        return this.exec(command, false);
    }

    public CompletableFuture<DockerTerminalPipe> exec(String[] var1, boolean var2);

    public CompletableFuture<byte[]> captureExecOutput(String[] var1, boolean var2);

    public OngoingProcess pushImage(DockerAgentRepositoryConfig var1, DockerAgentProgressCallback var2);

    public ContainerUpdateResult updateContainer(DockerAgentContainerConfig var1);

    public DockerAgentContainerInspection inspect();

    public InputStream copyArchiveFromContainer(String var1);

    public void copyArchiveToContainer(String var1, String var2);

    public int waitForExit();

    public int waitForExitImmediate(CloudAgentErrorHandler var1);

    public String getImageUser();

    public void deleteContainerWithVolumes();

    public static interface ContainerUpdateResult {
        @NotNull
        public String getImageId();

        @Nullable
        public String getCreatedContainerId();

        @Nullable
        public DockerAgentApplication getCreatedAgentApplication();

        @Nullable
        public String getRemovedContainerId();
    }
}

