/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util;

import java.time.Duration;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/util/TimeoutTracker;", "", "timeout", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "delta", "getDelta", "()Ljava/time/Duration;", "isExpired", "", "()Z", "startTimeNs", "", "getTimeout", "getCurrentDeltaNs", "getCurrentTimeNs", "throwIfExpired", "", "message", "Lkotlin/Function0;", "", "intellij.rd.platform"})
public final class TimeoutTracker {
    private final long startTimeNs;
    @NotNull
    private final Duration timeout;

    public final boolean isExpired() {
        if (this.timeout.isNegative()) {
            return false;
        }
        return this.getCurrentDeltaNs() > this.timeout.toNanos();
    }

    public final void throwIfExpired(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.isExpired()) {
            throw (Throwable)new Exception((String)message.invoke());
        }
    }

    @NotNull
    public final Duration getDelta() {
        Duration duration = Duration.ofNanos(this.getCurrentDeltaNs());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofNanos(getCurrentDeltaNs())");
        return duration;
    }

    private final long getCurrentDeltaNs() {
        return this.getCurrentTimeNs() - this.startTimeNs;
    }

    private final long getCurrentTimeNs() {
        return System.nanoTime();
    }

    @NotNull
    public final Duration getTimeout() {
        return this.timeout;
    }

    public TimeoutTracker(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.timeout = timeout;
        boolean bl = this.timeout.toNanos() > 0L;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The number of nanoseconds (" + this.timeout.toNanos() + ") in timeout should be positive.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.startTimeNs = this.getCurrentTimeNs();
    }
}

