/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.util.CertificateExKt;
import com.jetbrains.rd.platform.util.SelfSignedCertificate;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/jetbrains/rd/platform/util/SelfSignedCertificate;", "", "()V", "KEY_ALIAS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "memoryOnlyCertificate", "", "permanentCertificateData", "Lcom/jetbrains/rd/platform/util/SelfSignedCertificate$SelfSignedCertificateData;", "getPermanentCertificateData", "()Lcom/jetbrains/rd/platform/util/SelfSignedCertificate$SelfSignedCertificateData;", "permanentCertificateData$delegate", "Lkotlin/Lazy;", "createAuthorityKeyId", "Lorg/bouncycastle/asn1/x509/AuthorityKeyIdentifier;", "publicKey", "Ljava/security/PublicKey;", "createSubjectKeyId", "Lorg/bouncycastle/asn1/x509/SubjectKeyIdentifier;", "generateNewCertificate", "keyPassword", "", "subjectName", "Lorg/bouncycastle/asn1/x500/X500Name;", "issuer", "Ljava/security/cert/X509Certificate;", "days", "", "getKeyStoreLocation", "Ljava/io/File;", "getOrCreateKeyStorePassword", "SelfSignedCertificateData", "intellij.rd.platform"})
public final class SelfSignedCertificate {
    private static final boolean memoryOnlyCertificate;
    @NotNull
    private static final Lazy permanentCertificateData$delegate;
    private static final String KEY_ALIAS = "codewithme";
    private static final Logger LOG;
    @NotNull
    public static final SelfSignedCertificate INSTANCE;

    private final char[] getOrCreateKeyStorePassword() {
        OneTimeString existingPassword;
        if (memoryOnlyCertificate) {
            LOG.info("Using memory only password for persistent certificate. Certificate won't be reused on the next run");
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string3.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            return cArray;
        }
        CredentialAttributes attributes = new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"Code With Me", (String)"Key Store Password"), "KeyStorePassword", null, false, 12, null);
        Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
        Object object = existingPassword = credentials != null ? credentials.getPassword() : null;
        if (existingPassword != null) {
            return OneTimeString.toCharArray$default((OneTimeString)existingPassword, (boolean)false, (int)1, null);
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String newPassword = string;
        PasswordSafe.Companion.getInstance().setPassword(attributes, newPassword);
        Credentials newCredentials = PasswordSafe.Companion.getInstance().get(attributes);
        if (newCredentials == null) {
            LOG.error("Unable to save Code With Me keystore password, attributes: " + attributes);
        } else if (Intrinsics.areEqual((Object)newCredentials.getPasswordAsString(), (Object)newPassword) ^ true) {
            LOG.error("Code With Me keystore password is different after get/set PasswordSafe round-trip");
        }
        String string4 = newPassword;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string5.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        return cArray;
    }

    private final File getKeyStoreLocation() {
        File file = PathManager.getConfigDir().resolve("codeWithMe").resolve("app.jks").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"PathManager.getConfigDir\u2026solve(\"app.jks\").toFile()");
        return file;
    }

    @NotNull
    public final SelfSignedCertificateData getPermanentCertificateData() {
        Lazy lazy = permanentCertificateData$delegate;
        SelfSignedCertificate selfSignedCertificate = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SelfSignedCertificateData)lazy.getValue();
    }

    @NotNull
    public final SelfSignedCertificateData generateNewCertificate(@NotNull char[] keyPassword, @NotNull X500Name subjectName, @Nullable X509Certificate issuer, int days) {
        X509Certificate[] x509CertificateArray;
        PublicKey publicKey;
        X500Principal issuerPrincipal;
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)subjectName, (String)"subjectName");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        boolean bl2 = false;
        KeyPairGenerator it = keyPairGenerator;
        boolean bl3 = false;
        it.initialize(2048);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        KeyPair subjectKeyPair = keyPairGenerator2.genKeyPair();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.now()");
        Instant now = instant;
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(Duration.ofDays(days)));
        X500Principal subjectPrincipal = new X500Principal(subjectName.getEncoded());
        BigInteger subjectSerial = BigInteger.valueOf(now.toEpochMilli());
        boolean isCA = issuer == null;
        X500Principal x500Principal = issuerPrincipal = issuer != null ? issuer.getSubjectX500Principal() : subjectPrincipal;
        if (issuer != null) {
            publicKey = issuer.getPublicKey();
        } else {
            KeyPair keyPair = subjectKeyPair;
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"subjectKeyPair");
            publicKey = keyPair.getPublic();
        }
        PublicKey issuerPublicKey = publicKey;
        X500Principal x500Principal2 = issuerPrincipal;
        Intrinsics.checkNotNullExpressionValue((Object)x500Principal2, (String)"issuerPrincipal");
        X500Name x500Name = X500Name.getInstance((Object)x500Principal2.getEncoded());
        X500Name x500Name2 = X500Name.getInstance((Object)subjectPrincipal.getEncoded());
        KeyPair keyPair = subjectKeyPair;
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"subjectKeyPair");
        PublicKey publicKey2 = keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"subjectKeyPair.public");
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, subjectSerial, notBefore, notAfter, Locale.ENGLISH, x500Name2, SubjectPublicKeyInfo.getInstance((Object)publicKey2.getEncoded()));
        PublicKey publicKey3 = subjectKeyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey3, (String)"subjectKeyPair.public");
        X509v3CertificateBuilder x509v3CertificateBuilder2 = x509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyId(publicKey3));
        PublicKey publicKey4 = issuerPublicKey;
        Intrinsics.checkNotNullExpressionValue((Object)publicKey4, (String)"issuerPublicKey");
        X509v3CertificateBuilder x509v3CertificateBuilder3 = x509v3CertificateBuilder2.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.createAuthorityKeyId(publicKey4)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isCA));
        Intrinsics.checkNotNullExpressionValue((Object)x509v3CertificateBuilder3, (String)"X509v3CertificateBuilder\u2026, BasicConstraints(isCA))");
        X509v3CertificateBuilder certificateBuilder = x509v3CertificateBuilder3;
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA512WithRSA").build(subjectKeyPair.getPrivate());
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
        Intrinsics.checkNotNull((Object)x509Certificate);
        X509Certificate certificate = x509Certificate;
        KeyStore keystore = KeyStore.getInstance("jks");
        keystore.load(null, null);
        if (issuer != null) {
            X509Certificate[] x509CertificateArray2 = new X509Certificate[2];
            x509CertificateArray2[0] = certificate;
            x509CertificateArray = x509CertificateArray2;
            x509CertificateArray2[1] = issuer;
        } else {
            X509Certificate[] x509CertificateArray3 = new X509Certificate[1];
            x509CertificateArray = x509CertificateArray3;
            x509CertificateArray3[0] = certificate;
        }
        X509Certificate[] chain = x509CertificateArray;
        keystore.setKeyEntry(KEY_ALIAS, subjectKeyPair.getPrivate(), keyPassword, chain);
        String string = CertificateExKt.getSha3Fingerprint(certificate);
        KeyStore keyStore = keystore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"keystore");
        return new SelfSignedCertificateData(certificate, string, keyStore, KEY_ALIAS, keyPassword);
    }

    private final SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo, (String)"SubjectPublicKeyInfo.get\u2026stance(publicKey.encoded)");
        SubjectPublicKeyInfo publicKeyInfo = subjectPublicKeyInfo;
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        Intrinsics.checkNotNullExpressionValue((Object)digestCalculator, (String)"BcDigestCalculatorProvid\u2026bjectIdentifiers.idSHA1))");
        DigestCalculator digCalc = digestCalculator;
        return new X509ExtensionUtils(digCalc).createSubjectKeyIdentifier(publicKeyInfo);
    }

    private final AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo, (String)"SubjectPublicKeyInfo.get\u2026stance(publicKey.encoded)");
        SubjectPublicKeyInfo publicKeyInfo = subjectPublicKeyInfo;
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        Intrinsics.checkNotNullExpressionValue((Object)digestCalculator, (String)"BcDigestCalculatorProvid\u2026bjectIdentifiers.idSHA1))");
        DigestCalculator digCalc = digestCalculator;
        return new X509ExtensionUtils(digCalc).createAuthorityKeyIdentifier(publicKeyInfo);
    }

    private SelfSignedCertificate() {
    }

    static {
        SelfSignedCertificate selfSignedCertificate;
        INSTANCE = selfSignedCertificate = new SelfSignedCertificate();
        String string = System.getProperty("codeWithMe.memory.only.certificate", "true");
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        boolean bl = false;
        memoryOnlyCertificate = Boolean.parseBoolean(string2);
        permanentCertificateData$delegate = LazyKt.lazy((Function0)permanentCertificateData.2.INSTANCE);
        Logger logger = Logger.getInstance(SelfSignedCertificate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(SelfS\u2026dCertificate::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ char[] access$getOrCreateKeyStorePassword(SelfSignedCertificate $this) {
        return $this.getOrCreateKeyStorePassword();
    }

    public static final /* synthetic */ File access$getKeyStoreLocation(SelfSignedCertificate $this) {
        return $this.getKeyStoreLocation();
    }

    public static final /* synthetic */ boolean access$getMemoryOnlyCertificate$p(SelfSignedCertificate $this) {
        SelfSignedCertificate selfSignedCertificate = $this;
        return memoryOnlyCertificate;
    }

    public static final /* synthetic */ Logger access$getLOG$p(SelfSignedCertificate $this) {
        SelfSignedCertificate selfSignedCertificate = $this;
        return LOG;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u000b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/util/SelfSignedCertificate$SelfSignedCertificateData;", "", "certificate", "Ljava/security/cert/X509Certificate;", "fingerprint", "", "keyStore", "Ljava/security/KeyStore;", "keyEntryAlias", "keyPassword", "", "(Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/security/KeyStore;Ljava/lang/String;[C)V", "getCertificate", "()Ljava/security/cert/X509Certificate;", "getFingerprint", "()Ljava/lang/String;", "getKeyEntryAlias", "getKeyPassword", "()[C", "getKeyStore", "()Ljava/security/KeyStore;", "intellij.rd.platform"})
    public static final class SelfSignedCertificateData {
        @NotNull
        private final X509Certificate certificate;
        @NotNull
        private final String fingerprint;
        @NotNull
        private final KeyStore keyStore;
        @NotNull
        private final String keyEntryAlias;
        @NotNull
        private final char[] keyPassword;

        @NotNull
        public final X509Certificate getCertificate() {
            return this.certificate;
        }

        @NotNull
        public final String getFingerprint() {
            return this.fingerprint;
        }

        @NotNull
        public final KeyStore getKeyStore() {
            return this.keyStore;
        }

        @NotNull
        public final String getKeyEntryAlias() {
            return this.keyEntryAlias;
        }

        @NotNull
        public final char[] getKeyPassword() {
            return this.keyPassword;
        }

        public SelfSignedCertificateData(@NotNull X509Certificate certificate, @NotNull String fingerprint, @NotNull KeyStore keyStore, @NotNull String keyEntryAlias, @NotNull char[] keyPassword) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
            Intrinsics.checkNotNullParameter((Object)keyEntryAlias, (String)"keyEntryAlias");
            Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
            this.certificate = certificate;
            this.fingerprint = fingerprint;
            this.keyStore = keyStore;
            this.keyEntryAlias = keyEntryAlias;
            this.keyPassword = keyPassword;
        }
    }
}

