/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import com.jetbrains.rd.platform.util.NetworkUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/platform/util/NetworkUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createHttpClientWithGoodDefaults", "Ljava/net/http/HttpClient;", "customizer", "Lkotlin/Function1;", "Ljava/net/http/HttpClient$Builder;", "", "getMacAddress", "", "getSelfAddresses", "", "Ljava/net/InetAddress;", "intellij.rd.platform"})
public final class NetworkUtils {
    private static final Logger LOG;
    @NotNull
    public static final NetworkUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InetAddress> getSelfAddresses() {
        try {
            void $this$filterTo$iv$iv;
            Object it;
            Iterable $this$flatMapTo$iv$iv;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"NetworkInterface.getNetworkInterfaces()");
            Enumeration<NetworkInterface> enumeration2 = enumeration;
            boolean bl = false;
            ArrayList<NetworkInterface> arrayList = Collections.list(enumeration2);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
            Iterable $this$flatMap$iv = arrayList;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Enumeration<InetAddress> enumeration3;
                it = (NetworkInterface)element$iv$iv;
                boolean bl2 = false;
                NetworkInterface networkInterface = it;
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"it");
                Intrinsics.checkNotNullExpressionValue(networkInterface.getInetAddresses(), (String)"it.inetAddresses");
                boolean bl3 = false;
                ArrayList<InetAddress> arrayList2 = Collections.list(enumeration3);
                Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"java.util.Collections.list(this)");
                Iterable list$iv$iv = arrayList2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (InetAddress)element$iv$iv;
                boolean bl4 = false;
                Object object = it;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                if (!(!((InetAddress)object).isLoopbackAddress() && !((InetAddress)it).isLinkLocalAddress())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                InetAddress it2 = (InetAddress)e$iv;
                boolean bl5 = false;
                InetAddress inetAddress = it2;
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"it");
                String key$iv = inetAddress.getHostAddress();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            Iterable $this$sortedBy$iv = list$iv;
            boolean $i$f$sortedBy = false;
            boolean bl6 = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    InetAddress it = (InetAddress)a;
                    boolean bl2 = false;
                    InetAddress inetAddress = it;
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"it");
                    it = (InetAddress)b;
                    Comparable comparable = (Comparable)((Object)inetAddress.getHostAddress());
                    bl2 = false;
                    InetAddress inetAddress2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"it");
                    String string = inetAddress2.getHostAddress();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Cannot get list of local interfaces", t);
            return CollectionsKt.emptyList();
        }
    }

    @Nullable
    public final byte[] getMacAddress() {
        getMacAddress.1 $fun$isGoodAddress$1 = getMacAddress.1.INSTANCE;
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        if (en != null) {
            while (en.hasMoreElements()) {
                byte[] address;
                NetworkInterface networkInterface;
                NetworkInterface networkInterface2 = networkInterface = en.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface2, (String)"networkInterface");
                if (networkInterface2.isLoopback() || !$fun$isGoodAddress$1.invoke(address = networkInterface.getHardwareAddress())) continue;
                return address;
            }
        }
        return null;
    }

    @NotNull
    public final HttpClient createHttpClientWithGoodDefaults(@NotNull Function1<? super HttpClient.Builder, Unit> customizer) {
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (ApplicationManager.getApplication() != null) {
            CertificateManager certificateManager = CertificateManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)certificateManager, (String)"CertificateManager.getInstance()");
            httpClientBuilder.sslContext(certificateManager.getSslContext());
        } else {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            httpClientBuilder.sslContext(sslContext);
        }
        httpClientBuilder.proxy((ProxySelector)CommonProxy.getInstance());
        HttpClient.Builder builder = httpClientBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"httpClientBuilder");
        customizer.invoke((Object)builder);
        HttpClient httpClient = httpClientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"httpClientBuilder.build()");
        return httpClient;
    }

    public static /* synthetic */ HttpClient createHttpClientWithGoodDefaults$default(NetworkUtils networkUtils, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = createHttpClientWithGoodDefaults.1.INSTANCE;
        }
        return networkUtils.createHttpClientWithGoodDefaults((Function1<? super HttpClient.Builder, Unit>)function1);
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
        Logger logger = Logger.getInstance(networkUtils.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        LOG = logger;
    }
}

