/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.internal.widgets;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.platform.internal.widgets.InternalConsoleWidget;
import com.jetbrains.rd.platform.internal.widgets.InternalWidget;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\n\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0004J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rd/platform/internal/widgets/InternalConsoleWidget;", "Lcom/jetbrains/rd/platform/internal/widgets/InternalWidget;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "flushEvent", "com/jetbrains/rd/platform/internal/widgets/InternalConsoleWidget$flushEvent$1", "Lcom/jetbrains/rd/platform/internal/widgets/InternalConsoleWidget$flushEvent$1;", "logBuffer", "Ljava/lang/StringBuffer;", "getLogBuffer", "()Ljava/lang/StringBuffer;", "logBufferLock", "Ljava/lang/Object;", "getLogBufferLock", "()Ljava/lang/Object;", "loggerFlushQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "timeFormatter", "Ljava/text/SimpleDateFormat;", "build", "Ljavax/swing/JPanel;", "clear", "", "log", "line", "", "timestamp", "", "logWithTime", "toolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.rd.platform"})
public abstract class InternalConsoleWidget
extends InternalWidget {
    @NotNull
    private final StringBuffer logBuffer;
    @NotNull
    private final Object logBufferLock;
    private final MergingUpdateQueue loggerFlushQueue;
    private final ConsoleViewImpl console;
    private final flushEvent.1 flushEvent;
    private final SimpleDateFormat timeFormatter;
    @NotNull
    private final Project project;

    @NotNull
    public final StringBuffer getLogBuffer() {
        return this.logBuffer;
    }

    @NotNull
    public final Object getLogBufferLock() {
        return this.logBufferLock;
    }

    public final void logWithTime(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.log(line, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(@NotNull String line, boolean timestamp) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Object object = this.logBufferLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            String time = this.timeFormatter.format(new Date());
            if (timestamp) {
                this.logBuffer.append(time + ": " + line + '\n');
            } else {
                this.logBuffer.append(line + '\n');
            }
            this.loggerFlushQueue.queue((Update)this.flushEvent);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void log$default(InternalConsoleWidget internalConsoleWidget, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        internalConsoleWidget.log(string, bl);
    }

    protected final void clear() {
        this.console.clear();
    }

    @Override
    @NotNull
    protected JPanel build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.add((Component)this.console.getComponent(), "Center");
        Editor editor = this.console.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"console.editor");
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"console.editor.settings");
        editorSettings.setCaretRowShown(true);
        return jPanel;
    }

    @Override
    @NotNull
    public List<AnAction> toolbarActions() {
        Object[] objectArray = this.console.createConsoleActions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"console.createConsoleActions()");
        return ArraysKt.drop((Object[])objectArray, (int)2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public InternalConsoleWidget(@NotNull Lifetime lifetime2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(lifetime2);
        this.project = project;
        this.logBuffer = new StringBuffer();
        this.logBufferLock = new Object();
        this.loggerFlushQueue = new MergingUpdateQueue("loggerFlushQueue", 200, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.project, null, true).setRestartTimerOnAdd(false);
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026  .createBuilder(project)");
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        if (consoleView == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        }
        this.console = (ConsoleViewImpl)consoleView;
        this.flushEvent = new Update(this, lifetime2, "logFlushEvent"){
            final /* synthetic */ InternalConsoleWidget this$0;
            final /* synthetic */ Lifetime $lifetime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = this.this$0.getLogBufferLock();
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                        InternalConsoleWidget.access$getConsole$p(this.this$0).print(this.this$0.getLogBuffer().toString(), ConsoleViewContentType.NORMAL_OUTPUT);
                        this.this$0.getLogBuffer().setLength(0);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = this$0;
                this.$lifetime = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        this.timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
        RLifetimeKt.onTermination((Lifetime)lifetime2, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                console.dispose();
            }
        }));
    }
}

