/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import com.jetbrains.rd.platform.util.NetworkUtilsKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/SupportInformationUploader;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "uploadsServiceUrl", "", "uploadFile", "Ljava/net/URI;", "file", "Ljava/io/File;", "fileName", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.rd.platform"})
public final class SupportInformationUploader {
    private static final String uploadsServiceUrl = "https://uploads.jetbrains.com";
    private static final ObjectMapper objectMapper;
    @NotNull
    public static final SupportInformationUploader INSTANCE;

    @NotNull
    public final URI uploadFile(@NotNull File file, @NotNull String fileName, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String urlWithoutSlash = StringsKt.trimEnd((String)uploadsServiceUrl, (char[])new char[]{'/'});
        ObjectNode responseJson2 = (ObjectNode)HttpRequests.post((String)(urlWithoutSlash + "/sign"), (String)"application/json; charset=utf-8").accept("application/json; charset=utf-8").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<ObjectNode>(fileName){
            final /* synthetic */ String $fileName;

            public final ObjectNode process(@NotNull HttpRequests.Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
                boolean bl = false;
                boolean bl2 = false;
                ObjectNode $this$apply = objectNode;
                boolean bl3 = false;
                $this$apply.put("filename", this.$fileName);
                $this$apply.put("method", "put");
                $this$apply.put("contentType", "application/octet-stream");
                ObjectNode requestJson = objectNode;
                request.write(requestJson.toPrettyString());
                JsonNode jsonNode = SupportInformationUploader.access$getObjectMapper$p(SupportInformationUploader.INSTANCE).readTree((Reader)request.getReader());
                if (jsonNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                }
                return (ObjectNode)jsonNode;
            }
            {
                this.$fileName = string;
            }
        });
        String uploadUrl = responseJson2.get("url").asText();
        String folderName = responseJson2.get("folderName").asText();
        JsonNode jsonNode = responseJson2.get("headers");
        if (jsonNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        ObjectNode headers = (ObjectNode)jsonNode;
        HttpRequests.put((String)uploadUrl, (String)"application/octet-stream").productNameAsUserAgent().tuner(new HttpRequests.ConnectionTuner(headers){
            final /* synthetic */ ObjectNode $headers;

            public final void tune(@NotNull URLConnection urlConnection) {
                Intrinsics.checkNotNullParameter((Object)urlConnection, (String)"urlConnection");
                Iterator iterator = this.$headers.fields();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"headers.fields()");
                Iterator $this$forEach$iv = iterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    E element$iv = iterator3.next();
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    urlConnection.addRequestProperty((String)it.getKey(), ((JsonNode)it.getValue()).asText());
                }
            }
            {
                this.$headers = objectNode;
            }
        }).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Integer>(file, indicator){
            final /* synthetic */ File $file;
            final /* synthetic */ ProgressIndicator $indicator;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Integer process(@NotNull HttpRequests.Request it) {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                URLConnection uRLConnection = it.getConnection();
                if (uRLConnection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                HttpURLConnection http = (HttpURLConnection)uRLConnection;
                int length = (int)this.$file.length();
                http.setFixedLengthStreamingMode(length);
                Closeable closeable = http.getOutputStream();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    int n2;
                    OutputStream outputStream = (OutputStream)closeable;
                    boolean bl3 = false;
                    Object object = this.$file;
                    int n3 = 0;
                    object = new FileInputStream((File)object);
                    n3 = 65536;
                    boolean bl4 = false;
                    object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n3);
                    n3 = 0;
                    bl4 = false;
                    Throwable throwable2 = null;
                    try {
                        BufferedInputStream inputStream = (BufferedInputStream)object;
                        boolean bl5 = false;
                        n2 = NetUtils.copyStreamContent((ProgressIndicator)this.$indicator, (InputStream)inputStream, (OutputStream)outputStream, (int)length);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                    n = n2;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return n;
            }
            {
                this.$file = file;
                this.$indicator = progressIndicator;
            }
        });
        return NetworkUtilsKt.withFragment(new URI(urlWithoutSlash + "/browse"), folderName);
    }

    private SupportInformationUploader() {
    }

    static {
        SupportInformationUploader supportInformationUploader;
        INSTANCE = supportInformationUploader = new SupportInformationUploader();
        objectMapper = ExtensionsKt.jacksonObjectMapper();
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(SupportInformationUploader $this) {
        SupportInformationUploader supportInformationUploader = $this;
        return objectMapper;
    }
}

