/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.lang.ProtocolLanguageAssociationBean;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/lang/ProtocolLanguageManagerImpl;", "Lcom/jetbrains/rd/lang/ProtocolLanguageManager;", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/lang/ProtocolLanguageAssociationBean;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "backendToFrontendLanguageCache", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/RdLanguage;", "", "Lkotlin/collections/HashMap;", "frontendToBackendLanguageCache", "addAssociation", "", "backendLanguageId", "frontendLanguageId", "default", "", "toIdeaLanguage", "Lcom/intellij/lang/Language;", "rdLanguage", "toRdLanguage", "language", "intellij.rd.platform"})
public final class ProtocolLanguageManagerImpl
implements ProtocolLanguageManager {
    private final ExtensionPointName<ProtocolLanguageAssociationBean> EP_NAME;
    private final HashMap<RdLanguage, String> backendToFrontendLanguageCache;
    private final HashMap<String, RdLanguage> frontendToBackendLanguageCache;

    @Override
    @Nullable
    public RdLanguage toRdLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.frontendToBackendLanguageCache.get(language.getID());
    }

    @Override
    @Nullable
    public Language toIdeaLanguage(@NotNull RdLanguage rdLanguage) {
        Object v3;
        String frontendLanguageId;
        block5: {
            Intrinsics.checkNotNullParameter((Object)rdLanguage, (String)"rdLanguage");
            frontendLanguageId = this.backendToFrontendLanguageCache.get(rdLanguage);
            if (frontendLanguageId != null) {
                Language frontendLanguage = Language.findLanguageByID((String)frontendLanguageId);
                if (frontendLanguage == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ProtocolLanguageManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error("Unable to find '" + frontendLanguageId + "'. Possibly it's incorrect or com.intellij.lang.Language is not initialized");
                }
                return frontendLanguage;
            }
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Language.getRegisteredLanguages()");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Language it = (Language)t;
                boolean bl3 = false;
                Language language = it;
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"it");
                if (!StringsKt.equals((String)language.getID(), (String)rdLanguage.getName(), (boolean)true)) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        Language language = v3;
        if (language == null) {
            return null;
        }
        Language foundLanguage = language;
        frontendLanguageId = foundLanguage.getID();
        ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, frontendLanguageId);
        if (!this.frontendToBackendLanguageCache.containsKey(frontendLanguageId)) {
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, rdLanguage);
        }
        return foundLanguage;
    }

    @Override
    public void addAssociation(@NotNull String backendLanguageId, @NotNull String frontendLanguageId, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)backendLanguageId, (String)"backendLanguageId");
        Intrinsics.checkNotNullParameter((Object)frontendLanguageId, (String)"frontendLanguageId");
        if (bl) {
            RdLanguage rdLanguage = new RdLanguage(backendLanguageId);
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, rdLanguage);
            ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, frontendLanguageId);
            return;
        }
        RdLanguage backendLanguage = new RdLanguage(backendLanguageId);
        if (!this.frontendToBackendLanguageCache.containsKey(frontendLanguageId)) {
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, backendLanguage);
        }
        if (!this.backendToFrontendLanguageCache.containsKey(backendLanguage)) {
            ((Map)this.backendToFrontendLanguageCache).put(backendLanguage, frontendLanguageId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ProtocolLanguageManagerImpl() {
        void $this$forEachLoggingErrors$iv;
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.rd.languageAssociation");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026.rd.languageAssociation\")");
        this.EP_NAME = extensionPointName;
        boolean bl = false;
        this.backendToFrontendLanguageCache = new HashMap();
        bl = false;
        this.frontendToBackendLanguageCache = new HashMap();
        List list = this.EP_NAME.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.extensionList");
        Collection collection = list;
        Logger logger$iv = ProtocolLanguageManager.Companion.getLogger();
        boolean $i$f$forEachLoggingErrors = false;
        Sequence $this$forEachLoggingErrors$iv$iv = CollectionsKt.asSequence((Iterable)((Iterable)$this$forEachLoggingErrors$iv));
        boolean $i$f$forEachLoggingErrors2 = false;
        Sequence $this$forEach$iv$iv$iv = $this$forEachLoggingErrors$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object it$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            try {
                ProtocolLanguageAssociationBean it = (ProtocolLanguageAssociationBean)((Object)it$iv$iv);
                boolean bl3 = false;
                String string = it.getBackendLanguage();
                Intrinsics.checkNotNull((Object)string);
                String string2 = it.getFrontendLanguage();
                Intrinsics.checkNotNull((Object)string2);
                this.addAssociation(string, string2, it.isDefault());
            }
            catch (Throwable e$iv$iv) {
                logger$iv.error(e$iv$iv);
            }
        }
    }

    @Override
    public void addAssociation(@NotNull String backendLanguageId, @NotNull String frontendLanguageId) {
        Intrinsics.checkNotNullParameter((Object)backendLanguageId, (String)"backendLanguageId");
        Intrinsics.checkNotNullParameter((Object)frontendLanguageId, (String)"frontendLanguageId");
        ProtocolLanguageManager.DefaultImpls.addAssociation(this, backendLanguageId, frontendLanguageId);
    }
}

