/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.requests;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdClipboardChange;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdEditorFeatureStep;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchStep;
import com.jetbrains.rd.ide.model.RdTransparentEditorChange;
import com.jetbrains.rd.ide.model.TextControlId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u001e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tJ\u001e\u0010%\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020&2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eJ\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0013H\u0002J&\u0010(\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020)2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000eJ&\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rd/ide/requests/PatchBuilder;", "", "()V", "changes", "", "Lcom/jetbrains/rd/ide/model/RdPatchStep;", "disableCaretShiftOnWhitespace", "", "expectedClipboardVersion", "", "Ljava/lang/Integer;", "expectedDocumentVersions", "", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "expectedEditorVersions", "Lcom/jetbrains/rd/ide/model/TextControlId;", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "features", "Lcom/jetbrains/rd/ide/model/RdEditorFeatureStep;", "initialCaretStateHint", "Lcom/jetbrains/rd/ide/model/RdCaretStateSnapshot;", "primaryEditor", "Lcom/intellij/openapi/editor/Editor;", "updatedClipboardVersion", "updatedDocumentVersions", "updatedEditorVersions", "build", "Lcom/jetbrains/rd/ide/model/RdPatch;", "pushChangeStep", "", "step", "pushClipboardChange", "change", "Lcom/jetbrains/rd/ide/model/RdClipboardChange;", "oldVersion", "newVersion", "pushDocumentStep", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "pushEditorFeatureStep", "pushEditorStep", "Lcom/jetbrains/rd/ide/model/RdEditorChange;", "documentVersion", "pushInitialSelectionHintAndEditorVersion", "editorId", "editor", "editorVersion", "intellij.rd.platform"})
public final class PatchBuilder {
    private final List<RdPatchStep> changes;
    private final List<RdEditorFeatureStep> features;
    private final Map<RdDocumentId, RdDocumentVersion> expectedDocumentVersions;
    private final Map<TextControlId, RdEditorVersion> expectedEditorVersions;
    private final Map<TextControlId, RdEditorVersion> updatedEditorVersions;
    private final Map<RdDocumentId, RdDocumentVersion> updatedDocumentVersions;
    private RdCaretStateSnapshot initialCaretStateHint;
    private Integer expectedClipboardVersion;
    private Integer updatedClipboardVersion;
    private Editor primaryEditor;
    private boolean disableCaretShiftOnWhitespace;

    @Nullable
    public final RdPatch build() {
        if (this.changes.isEmpty() && this.features.isEmpty()) {
            return null;
        }
        List<RdEditorFeatureStep> nullableFeatures = this.features.isEmpty() ? null : this.features;
        return new RdPatch(this.changes, nullableFeatures, this.initialCaretStateHint, this.disableCaretShiftOnWhitespace, CollectionsKt.toList((Iterable)this.expectedDocumentVersions.keySet()), CollectionsKt.toList((Iterable)this.updatedDocumentVersions.keySet()), CollectionsKt.toList((Iterable)this.expectedDocumentVersions.values()), CollectionsKt.toList((Iterable)this.updatedDocumentVersions.values()), CollectionsKt.toList((Iterable)this.expectedEditorVersions.keySet()), CollectionsKt.toList((Iterable)this.updatedEditorVersions.keySet()), CollectionsKt.toList((Iterable)this.expectedEditorVersions.values()), CollectionsKt.toList((Iterable)this.updatedEditorVersions.values()), this.expectedClipboardVersion, this.updatedClipboardVersion);
    }

    public final void pushInitialSelectionHintAndEditorVersion(@NotNull TextControlId editorId, @NotNull Editor editor, @NotNull RdEditorVersion editorVersion, @NotNull RdDocumentVersion documentVersion) {
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorVersion, (String)"editorVersion");
        Intrinsics.checkNotNullParameter((Object)documentVersion, (String)"documentVersion");
        this.primaryEditor = editor;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        RdCaretState caretState = UtilKt.createModelCaretState(caretModel);
        this.expectedEditorVersions.putIfAbsent(editorId, editorVersion);
        this.expectedDocumentVersions.putIfAbsent(editorId.getDocumentId(), documentVersion);
        this.initialCaretStateHint = new RdCaretStateSnapshot(caretState, editorId);
    }

    @NotNull
    public final PatchBuilder pushEditorStep(@NotNull RdEditorChange step, @NotNull RdEditorVersion oldVersion, @NotNull RdEditorVersion newVersion, @NotNull RdDocumentVersion documentVersion) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Intrinsics.checkNotNullParameter((Object)documentVersion, (String)"documentVersion");
        TextControlId editorId = step.getEditorId();
        this.expectedEditorVersions.putIfAbsent(editorId, oldVersion);
        this.expectedDocumentVersions.putIfAbsent(editorId.getDocumentId(), documentVersion);
        if (Intrinsics.areEqual((Object)oldVersion, (Object)newVersion) ^ true) {
            boolean bl = !(step instanceof RdTransparentEditorChange);
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.updatedEditorVersions.put(editorId, newVersion);
        }
        if (step instanceof RdEditorFeatureStep) {
            this.pushEditorFeatureStep((RdEditorFeatureStep)step);
        } else {
            this.pushChangeStep((RdPatchStep)step);
        }
        return this;
    }

    @NotNull
    public final PatchBuilder pushDocumentStep(@NotNull RdDocumentChange step, @NotNull RdDocumentVersion oldVersion, @NotNull RdDocumentVersion newVersion) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        boolean bl = Intrinsics.areEqual((Object)oldVersion, (Object)newVersion) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object object = this.primaryEditor;
        this.disableCaretShiftOnWhitespace = object != null && (object = (Boolean)object.getUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION)) != null ? (Boolean)object : false;
        RdDocumentId documentId = step.getDocumentId();
        this.expectedDocumentVersions.putIfAbsent(documentId, oldVersion);
        this.updatedDocumentVersions.put(documentId, newVersion);
        this.pushChangeStep((RdPatchStep)step);
        return this;
    }

    @NotNull
    public final PatchBuilder pushClipboardChange(@NotNull RdClipboardChange change, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (this.expectedClipboardVersion == null) {
            this.expectedClipboardVersion = oldVersion;
        }
        if (oldVersion != newVersion) {
            this.updatedClipboardVersion = newVersion;
        }
        this.pushChangeStep((RdPatchStep)change);
        return this;
    }

    private final void pushEditorFeatureStep(RdEditorFeatureStep change) {
        this.features.add(change);
    }

    private final void pushChangeStep(RdPatchStep step) {
        this.changes.add(step);
    }

    public PatchBuilder() {
        boolean bl = false;
        this.changes = new ArrayList();
        bl = false;
        this.features = new ArrayList();
        bl = false;
        this.expectedDocumentVersions = new LinkedHashMap();
        bl = false;
        this.expectedEditorVersions = new LinkedHashMap();
        bl = false;
        this.updatedEditorVersions = new LinkedHashMap();
        bl = false;
        this.updatedDocumentVersions = new LinkedHashMap();
    }
}

