/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor.markup;

import com.intellij.openapi.util.Segment;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040\rJ(\u0010\u000f\u001a\u00020\u0010*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00112\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00112\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/ide/editor/markup/HighlighterTextAnnotator;", "", "()V", "annotateWithTags", "", "TRange", "Lcom/intellij/openapi/util/Segment;", "text", "ranges", "", "comparator", "Ljava/util/Comparator;", "rangeTagNamePrinter", "Lkotlin/Function1;", "additionalTextProvider", "calculateAbsoluteOffset", "", "Ljava/util/TreeMap;", "currentOffset", "isStartTag", "", "updateOffset", "", "index", "value", "intellij.rd.platform"})
public final class HighlighterTextAnnotator {
    @NotNull
    public static final HighlighterTextAnnotator INSTANCE;

    @NotNull
    public final <TRange extends Segment> String annotateWithTags(@NotNull String text, @NotNull Iterable<? extends TRange> ranges, @NotNull Comparator<TRange> comparator, @NotNull Function1<? super TRange, String> rangeTagNamePrinter, @NotNull Function1<? super TRange, String> additionalTextProvider) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Intrinsics.checkNotNullParameter(rangeTagNamePrinter, (String)"rangeTagNamePrinter");
        Intrinsics.checkNotNullParameter(additionalTextProvider, (String)"additionalTextProvider");
        List sortedHighlighters = CollectionsKt.sortedWith(ranges, comparator);
        TreeMap<Integer, Integer> offsetMap = new TreeMap<Integer, Integer>();
        StringBuilder result = new StringBuilder(text);
        for (Segment range : sortedHighlighters) {
            String tag;
            if ((String)rangeTagNamePrinter.invoke((Object)range) == null) {
                continue;
            }
            Object object = additionalTextProvider.invoke((Object)range);
            boolean bl = false;
            boolean bl2 = false;
            String it = (String)object;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            boolean bl5 = false;
            String additionalText = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? ' ' + it : "";
            int start = this.calculateAbsoluteOffset(offsetMap, range.getStartOffset(), true);
            String startTag = '<' + tag + additionalText + '>';
            result.insert(start, startTag);
            this.updateOffset(offsetMap, range.getStartOffset(), startTag.length());
            if (range.getStartOffset() == range.getEndOffset()) continue;
            int end = this.calculateAbsoluteOffset(offsetMap, range.getEndOffset(), false);
            String endTag = "</" + tag + '>';
            result.insert(end, endTag);
            this.updateOffset(offsetMap, range.getEndOffset(), endTag.length());
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final void updateOffset(TreeMap<Integer, Integer> $this$updateOffset, int index, int value) {
        Integer n = $this$updateOffset.get(index);
        if (n == null) {
            n = 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"this[index] ?: 0");
        int current = n;
        ((Map)$this$updateOffset).put(index, current + value);
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateAbsoluteOffset(TreeMap<Integer, Integer> $this$calculateAbsoluteOffset, int currentOffset, boolean isStartTag) {
        int absoluteOffset = currentOffset;
        int currentOffset2 = isStartTag ? currentOffset : currentOffset - 1;
        Map map = $this$calculateAbsoluteOffset;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void offset;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            int n = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl2 = false;
            int delta = ((Number)entry2.getValue()).intValue();
            if (offset > currentOffset2) break;
            absoluteOffset += delta;
        }
        return absoluteOffset;
    }

    private HighlighterTextAnnotator() {
    }

    static {
        HighlighterTextAnnotator highlighterTextAnnotator;
        INSTANCE = highlighterTextAnnotator = new HighlighterTextAnnotator();
    }
}

