/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.editor.UtilKt$WhenMappings;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.model.ScrollKind;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e\u001a \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e\u001a\r\u0010\"\u001a\u00020\u001c*\u00020#H\u0086\u0002\u001a\u000f\u0010\"\u001a\u00020\u001c*\u0004\u0018\u00010\u001fH\u0086\u0002\u001a\r\u0010$\u001a\u00020\u001c*\u00020#H\u0086\u0002\u001a\u000f\u0010$\u001a\u00020\u001c*\u0004\u0018\u00010\u001fH\u0086\u0002\u001a\n\u0010%\u001a\u00020\u001a*\u00020&\u001a\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(*\u00020&\u001a%\u0010)\u001a\u00020\f*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001c2\u000e\b\u0004\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0082\b\u001a\u0014\u0010,\u001a\u00020\u001f*\u00020\u000e2\u0006\u0010-\u001a\u00020\fH\u0002\u001a\u0014\u0010.\u001a\u00020/*\u00020\u000e2\b\u00100\u001a\u0004\u0018\u000101\u001a\n\u00102\u001a\u000203*\u000203\u001a\n\u00102\u001a\u000204*\u000204\u001a\n\u00105\u001a\u000206*\u00020\f\u001a\n\u00105\u001a\u000206*\u00020\u0012\u001a\n\u00105\u001a\u000206*\u00020\u0001\u001a\n\u00105\u001a\u000206*\u00020\u001a\u001a\n\u00105\u001a\u000206*\u00020\u0016\u001a\n\u00105\u001a\u000206*\u000207\u001a\n\u00108\u001a\u000209*\u00020:\"3\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006;"}, d2={"<set-?>", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "id", "Lcom/intellij/openapi/editor/Caret;", "getId", "(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", "setId", "(Lcom/intellij/openapi/editor/Caret;Lcom/jetbrains/rd/ide/model/RdCaretId;)V", "id$delegate", "Lkotlin/properties/ReadWriteProperty;", "addCaretTo", "positionModel", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isPrimary", "", "caret", "Lcom/jetbrains/rd/ide/model/RdCaret;", "applySelectionTo", "", "selectionModel", "Lcom/jetbrains/rd/ide/model/RdSelection;", "caretToSync", "applyStateTo", "newState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "calcVirtualDelta", "", "offset", "visualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "calculateVisibleRange", "Lcom/jetbrains/rd/ide/model/VisibleRange;", "component1", "Lcom/intellij/openapi/editor/LogicalPosition;", "component2", "createModelCaretState", "Lcom/intellij/openapi/editor/CaretModel;", "createModelCarets", "", "createModelPosition", "calcVisualPosition", "Lkotlin/Function0;", "docOffsetAndVirtualToVisualPosition", "pos", "getDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "reverse", "Lcom/jetbrains/rd/ide/model/RdCaretStateChange;", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "toDebugString", "", "Lcom/jetbrains/rd/ide/model/TextControlId;", "toScrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Lcom/jetbrains/rd/ide/model/ScrollKind;", "intellij.rd.platform"})
public final class UtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private static final ReadWriteProperty id$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(UtilKt.class, "id", "getId(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", 1))};
        id$delegate = UserDataHolderKt.userData();
    }

    @Nullable
    public static final RdCaretId getId(@NotNull Caret $this$id) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"$this$id");
        return (RdCaretId)id$delegate.getValue((Object)$this$id, $$delegatedProperties[0]);
    }

    public static final void setId(@NotNull Caret $this$id, @Nullable RdCaretId rdCaretId) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"$this$id");
        id$delegate.setValue((Object)$this$id, $$delegatedProperties[0], (Object)rdCaretId);
    }

    @NotNull
    public static final ScrollType toScrollType(@NotNull ScrollKind $this$toScrollType) {
        ScrollType scrollType;
        Intrinsics.checkNotNullParameter((Object)$this$toScrollType, (String)"$this$toScrollType");
        switch (UtilKt$WhenMappings.$EnumSwitchMapping$0[$this$toScrollType.ordinal()]) {
            case 1: {
                scrollType = ScrollType.MAKE_VISIBLE;
                break;
            }
            case 2: {
                scrollType = ScrollType.RELATIVE;
                break;
            }
            case 3: {
                scrollType = ScrollType.CENTER;
                break;
            }
            case 4: {
                scrollType = ScrollType.CENTER_DOWN;
                break;
            }
            case 5: {
                scrollType = ScrollType.CENTER_UP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return scrollType;
    }

    private static final VisualPosition docOffsetAndVirtualToVisualPosition(Editor $this$docOffsetAndVirtualToVisualPosition, DocOffsetAndVirtualModel pos) {
        boolean bl = pos.getVirtualDelta() >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = $this$docOffsetAndVirtualToVisualPosition.offsetToVisualPosition(pos.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(pos.offset)");
        VisualPosition vPos = visualPosition;
        return pos.getVirtualDelta() == 0 ? vPos : new VisualPosition(vPos.line, vPos.column + pos.getVirtualDelta(), vPos.leansRight);
    }

    @NotNull
    public static final VisibleRange calculateVisibleRange(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ProperTextRange properTextRange = VisibleHighlightingPassFactory.calculateVisibleRange((Editor)editor);
        Intrinsics.checkNotNullExpressionValue((Object)properTextRange, (String)"VisibleHighlightingPassF\u2026ulateVisibleRange(editor)");
        ProperTextRange visibleRange = properTextRange;
        return new VisibleRange(visibleRange.getStartOffset(), visibleRange.getEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    public static final void applyStateTo(@NotNull RdCaretState newState, @NotNull Editor editor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$map$iv = newState.getCarets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LogicalPosition selectionEnd;
            LogicalPosition selectionStart;
            LogicalPosition caretPosition;
            void caret;
            RdCaret rdCaret = (RdCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToLogicalPosition(caret.getOffset().getOffset()), (String)"editor.offsetToLogicalPo\u2026tion(caret.offset.offset)");
            Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToLogicalPosition(caret.getSelection().getStart().getOffset()), (String)"editor.offsetToLogicalPo\u2026t.selection.start.offset)");
            Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToLogicalPosition(caret.getSelection().getEnd().getOffset()), (String)"editor.offsetToLogicalPo\u2026ret.selection.end.offset)");
            CaretState caretState = new CaretState(caretPosition, caret.getOffset().getVirtualDelta(), selectionStart, selectionEnd);
            collection.add(caretState);
        }
        List states = (List)destination$iv$iv;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        caretModel.setCaretsAndSelections(states);
        for (RdCaret newCaret : newState.getCarets()) {
            Caret caret;
            VisualPosition visualPosition = UtilKt.docOffsetAndVirtualToVisualPosition(editor, newCaret.getOffset());
            if (editor.getCaretModel().getCaretAt(visualPosition) == null) {
                String string = "Cannot find caret at " + visualPosition;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.getCar\u2026aret at $visualPosition\")");
            UtilKt.setId(caret, newCaret.getId());
            if (!Intrinsics.areEqual((Object)newCaret.getId(), (Object)newState.getPrimaryCaretId())) continue;
            CaretModel caretModel2 = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
            if (caretModel2.getPrimaryCaret() == caret) continue;
            editor.getCaretModel().removeCaret(caret);
            UtilKt.addCaretTo(newCaret, editor, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void applySelectionTo(@NotNull RdSelection selectionModel, @NotNull Caret caretToSync, @NotNull Editor editor) {
        void endOffset;
        void startOffset;
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)caretToSync, (String)"caretToSync");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        DocOffsetAndVirtualModel docOffsetAndVirtualModel = selectionModel.getStart();
        int n = docOffsetAndVirtualModel.component1();
        int startVDelta = docOffsetAndVirtualModel.component2();
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2 = selectionModel.getEnd();
        int n2 = docOffsetAndVirtualModel2.component1();
        int endVDelta = docOffsetAndVirtualModel2.component2();
        if (startVDelta > 0 || endVDelta > 0) {
            VisualPosition startVPos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getStart());
            VisualPosition endVPos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getEnd());
            caretToSync.setSelection(startVPos, (int)startOffset, endVPos, (int)endOffset);
        } else {
            caretToSync.setSelection((int)startOffset, (int)endOffset);
        }
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull RdCaret caret, @NotNull Editor editor, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Caret caret2 = UtilKt.addCaretTo(caret.getOffset(), editor, isPrimary);
        if (caret2 == null) {
            return null;
        }
        Caret caretToSync = caret2;
        UtilKt.applySelectionTo(caret.getSelection(), caretToSync, editor);
        UtilKt.setId(caretToSync, caret.getId());
        return caretToSync;
    }

    public static /* synthetic */ Caret addCaretTo$default(RdCaret rdCaret, Editor editor, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(rdCaret, editor, bl);
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull DocOffsetAndVirtualModel positionModel, @NotNull Editor editor, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)positionModel, (String)"positionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VisualPosition pos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, positionModel);
        return editor.getCaretModel().addCaret(pos, isPrimary);
    }

    public static /* synthetic */ Caret addCaretTo$default(DocOffsetAndVirtualModel docOffsetAndVirtualModel, Editor editor, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(docOffsetAndVirtualModel, editor, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RdCaret> createModelCarets(@NotNull CaretModel $this$createModelCarets) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createModelCarets, (String)"$this$createModelCarets");
        List list = $this$createModelCarets.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allCarets");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RdCaretId id;
            DocOffsetAndVirtualModel docOffsetAndVirtualModel;
            void $this$createModelPosition$iv;
            DocOffsetAndVirtualModel docOffsetAndVirtualModel2;
            void $this$createModelPosition$iv2;
            DocOffsetAndVirtualModel docOffsetAndVirtualModel3;
            void $this$createModelPosition$iv3;
            void caret;
            Caret caret2 = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = caret;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"caret");
            if (UtilKt.getId((Caret)v1) == null) {
                String string = "Caret has no ID assigned";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            void var11_11 = caret;
            int offset$iv22 = caret.getOffset();
            boolean $i$f$createModelPosition = false;
            Editor editor = $this$createModelPosition$iv3.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            boolean isInBulkUpdate$iv = document.isInBulkUpdate();
            if (isInBulkUpdate$iv) {
                docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel(offset$iv22, 0);
            } else {
                VisualPosition position$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)caret.getVisualPosition(), (String)"caret.visualPosition");
                Editor editor2 = $this$createModelPosition$iv3.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
                int virtualDelta$iv = UtilKt.calcVirtualDelta(editor2, offset$iv22, position$iv);
                docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel(offset$iv22, virtualDelta$iv);
            }
            DocOffsetAndVirtualModel offset = docOffsetAndVirtualModel3;
            void offset$iv22 = caret;
            int offset$iv32 = caret.getSelectionStart();
            boolean $i$f$createModelPosition2 = false;
            Editor editor3 = $this$createModelPosition$iv2.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
            Document document2 = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
            boolean isInBulkUpdate$iv2 = document2.isInBulkUpdate();
            if (isInBulkUpdate$iv2) {
                docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel(offset$iv32, 0);
            } else {
                VisualPosition position$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)caret.getSelectionStartPosition(), (String)"caret.selectionStartPosition");
                Editor editor4 = $this$createModelPosition$iv2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"editor");
                int virtualDelta$iv = UtilKt.calcVirtualDelta(editor4, offset$iv32, position$iv);
                docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel(offset$iv32, virtualDelta$iv);
            }
            DocOffsetAndVirtualModel startPos = docOffsetAndVirtualModel2;
            void offset$iv32 = caret;
            int offset$iv = caret.getSelectionEnd();
            boolean $i$f$createModelPosition3 = false;
            Editor editor5 = $this$createModelPosition$iv.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor5, (String)"editor");
            Document document3 = editor5.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"editor.document");
            boolean isInBulkUpdate$iv3 = document3.isInBulkUpdate();
            if (isInBulkUpdate$iv3) {
                docOffsetAndVirtualModel = new DocOffsetAndVirtualModel(offset$iv, 0);
            } else {
                VisualPosition position$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)caret.getSelectionEndPosition(), (String)"caret.selectionEndPosition");
                Editor editor6 = $this$createModelPosition$iv.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor6, (String)"editor");
                int virtualDelta$iv = UtilKt.calcVirtualDelta(editor6, offset$iv, position$iv);
                docOffsetAndVirtualModel = new DocOffsetAndVirtualModel(offset$iv, virtualDelta$iv);
            }
            DocOffsetAndVirtualModel endPos = docOffsetAndVirtualModel;
            RdSelection selection = new RdSelection(startPos, endPos);
            RdCaret rdCaret = new RdCaret(id, offset, selection);
            collection.add(rdCaret);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final RdCaretState createModelCaretState(@NotNull CaretModel $this$createModelCaretState) {
        Intrinsics.checkNotNullParameter((Object)$this$createModelCaretState, (String)"$this$createModelCaretState");
        Caret caret = $this$createModelCaretState.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"primaryCaret");
        RdCaretId rdCaretId = UtilKt.getId(caret);
        if (rdCaretId == null) {
            String string = "Primary caret has no ID assigned";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RdCaretId primaryId = rdCaretId;
        return new RdCaretState(primaryId, UtilKt.createModelCarets($this$createModelCaretState));
    }

    private static final DocOffsetAndVirtualModel createModelPosition(Caret $this$createModelPosition, int offset, Function0<? extends VisualPosition> calcVisualPosition) {
        int $i$f$createModelPosition = 0;
        Editor editor = $this$createModelPosition.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        boolean isInBulkUpdate = document.isInBulkUpdate();
        if (isInBulkUpdate) {
            return new DocOffsetAndVirtualModel(offset, 0);
        }
        VisualPosition position = (VisualPosition)calcVisualPosition.invoke();
        Editor editor2 = $this$createModelPosition.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        int virtualDelta = UtilKt.calcVirtualDelta(editor2, offset, position);
        return new DocOffsetAndVirtualModel(offset, virtualDelta);
    }

    private static final int calcVirtualDelta(Editor editor, int offset, VisualPosition visualPosition) {
        int lineEndColumnNumber;
        int delta;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.visualToLogicalPosition(visualPosition)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int lineNumber = logicalPosition2.line;
        int columnNumber = logicalPosition2.column;
        if (lineNumber >= document2.getLineCount()) {
            return columnNumber;
        }
        int anchorLineEndOffset = document2.getLineEndOffset(lineNumber);
        List list = editor.getSoftWrapModel().getSoftWrapsForLine(logicalPosition2.line);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.softWrapModel.get\u2026ine(logicalPosition.line)");
        List softWraps = list;
        for (SoftWrap softWrap : softWraps) {
            boolean visuallyBeforeSoftWrap;
            if (!editor.getSoftWrapModel().isVisible(softWrap)) continue;
            SoftWrap softWrap2 = softWrap;
            Intrinsics.checkNotNullExpressionValue((Object)softWrap2, (String)"softWrap");
            int softWrapOffset = softWrap2.getStart();
            if (softWrapOffset == offset) {
                VisualPosition position;
                Intrinsics.checkNotNullExpressionValue((Object)editor.offsetToVisualPosition(offset - 1), (String)"editor.offsetToVisualPosition(offset - 1)");
                if (position.line == visualPosition.line) {
                    int delta2 = visualPosition.column - position.column - 1;
                    return delta2 < 0 ? 0 : delta2;
                }
            }
            if (softWrapOffset > offset) {
                anchorLineEndOffset = softWrapOffset;
                break;
            }
            if (softWrapOffset != offset || !(visuallyBeforeSoftWrap = visualPosition.line < editor.offsetToVisualPosition((int)offset).line)) continue;
            anchorLineEndOffset = softWrapOffset;
            break;
        }
        return (delta = columnNumber - (lineEndColumnNumber = editor.offsetToLogicalPosition((int)anchorLineEndOffset).column)) < 0 ? 0 : delta;
    }

    @NotNull
    public static final RdCaretStateChange reverse(@NotNull RdCaretStateChange $this$reverse) {
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"$this$reverse");
        return new RdCaretStateChange($this$reverse.getNewState(), $this$reverse.getOldState(), $this$reverse.getEditorId());
    }

    @NotNull
    public static final RdDocumentChange reverse(@NotNull RdDocumentChange $this$reverse) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"$this$reverse");
        if ($this$reverse.getModificationKind() == RdTextModificationKind.Reset) {
            String string2 = "Can't revert initial change";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = $this$reverse.getText();
        if (string3 != null) {
            String string4 = string3;
            int n = $this$reverse.getOffset();
            int n2 = $this$reverse.getOffset() + $this$reverse.getNewText().length();
            CharSequence charSequence = $this$reverse.getOldText();
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.replaceRange((CharSequence)string5, (int)n, (int)n2, (CharSequence)charSequence)).toString();
        } else {
            string = null;
        }
        String oldDocumentText = string;
        return new RdDocumentChange($this$reverse.getDocumentId(), $this$reverse.getOffset(), $this$reverse.getMoveOffset(), $this$reverse.getOldText(), $this$reverse.getNewText(), $this$reverse.getModificationKind(), $this$reverse.getOldDocumentLength() - $this$reverse.getOldText().length() + $this$reverse.getNewText().length(), oldDocumentText);
    }

    @NotNull
    public static final Disposable getDisposable(@NotNull Editor $this$getDisposable, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisposable, (String)"$this$getDisposable");
        Project project2 = project;
        if (project2 == null) {
            project2 = $this$getDisposable.getProject();
        }
        Project selectedProject = project2;
        String debugName = "Disposable for editor " + $this$getDisposable;
        Disposable disposable = selectedProject == null ? Disposer.newDisposable((String)debugName) : Disposer.newDisposable((Disposable)((Disposable)selectedProject), (String)debugName);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"if (selectedProject == n\u2026Project, debugName)\n    }");
        Disposable disposable2 = disposable;
        EditorUtil.disposeWithEditor((Editor)$this$getDisposable, (Disposable)disposable2);
        return disposable2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toDebugString(@NotNull RdCaretState $this$toDebugString) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        Iterable iterable = $this$toDebugString.getCarets();
        StringBuilder stringBuilder = new StringBuilder().append("(primary: ").append(UtilKt.toDebugString($this$toDebugString.getPrimaryCaretId())).append(", carets: ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdCaret rdCaret = (RdCaret)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = UtilKt.toDebugString((RdCaret)it);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(collection).append(')').toString();
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaret $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        return "(id: " + UtilKt.toDebugString($this$toDebugString.getId()) + ", offset: " + UtilKt.toDebugString($this$toDebugString.getOffset()) + ", selection: " + UtilKt.toDebugString($this$toDebugString.getSelection()) + ')';
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaretId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        return ($this$toDebugString.isClient() ? "c" : "s") + $this$toDebugString.getNumber();
    }

    @NotNull
    public static final String toDebugString(@NotNull DocOffsetAndVirtualModel $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        return "" + '(' + $this$toDebugString.getOffset() + ", " + $this$toDebugString.getVirtualDelta() + ')';
    }

    @NotNull
    public static final String toDebugString(@NotNull RdSelection $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        return "(start: " + UtilKt.toDebugString($this$toDebugString.getStart()) + " - end: " + UtilKt.toDebugString($this$toDebugString.getEnd()) + ')';
    }

    @NotNull
    public static final String toDebugString(@NotNull TextControlId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        return '(' + DocumentExKt.toDebugString($this$toDebugString.getDocumentId()) + ", " + $this$toDebugString.getTabIndex() + ", " + $this$toDebugString.getKind() + ')';
    }

    public static final int component1(@Nullable VisualPosition $this$component1) {
        VisualPosition visualPosition = $this$component1;
        return visualPosition != null ? visualPosition.line : -1;
    }

    public static final int component2(@Nullable VisualPosition $this$component2) {
        VisualPosition visualPosition = $this$component2;
        return visualPosition != null ? visualPosition.column : -1;
    }

    public static final int component1(@NotNull LogicalPosition $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"$this$component1");
        return $this$component1.line;
    }

    public static final int component2(@NotNull LogicalPosition $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"$this$component2");
        return $this$component2.column;
    }
}

