/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.LocalTimeCounter;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.ProtocolDocumentSynchronizer;
import com.jetbrains.rd.ide.document.ProtocolDocumentSynchronizerKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.requests.IdeGateway;
import com.jetbrains.rd.platform.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001;BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020)H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000203H\u0016J\u000e\u00104\u001a\u00020)2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u000209H\u0016J\u0006\u0010:\u001a\u00020)R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/rd/ide/document/ProtocolDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/intellij/openapi/Disposable;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "versionHolder", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "ideGateway", "Lcom/jetbrains/rd/ide/requests/IdeGateway;", "sendDocumentText", "", "forceWrite", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/model/RdDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;Lcom/jetbrains/rd/ide/document/DocumentLog;Lcom/jetbrains/rd/ide/requests/IdeGateway;ZZ)V", "backendUpdateInProgressMarker", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getDocumentLog", "()Lcom/jetbrains/rd/ide/document/DocumentLog;", "isReceivingChange", "()Z", "isSandbox", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "dispose", "documentChanged", "escape", "", "s", "", "getPriority", "", "receiveDocumentChange", "change", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "sendInitialTextChange", "Companion", "intellij.rd.platform"})
public final class ProtocolDocumentSynchronizer
implements PrioritizedDocumentListener,
Disposable,
DocumentSynchronizer {
    private boolean backendUpdateInProgressMarker;
    private final Logger logger;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    private final DocumentVersionHolder versionHolder;
    @NotNull
    private final DocumentLog documentLog;
    private final IdeGateway ideGateway;
    private final boolean sendDocumentText;
    private final boolean forceWrite;
    private static int debugId;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean isReceivingChange() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        return this.backendUpdateInProgressMarker;
    }

    /*
     * WARNING - void declaration
     */
    public void documentChanged(@NotNull DocumentEvent event) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.versionHolder.incrementVersion(this.document.getModificationStamp());
        if (this.backendUpdateInProgressMarker) {
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace22 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Document changed from IDEA side. Offset: ").append(event.getOffset()).append(", New fragment: '");
            CharSequence charSequence = event.getNewFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"event.newFragment");
            StringBuilder stringBuilder2 = stringBuilder.append(this.escape(charSequence)).append("', OldFragment: '");
            CharSequence charSequence2 = event.getOldFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"event.oldFragment");
            String string = stringBuilder2.append(this.escape(charSequence2)).append('\'').toString();
            logger.trace(string);
        }
        DocumentLog $i$f$trace22 = this.documentLog;
        RdDocumentVersion version$iv = this.versionHolder.getVersion();
        boolean $i$f$getOrPut = false;
        RdDocumentChange rdDocumentChange = $this$getOrPut$iv.getChange(version$iv);
        if (rdDocumentChange == null) {
            void var6_10 = $this$getOrPut$iv;
            boolean bl = false;
            boolean bl2 = false;
            void $this$run$iv = var6_10;
            boolean bl3 = false;
            boolean bl4 = false;
            RdDocumentChange change$iv = ProtocolDocumentSynchronizerKt.access$toRdDocumentChange(this.getDocumentId(), event, this.sendDocumentText);
            $this$run$iv.put(version$iv, change$iv);
            rdDocumentChange = change$iv;
        }
        RdDocumentChange change = rdDocumentChange;
        this.ideGateway.sendDocumentChange(change, this.versionHolder.getPreviousVersion(), this.versionHolder.getVersion());
    }

    public final void sendInitialTextChange() {
        RdDocumentId rdDocumentId = this.getDocumentId();
        String string = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
        RdDocumentChange change = new RdDocumentChange(rdDocumentId, 0, 0, string, "", RdTextModificationKind.Reset, -1, null);
        if (this.versionHolder.incrementVersion(this.document.getModificationStamp())) {
            this.documentLog.put(this.versionHolder.getVersion(), change);
        }
        this.ideGateway.sendDocumentChange(change, this.versionHolder.getPreviousVersion(), this.versionHolder.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveDocumentChange(@NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        try {
            this.backendUpdateInProgressMarker = true;
            if (change.getModificationKind() != RdTextModificationKind.Reset && this.document.getTextLength() != change.getOldDocumentLength()) {
                String string = "expected document length: " + change.getOldDocumentLength() + ", but actual length: " + this.document.getTextLength();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int offset = change.getOffset();
            String newText = change.getNewText();
            String oldText = change.getOldText();
            Function0<Unit> $fun$applyChange$1 = new Function0<Unit>(this, change, oldText, offset, newText){
                final /* synthetic */ ProtocolDocumentSynchronizer this$0;
                final /* synthetic */ RdDocumentChange $change;
                final /* synthetic */ String $oldText;
                final /* synthetic */ int $offset;
                final /* synthetic */ String $newText;

                public final void invoke() {
                    this.this$0.getDocumentLog().put(DocumentVersionsKt.increment(ProtocolDocumentSynchronizer.access$getVersionHolder$p(this.this$0).getVersion()), this.$change);
                    if (this.$change.getModificationKind() == RdTextModificationKind.Reset) {
                        this.this$0.getDocument().setText((CharSequence)this.$change.getNewText());
                        return;
                    }
                    CharSequence charSequence = this.$oldText;
                    int n = 0;
                    if (charSequence.length() == 0 && this.$change.getModificationKind() == RdTextModificationKind.LeftSide) {
                        n = this.this$0.getDocument().getTextLength();
                        int n2 = this.$offset + 1;
                        boolean bl = false;
                        int initialEnd = Math.min(n, n2);
                        String initialNewText = this.$newText + this.this$0.getDocument().getText(new TextRange(this.$offset, initialEnd));
                        this.this$0.getDocument().replaceString(this.$offset, initialEnd, (CharSequence)initialNewText);
                        return;
                    }
                    CharSequence initialEnd = this.$oldText;
                    int initialNewText = 0;
                    if (initialEnd.length() == 0 && this.$change.getModificationKind() == RdTextModificationKind.RightSide) {
                        initialNewText = 0;
                        int n3 = this.$offset - 1;
                        boolean bl = false;
                        int initialStart = Math.max(initialNewText, n3);
                        String initialNewText2 = this.this$0.getDocument().getText(new TextRange(initialStart, this.$offset)) + this.$newText;
                        this.this$0.getDocument().replaceString(initialStart, this.$offset, (CharSequence)initialNewText2);
                        return;
                    }
                    if (this.this$0.getDocument() instanceof DocumentImpl) {
                        ((DocumentImpl)this.this$0.getDocument()).replaceString(this.$offset, this.$offset + this.$oldText.length(), this.$change.getMoveOffset(), (CharSequence)this.$newText, LocalTimeCounter.currentTime(), false);
                        return;
                    }
                    this.this$0.getDocument().replaceString(this.$offset, this.$offset + this.$oldText.length(), (CharSequence)this.$newText);
                }
                {
                    this.this$0 = protocolDocumentSynchronizer;
                    this.$change = rdDocumentChange;
                    this.$oldText = string;
                    this.$offset = n;
                    this.$newText = string2;
                    super(0);
                }
            };
            Function0<Unit> $fun$applyChangeCheckForce$2 = new Function0<Unit>(this, $fun$applyChange$1){
                final /* synthetic */ ProtocolDocumentSynchronizer this$0;
                final /* synthetic */ receiveDocumentChange.1 $applyChange$1;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    if (ProtocolDocumentSynchronizer.access$getForceWrite$p(this.this$0) && !this.this$0.getDocument().isWritable()) {
                        this.this$0.getDocument().setReadOnly(false);
                        try {
                            this.$applyChange$1.invoke();
                        }
                        finally {
                            this.this$0.getDocument().setReadOnly(true);
                        }
                    } else {
                        this.$applyChange$1.invoke();
                    }
                }
                {
                    this.this$0 = protocolDocumentSynchronizer;
                    this.$applyChange$1 = var2_2;
                    super(0);
                }
            };
            ApplicationKt.getApplication().runWriteAction(new Runnable(this, $fun$applyChangeCheckForce$2, change){
                final /* synthetic */ ProtocolDocumentSynchronizer this$0;
                final /* synthetic */ receiveDocumentChange.2 $applyChangeCheckForce$2;
                final /* synthetic */ RdDocumentChange $change;

                public final void run() {
                    CommandProcessor instance2;
                    CommandProcessor commandProcessor = instance2 = CommandProcessor.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)commandProcessor, (String)"instance");
                    if (commandProcessor.getCurrentCommand() != null) {
                        this.$applyChangeCheckForce$2.invoke();
                    } else {
                        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this){
                            final /* synthetic */ receiveDocumentChange.3 this$0;

                            public final void run() {
                                this.this$0.$applyChangeCheckForce$2.invoke();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    if (this.$change.getText() != null && Intrinsics.areEqual((Object)this.this$0.getDocument().getText(), (Object)this.$change.getText()) ^ true) {
                        String string = "Not matched document text on version: " + ProtocolDocumentSynchronizer.access$getVersionHolder$p(this.this$0).getVersion().getValue();
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                {
                    this.this$0 = protocolDocumentSynchronizer;
                    this.$applyChangeCheckForce$2 = var2_2;
                    this.$change = rdDocumentChange;
                }
            });
        }
        finally {
            this.backendUpdateInProgressMarker = false;
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 39;
    }

    @Override
    public boolean isSandbox() {
        return this.getModelDocument().getSandboxInfo() != null;
    }

    @NotNull
    public RdDocumentVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull AbstractDocumentVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion cfr_ignored_0 = (RdDocumentVersion)v;
        this.versionHolder.resetVersion((RdDocumentVersion)v, this.document.getModificationStamp());
        this.documentLog.rollbackHistoryToVersion((RdDocumentVersion)v);
    }

    public void dispose() {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Document synchronizer is released";
            logger.trace(string);
        }
    }

    private final String escape(CharSequence s) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)s).toString(), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @Override
    @NotNull
    public RdDocumentId getDocumentId() {
        return this.documentId;
    }

    @NotNull
    public final DocumentLog getDocumentLog() {
        return this.documentLog;
    }

    public ProtocolDocumentSynchronizer(@NotNull Project project, @NotNull Document document, @NotNull RdDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull DocumentVersionHolder versionHolder, @NotNull DocumentLog documentLog, @NotNull IdeGateway ideGateway, boolean sendDocumentText, boolean forceWrite) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)modelDocument, (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkNotNullParameter((Object)documentLog, (String)"documentLog");
        Intrinsics.checkNotNullParameter((Object)ideGateway, (String)"ideGateway");
        this.document = document;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.versionHolder = versionHolder;
        this.documentLog = documentLog;
        this.ideGateway = ideGateway;
        this.sendDocumentText = sendDocumentText;
        this.forceWrite = forceWrite;
        String fileName = DocumentExKt.createLogCategory(this.getDocumentId());
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#com.jetbrains.rd.ide.document.Document#" + n + '(' + fileName + ')'));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026${debugId++}($fileName)\")");
        this.logger = logger;
        this.document.addDocumentListener((DocumentListener)this, (Disposable)this);
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ DocumentVersionHolder access$getVersionHolder$p(ProtocolDocumentSynchronizer $this) {
        return $this.versionHolder;
    }

    public static final /* synthetic */ boolean access$getForceWrite$p(ProtocolDocumentSynchronizer $this) {
        return $this.forceWrite;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/ide/document/ProtocolDocumentSynchronizer$Companion;", "", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

