/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.ProtocolDocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.platform.Range;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0016J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLogRangeShifter;", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/ProtocolDocumentSynchronizer;", "(Lcom/jetbrains/rd/ide/document/ProtocolDocumentSynchronizer;)V", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "getDocumentLog", "()Lcom/jetbrains/rd/ide/document/DocumentLog;", "getDocumentSynchronizer", "()Lcom/jetbrains/rd/ide/document/ProtocolDocumentSynchronizer;", "checkVersions", "", "initialRangeVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "shiftOnePoint", "", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "offset", "isStickingToRight", "shiftRange", "Lcom/jetbrains/rd/platform/Range;", "range", "isVerifiable", "isGreedyToLeft", "isGreedyToRight", "shrinkHistory", "", "intellij.rd.platform"})
public final class DocumentLogRangeShifter
implements IDocumentRangeShifter {
    @NotNull
    private final ProtocolDocumentSynchronizer documentSynchronizer;

    private final DocumentLog getDocumentLog() {
        return this.getDocumentSynchronizer().getDocumentLog();
    }

    @Override
    public void shrinkHistory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Range shiftRange(@NotNull AbstractDocumentVersion v, @NotNull Range range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl = range.isNormalized();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DocumentLogRangeShifter$shiftRange$22 = false;
            String $i$a$-assert-DocumentLogRangeShifter$shiftRange$22 = "Range: " + range + " is not normalized";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DocumentLogRangeShifter$shiftRange$22));
        }
        RdDocumentVersion initialVersion = (RdDocumentVersion)v;
        if (!this.checkVersions(initialVersion)) {
            return Range.Companion.getInvalidRange();
        }
        int resultStart = range.getStart();
        int resultEnd = range.getEnd();
        Iterator<Map.Entry<RdDocumentVersion, RdDocumentChange>> iterator = this.getDocumentLog().iterator();
        while (iterator.hasNext()) {
            void version;
            Map.Entry<RdDocumentVersion, RdDocumentChange> entry;
            Map.Entry<RdDocumentVersion, RdDocumentChange> entry2 = entry = iterator.next();
            boolean bl3 = false;
            RdDocumentVersion rdDocumentVersion = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            RdDocumentChange change = entry2.getValue();
            if (version.getValue() <= initialVersion.getValue()) continue;
            int oldLength = change.getOldText().length();
            int newLength = change.getNewText().length();
            int start = change.getOffset();
            int end = start + oldLength;
            int delta = newLength - oldLength;
            if (oldLength == 0 && change.getMoveOffset() != start) {
                int n = change.getMoveOffset();
                boolean bl4 = false;
                boolean bl5 = false;
                int it = n;
                boolean bl6 = false;
                int moveOffset = it > start ? it - newLength : it;
                if (moveOffset <= resultStart && resultEnd <= moveOffset + newLength) {
                    int moveDelta = start - moveOffset;
                    resultStart += moveDelta;
                    resultEnd += moveDelta;
                    continue;
                }
            }
            if (resultEnd == start && (change.getModificationKind() == RdTextModificationKind.RightSide || isGreedyToRight)) {
                resultEnd += delta;
                continue;
            }
            if (resultEnd <= start) continue;
            if (resultStart == end && (change.getModificationKind() == RdTextModificationKind.LeftSide || isGreedyToLeft)) {
                resultEnd += delta;
                continue;
            }
            if (resultStart >= end) {
                resultStart += delta;
                resultEnd += delta;
                continue;
            }
            if (resultStart <= start && end <= resultEnd && !isVerifiable) {
                resultEnd += delta;
                continue;
            }
            return Range.Companion.getInvalidRange();
        }
        return new Range(resultStart, resultEnd);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int shiftOnePoint(@NotNull AbstractDocumentVersion v, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion initialVersion = (RdDocumentVersion)v;
        if (!this.checkVersions(initialVersion)) {
            return -1;
        }
        int resultOffset = offset;
        Iterator<Map.Entry<RdDocumentVersion, RdDocumentChange>> iterator = this.getDocumentLog().iterator();
        while (iterator.hasNext()) {
            void version;
            Map.Entry<RdDocumentVersion, RdDocumentChange> entry;
            Map.Entry<RdDocumentVersion, RdDocumentChange> entry2 = entry = iterator.next();
            boolean bl = false;
            RdDocumentVersion rdDocumentVersion = entry2.getKey();
            entry2 = entry;
            bl = false;
            RdDocumentChange change = entry2.getValue();
            if (version.getValue() <= initialVersion.getValue()) continue;
            int oldLength = change.getOldText().length();
            int start = change.getOffset();
            int end = start + oldLength;
            int delta = change.getNewText().length() - change.getOldText().length();
            if (resultOffset < start) continue;
            if (resultOffset > end || isStickingToRight && oldLength == 0) {
                resultOffset += delta;
                continue;
            }
            return -1;
        }
        return resultOffset;
    }

    private final boolean checkVersions(RdDocumentVersion initialRangeVersion) {
        return this.getDocumentLog().contains(initialRangeVersion);
    }

    @Override
    @NotNull
    public ProtocolDocumentSynchronizer getDocumentSynchronizer() {
        return this.documentSynchronizer;
    }

    public DocumentLogRangeShifter(@NotNull ProtocolDocumentSynchronizer documentSynchronizer) {
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        this.documentSynchronizer = documentSynchronizer;
    }
}

