/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogKt;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0003J\u001b\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0011H\u0096\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLog;", "", "", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "()V", "history", "Ljava/util/TreeMap;", "<set-?>", "lastKnownVersion", "getLastKnownVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "contains", "", "version", "getChange", "iterator", "", "put", "", "change", "rollbackHistoryToVersion", "v", "shrinkHistory", "updateLastKnownVersion", "newVersion", "intellij.rd.platform"})
public class DocumentLog
implements Iterable<Map.Entry<? extends RdDocumentVersion, ? extends RdDocumentChange>>,
KMappedMarker {
    private final TreeMap<RdDocumentVersion, RdDocumentChange> history = new TreeMap(history.1.INSTANCE);
    @NotNull
    private RdDocumentVersion lastKnownVersion = DocumentVersionsKt.getInitialDocVersion();

    @NotNull
    public final RdDocumentVersion getLastKnownVersion() {
        return this.lastKnownVersion;
    }

    public void updateLastKnownVersion(@NotNull RdDocumentVersion newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        if (this.lastKnownVersion.getValue() < newVersion.getValue()) {
            this.lastKnownVersion = newVersion;
            this.shrinkHistory(newVersion);
        }
    }

    public final boolean contains(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Map map = this.history;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        return map2.containsKey(version);
    }

    @Nullable
    public final RdDocumentChange getChange(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.history.get(version);
    }

    public final void put(@NotNull RdDocumentVersion version, @NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        boolean bl = !this.history.containsKey(version);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Document log already contains change on " + version;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ((Map)this.history).put(version, change);
    }

    private final void shrinkHistory(RdDocumentVersion lastKnownVersion) {
        Iterator<RdDocumentVersion> it = this.history.keySet().iterator();
        int removedEntries = 0;
        while (it.hasNext()) {
            RdDocumentVersion version;
            Intrinsics.checkNotNullExpressionValue((Object)it.next(), (String)"it.next()");
            if (version.getValue() >= lastKnownVersion.getValue()) break;
            it.remove();
            int n = removedEntries;
            removedEntries = n + 1;
        }
        Logger $this$trace$iv = DocumentLogKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "DocumentLog was shrunk to " + lastKnownVersion + " version; removed entries: " + removedEntries + ", new size: " + this.history.size();
            logger.trace(string);
        }
    }

    public void rollbackHistoryToVersion(@NotNull RdDocumentVersion v) {
        RdDocumentVersion version;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Iterator<RdDocumentVersion> iterator = this.history.descendingKeySet().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"history.descendingKeySet().iterator()");
        Iterator<RdDocumentVersion> it = iterator;
        int removedEntries = 0;
        while (it.hasNext() && (version = it.next()).getValue() > v.getValue()) {
            it.remove();
            int n = removedEntries;
            removedEntries = n + 1;
        }
        Logger $this$trace$iv = DocumentLogKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "DocumentLog rollback history to " + v + "; removed entries: " + removedEntries + ", new size: " + this.history.size();
            logger.trace(string);
        }
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<RdDocumentVersion, RdDocumentChange>> iterator() {
        Map map = this.history;
        boolean bl = false;
        return map.entrySet().iterator();
    }
}

